/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.plugin.Plugin;
import de.dal33t.powerfolder.plugin.PluginEvent;
import de.dal33t.powerfolder.plugin.PluginManager;
import de.dal33t.powerfolder.plugin.PluginManagerListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.SelectionBaseAction;
import de.dal33t.powerfolder.ui.event.SelectionChangeEvent;
import de.dal33t.powerfolder.ui.event.SelectionModel;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.preferences.PreferencesDialog;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PluginSettingsTab
extends PFUIComponent
implements PreferenceTab {
    private static final int PLUGIN_NAME_COL = 0;
    private static final int PLUGIN_DESCR_COL = 1;
    private static final int PLUGIN_CLASS_COL = 2;
    private static final int PLUGIN_STATUS_COL = 3;
    private PreferencesDialog preferencesDialog;
    private JPanel panel;
    private JTable pluginJTable;
    private JScrollPane pluginPane;
    private JButton settingsButton;
    private JButton enableButton;
    private SelectionModel selectionModel;

    public PluginSettingsTab(Controller controller, PreferencesDialog preferencesDialog) {
        super(controller);
        this.preferencesDialog = preferencesDialog;
        this.selectionModel = new SelectionModel();
        this.initComponents();
    }

    @Override
    public boolean needsRestart() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.plugin.title");
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, fill:pref:grow, 3dlu, pref, 3dlu");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.pluginPane, cellConstraints.xy(2, 2));
            panelBuilder.add(this.getButtonBar(), cellConstraints.xy(2, 4));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private void initComponents() {
        this.pluginJTable = new JTable(new PluginTableModel());
        this.pluginJTable.setDefaultRenderer(Plugin.class, new PluginTableRenderer());
        this.pluginPane = new JScrollPane(this.pluginJTable);
        UIUtil.whiteStripTable(this.pluginJTable);
        UIUtil.removeBorder(this.pluginPane);
        UIUtil.setZeroHeight(this.pluginPane);
        this.pluginJTable.getSelectionModel().setSelectionMode(0);
        this.pluginJTable.getSelectionModel().addListSelectionListener(new PluginTableListSelectionListener());
        this.settingsButton = new JButton(new SettingsAction(this.getController(), this.selectionModel));
        this.enableButton = new JButton(new EnableAction(this.getController(), this.selectionModel));
        this.pluginJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Plugin plugin = (Plugin)PluginSettingsTab.this.selectionModel.getSelection();
                    if (plugin == null) {
                        return;
                    }
                    if (PluginSettingsTab.this.getController().getPluginManager().isEnabled(plugin)) {
                        if (plugin.hasOptionsDialog()) {
                            plugin.showOptionsDialog(PluginSettingsTab.this.preferencesDialog);
                        }
                    } else {
                        PluginSettingsTab.this.getController().getPluginManager().setEnabled(plugin, true);
                        if (plugin.hasOptionsDialog()) {
                            plugin.showOptionsDialog(PluginSettingsTab.this.preferencesDialog);
                        }
                    }
                }
            }
        });
        this.getController().getPluginManager().addPluginManagerListener(new MyPluginManagerListener());
    }

    private Component getButtonBar() {
        return ButtonBarFactory.buildCenteredBar(this.enableButton, this.settingsButton);
    }

    private class PluginTableModel
    extends AbstractTableModel {
        private PluginTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Plugin.class;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Translation.get("exp.preferences.plugin.name");
                }
                case 1: {
                    return Translation.get("exp.preferences.plugin.description");
                }
                case 2: {
                    return Translation.get("exp.preferences.plugin.class_name");
                }
                case 3: {
                    return Translation.get("exp.preferences.plugin.status");
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            PluginManager pluginManager = PluginSettingsTab.this.getController().getPluginManager();
            return pluginManager.countPlugins();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PluginManager pluginManager = PluginSettingsTab.this.getController().getPluginManager();
            List<Plugin> list = pluginManager.getPlugins();
            return list.get(n);
        }
    }

    private class PluginTableRenderer
    extends DefaultTableCellRenderer {
        private PluginTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            PluginManager pluginManager = PluginSettingsTab.this.getController().getPluginManager();
            List<Plugin> list = pluginManager.getPlugins();
            Plugin plugin = list.get(n);
            boolean bl3 = PluginSettingsTab.this.getController().getPluginManager().isEnabled(plugin);
            if (bl3) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.LIGHT_GRAY);
            }
            int n3 = UIUtil.toModel(jTable, n2);
            switch (n3) {
                case 0: {
                    string = plugin.getName();
                    this.setToolTipText(plugin.getName());
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    string = plugin.getDescription();
                    this.setToolTipText(plugin.getDescription());
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    string = plugin.getClass().getName();
                    this.setToolTipText(plugin.getClass().getName());
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 3: {
                    string = bl3 ? Translation.get("exp.preferences.plugin.status_enabled") : Translation.get("exp.preferences.plugin.status_disabled");
                    this.setToolTipText(string);
                    this.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    return null;
                }
            }
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    private class PluginTableListSelectionListener
    implements ListSelectionListener {
        private PluginTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = PluginSettingsTab.this.pluginJTable.getSelectedRows();
            if (nArray.length != 0 && !listSelectionEvent.getValueIsAdjusting()) {
                Object[] objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = PluginSettingsTab.this.pluginJTable.getModel().getValueAt(nArray[i], 0);
                }
                PluginSettingsTab.this.selectionModel.setSelections(objectArray);
            } else {
                PluginSettingsTab.this.selectionModel.setSelection(null);
            }
        }
    }

    private class SettingsAction
    extends SelectionBaseAction {
        public SettingsAction(Controller controller, SelectionModel selectionModel) {
            super("exp.preferences.plugin.settings", controller, selectionModel);
            this.setEnabled(false);
        }

        @Override
        public void selectionChanged(SelectionChangeEvent selectionChangeEvent) {
            Plugin plugin = (Plugin)selectionChangeEvent.getSelection();
            if (plugin != null) {
                this.setEnabled(this.getController().getPluginManager().isEnabled(plugin) && plugin.hasOptionsDialog());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Plugin plugin = (Plugin)PluginSettingsTab.this.selectionModel.getSelection();
            if (plugin != null && plugin.hasOptionsDialog()) {
                plugin.showOptionsDialog(PluginSettingsTab.this.preferencesDialog);
            }
        }
    }

    private class EnableAction
    extends SelectionBaseAction {
        public EnableAction(Controller controller, SelectionModel selectionModel) {
            super("exp.preferences.plugin.enable", controller, selectionModel);
            this.setEnabled(false);
        }

        @Override
        public void selectionChanged(SelectionChangeEvent selectionChangeEvent) {
            this.updateButton((Plugin)selectionChangeEvent.getSelection());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Plugin plugin = (Plugin)this.getSelectionModel().getSelection();
            boolean bl = !this.getController().getPluginManager().isEnabled(plugin);
            this.getController().getPluginManager().setEnabled(plugin, bl);
        }

        private void updateButton(Plugin plugin) {
            if (plugin == null || plugin.getClass().getName().equals("de.dal33t.powerfolder.CD") || plugin.getClass().getName().equals("de.dal33t.powerfolder.BC")) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                if (this.getController().getPluginManager().isEnabled(plugin)) {
                    this.putValue("Name", Translation.get("exp.preferences.plugin.disable.name"));
                    this.putValue("ShortDescription", Translation.get("exp.preferences.plugin.disable.description"));
                    this.putValue("AcceleratorKey", Translation.get("exp.preferences.plugin.disable.key"));
                } else {
                    this.putValue("Name", Translation.get("exp.preferences.plugin.enable.name"));
                    this.putValue("ShortDescription", Translation.get("exp.preferences.plugin.enable.description"));
                    this.putValue("AcceleratorKey", Translation.get("exp.preferences.plugin.enable.key"));
                }
            }
        }
    }

    private class MyPluginManagerListener
    implements PluginManagerListener {
        private MyPluginManagerListener() {
        }

        @Override
        public void pluginStatusChanged(PluginEvent pluginEvent) {
            ((PluginTableModel)PluginSettingsTab.this.pluginJTable.getModel()).fireTableRowsUpdated(-1, -1);
            PluginSettingsTab.this.settingsButton.setEnabled(false);
            PluginSettingsTab.this.enableButton.setEnabled(false);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

