/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineSpeedSelectionPanel
extends PFUIComponent {
    private static final int UNLIMITED = 0;
    private static final int AUTO_DETECT = -1;
    private static final int AUTOMATIC_INDEX = 0;
    private final boolean wan;
    private JPanel uiComponent;
    private JComboBox<LineSpeed> speedSelectionBox;
    private JComponent customSpeedPanel;
    private SpinnerNumberModel customUploadSpeedSpinnerModel;
    private SpinnerNumberModel customDownloadSpeedSpinnerModel;
    private JSpinner customUploadSpeedSpinner;
    private JLabel customUploadSpeedText;
    private JSpinner customDownloadSpeedSpinner;
    private JLabel customDownloadSpeedText;
    private final boolean showCustomEntry;
    private JLabel customUploadKbPerSLabel;
    private JLabel customDownloadKbPerSLabel;
    private JButton recalculateAutoButton;

    public LineSpeedSelectionPanel(Controller controller, boolean bl, boolean bl2) {
        super(controller);
        this.showCustomEntry = bl2;
        this.wan = bl;
        this.initComponents();
    }

    public JPanel getUiComponent() {
        if (this.uiComponent == null) {
            this.buildPanel();
        }
        return this.uiComponent;
    }

    private void initComponents() {
        RecalculateAction recalculateAction = new RecalculateAction(this.getController());
        this.recalculateAutoButton = new JButton(recalculateAction);
        this.customUploadSpeedSpinnerModel = new SpinnerNumberModel(0, 0, 999999, 5);
        this.customDownloadSpeedSpinnerModel = new SpinnerNumberModel(0, 0, 999999, 5);
        this.customUploadSpeedText = new JLabel();
        this.customUploadSpeedSpinner = new JSpinner(this.customUploadSpeedSpinnerModel);
        this.customDownloadSpeedText = new JLabel("");
        this.customDownloadSpeedSpinner = new JSpinner(this.customDownloadSpeedSpinnerModel);
        this.customUploadKbPerSLabel = new JLabel(Translation.get("general.kbPerS"));
        this.customDownloadKbPerSLabel = new JLabel(Translation.get("general.kbPerS"));
        this.customUploadSpeedSpinnerModel.addChangeListener(new MyChangeListener(this.customUploadSpeedText));
        this.customDownloadSpeedSpinnerModel.addChangeListener(new MyChangeListener(this.customDownloadSpeedText));
        this.customSpeedPanel = this.createCustomSpeedInputFieldPanel();
        this.speedSelectionBox = new JComboBox();
        if (this.wan) {
            this.loadWanSelection();
        } else {
            this.loadLanSelection();
        }
        this.speedSelectionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineSpeedSelectionPanel.this.configureUpDownComponents();
            }
        });
        this.configureUpDownComponents();
    }

    private void buildPanel() {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, 1dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.customSpeedPanel.setBorder(Borders.createEmptyBorder("0, 0, 3dlu, 0"));
        JPanel jPanel = this.createSpeedSelectionPanel();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.customSpeedPanel, cellConstraints.xy(1, 3));
        this.uiComponent = panelBuilder.getPanel();
        this.uiComponent.setOpaque(false);
    }

    private void configureUpDownComponents() {
        boolean bl;
        this.customSpeedPanel.setVisible(this.showCustomEntry);
        boolean bl2 = bl = this.wan && this.speedSelectionBox.getSelectedIndex() == 0;
        if (((LineSpeed)this.speedSelectionBox.getSelectedItem()).isEditable()) {
            this.customUploadSpeedSpinner.setVisible(true);
            this.customDownloadSpeedSpinner.setVisible(true);
            this.customUploadKbPerSLabel.setVisible(true);
            this.customDownloadKbPerSLabel.setVisible(true);
            this.customUploadSpeedText.setVisible(false);
            this.customDownloadSpeedText.setVisible(false);
            this.customUploadSpeedSpinnerModel.setValue(0);
            this.customDownloadSpeedSpinnerModel.setValue(0);
        } else {
            this.customUploadSpeedSpinner.setVisible(false);
            this.customDownloadSpeedSpinner.setVisible(false);
            this.customUploadKbPerSLabel.setVisible(false);
            this.customDownloadKbPerSLabel.setVisible(false);
            this.customUploadSpeedText.setVisible(true);
            this.customDownloadSpeedText.setVisible(true);
            if (!bl) {
                this.customUploadSpeedSpinnerModel.setValue(((LineSpeed)this.speedSelectionBox.getSelectedItem()).getUploadSpeed());
                this.customDownloadSpeedSpinnerModel.setValue(((LineSpeed)this.speedSelectionBox.getSelectedItem()).getDownloadSpeed());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long l = LineSpeedSelectionPanel.this.customUploadSpeedSpinnerModel.getNumber().longValue();
                        LineSpeedSelectionPanel.updateLabel(LineSpeedSelectionPanel.this.customUploadSpeedText, l);
                        l = LineSpeedSelectionPanel.this.customDownloadSpeedSpinnerModel.getNumber().longValue();
                        LineSpeedSelectionPanel.updateLabel(LineSpeedSelectionPanel.this.customDownloadSpeedText, l);
                    }
                });
            }
        }
        this.recalculateAutoButton.setVisible(bl);
        if (bl) {
            TransferManager transferManager = this.getController().getTransferManager();
            if (transferManager.getUploadCPSForWAN() > 0L) {
                this.customUploadSpeedText.setText(transferManager.getUploadCPSForWAN() / 1024L + " " + Translation.get("general.kbPerS"));
            } else {
                this.customUploadSpeedText.setText(Translation.get("line_speed.unlimited"));
            }
            if (transferManager.getDownloadCPSForWAN() > 0L) {
                this.customDownloadSpeedText.setText(transferManager.getDownloadCPSForWAN() / 1024L + " " + Translation.get("general.kbPerS"));
            } else {
                this.customDownloadSpeedText.setText(Translation.get("line_speed.unlimited"));
            }
        }
    }

    private JPanel createSpeedSelectionPanel() {
        FormLayout formLayout = new FormLayout("80dlu, 3dlu, pref, pref:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(this.speedSelectionBox, cellConstraints.xy(1, 1));
        if (this.wan) {
            panelBuilder.add((Component)this.recalculateAutoButton, cellConstraints.xy(3, 1));
        }
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JPanel createCustomSpeedInputFieldPanel() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, 25dlu, 3dlu, 25dlu, 3dlu, pref, 3dlu, 25dlu, 3dlu, 25dlu", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("line_speed.download_speed")), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.customDownloadSpeedSpinner, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.customDownloadKbPerSLabel, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.customDownloadSpeedText, cellConstraints.xyw(3, 1, 3));
        panelBuilder.add((Component)new JLabel(Translation.get("line_speed.upload_speed")), cellConstraints.xy(7, 1));
        panelBuilder.add((Component)this.customUploadSpeedSpinner, cellConstraints.xy(9, 1));
        panelBuilder.add((Component)this.customUploadKbPerSLabel, cellConstraints.xy(11, 1));
        panelBuilder.add((Component)this.customUploadSpeedText, cellConstraints.xyw(9, 1, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void loadLanSelection() {
        this.addLineSpeed("line_speed.lan10", 1000L, 0L);
        this.addLineSpeed("line_speed.lan100", 10000L, 0L);
        this.addLineSpeed("line_speed.lan1000", 100000L, 0L);
        this.addLineSpeed("line_speed.unlimited", 0L, 0L);
        if (this.showCustomEntry) {
            this.addLineSpeed("line_speed.custom_speed", 0L, 0L, true);
        }
    }

    private void loadWanSelection() {
        this.addLineSpeed("line_speed.auto_speed", -1L, -1L);
        this.addLineSpeed("line_speed.adsl128", 11L, 0L);
        this.addLineSpeed("line_speed.adsl256", 23L, 0L);
        this.addLineSpeed("line_speed.adsl512", 46L, 0L);
        this.addLineSpeed("line_speed.adsl768", 69L, 0L);
        this.addLineSpeed("line_speed.adsl1024", 128L, 0L);
        this.addLineSpeed("line_speed.adsl1536", 192L, 0L);
        this.addLineSpeed("line_speed.T1", 140L, 0L);
        this.addLineSpeed("line_speed.T3", 3930L, 0L);
        this.addLineSpeed("line_speed.unlimited", 0L, 0L);
        if (this.showCustomEntry) {
            this.addLineSpeed("line_speed.custom_speed", 0L, 0L, true);
        }
    }

    private LineSpeed addLineSpeed(String string, long l, long l2) {
        return this.addLineSpeed(string, l, l2, false);
    }

    private LineSpeed addLineSpeed(String string, long l, long l2, boolean bl) {
        LineSpeed lineSpeed = new LineSpeed(Translation.get(string), l, l2, bl);
        this.addLineSpeed(lineSpeed);
        return lineSpeed;
    }

    public void addLineSpeed(LineSpeed lineSpeed) {
        this.speedSelectionBox.addItem(lineSpeed);
    }

    public void removeLineSpeed(LineSpeed lineSpeed) {
        this.speedSelectionBox.removeItem(lineSpeed);
    }

    public void setSpeedKBPS(boolean bl, long l, long l2) {
        if (bl) {
            this.speedSelectionBox.setSelectedItem(0);
        } else {
            int n = this.speedSelectionBox.getItemCount();
            for (int i = 0; i < n; ++i) {
                LineSpeed lineSpeed = this.speedSelectionBox.getItemAt(i);
                if (lineSpeed.getUploadSpeed() != l || lineSpeed.getDownloadSpeed() != l2) continue;
                this.speedSelectionBox.setSelectedItem(lineSpeed);
                return;
            }
            if (this.showCustomEntry) {
                this.speedSelectionBox.setSelectedIndex(n - 1);
                this.customUploadSpeedSpinner.setValue(l);
                this.customDownloadSpeedSpinner.setValue(l2);
            }
        }
    }

    public boolean isAutomatic() {
        return this.wan && this.speedSelectionBox.getSelectedIndex() == 0;
    }

    public long getUploadSpeedKBPS() {
        return this.customUploadSpeedSpinnerModel.getNumber().longValue() * 1024L;
    }

    public long getDownloadSpeedKBPS() {
        return this.customDownloadSpeedSpinnerModel.getNumber().longValue() * 1024L;
    }

    public void setEnabled(boolean bl) {
        this.customSpeedPanel.setEnabled(bl);
        this.speedSelectionBox.setEnabled(bl);
        this.customUploadSpeedSpinner.setEnabled(bl);
        this.customDownloadSpeedSpinner.setEnabled(bl);
        this.customUploadSpeedText.setEnabled(bl);
        this.customDownloadSpeedText.setEnabled(bl);
    }

    private static void updateLabel(JLabel jLabel, long l) {
        if (l == 0L) {
            jLabel.setText(Translation.get("line_speed.unlimited"));
        } else {
            jLabel.setText(l + " " + Translation.get("general.kbPerS"));
        }
    }

    private class RecalculateAction
    extends BaseAction {
        private RecalculateAction(Controller controller) {
            super("action_recalculate", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TransferManager transferManager = RecalculateAction.this.getController().getTransferManager();
                    FutureTask<Object> futureTask = transferManager.getRecalculateAutomaticRate();
                    RecalculateAction.this.getController().getIOProvider().startIO(futureTask);
                    Cursor cursor = CursorUtils.setWaitCursor(LineSpeedSelectionPanel.this.getUiComponent());
                    try {
                        futureTask.get();
                        LineSpeedSelectionPanel.updateLabel(LineSpeedSelectionPanel.this.customUploadSpeedText, transferManager.getUploadCPSForWAN() / 1024L);
                        LineSpeedSelectionPanel.updateLabel(LineSpeedSelectionPanel.this.customDownloadSpeedText, transferManager.getDownloadCPSForWAN() / 1024L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                    }
                    finally {
                        CursorUtils.returnToOriginal(LineSpeedSelectionPanel.this.getUiComponent(), cursor);
                    }
                }
            });
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private final JLabel label;

        private MyChangeListener(JLabel jLabel) {
            this.label = jLabel;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)changeEvent.getSource();
            long l = spinnerNumberModel.getNumber().longValue();
            LineSpeedSelectionPanel.updateLabel(this.label, l);
        }
    }

    private static class LineSpeed {
        private long uploadSpeed;
        private long downloadSpeed;
        private String desc;
        private boolean editable;

        LineSpeed(String string, long l, long l2, boolean bl) {
            this.desc = string;
            this.uploadSpeed = l;
            this.downloadSpeed = l2;
            this.editable = bl;
        }

        public long getUploadSpeed() {
            return this.uploadSpeed;
        }

        public String toString() {
            return this.desc;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public long getDownloadSpeed() {
            return this.downloadSpeed;
        }
    }
}

