/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.panel;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ArchiveModeSelectorPanel
extends PFUIComponent {
    private final Set<NameValuePair> pairs = new TreeSet<NameValuePair>();
    private JComboBox<String> archiveCombo;
    private JButtonMini purgeButton;
    private JPanel panel;
    private List<ValueModel> versionModels;
    private ActionListener purgeListener;

    public ArchiveModeSelectorPanel(Controller controller, List<ValueModel> list, ActionListener actionListener) {
        super(controller);
        this.versionModels = list;
        this.purgeListener = actionListener;
        this.initComponents();
    }

    public ArchiveModeSelectorPanel(Controller controller, ValueModel valueModel) {
        super(controller);
        this.versionModels = Collections.singletonList(valueModel);
        this.initComponents();
    }

    public void setChangeable(boolean bl) {
        this.archiveCombo.setEnabled(bl);
        this.purgeButton.setVisible(bl);
    }

    public void setArchiveMode(int n) {
        if (n == 0) {
            this.archiveCombo.setSelectedIndex(0);
        } else if (n == -1) {
            this.archiveCombo.setSelectedIndex(this.pairs.size() - 1);
        } else {
            int n2 = 0;
            for (NameValuePair nameValuePair : this.pairs) {
                if (n2 != 0 && n <= nameValuePair.getValue()) {
                    this.archiveCombo.setSelectedIndex(n2);
                    return;
                }
                ++n2;
            }
            this.archiveCombo.setSelectedIndex(this.pairs.size() - 1);
        }
        this.fireChange();
    }

    public Component getUIComponent() {
        if (this.panel == null) {
            this.buildPanel();
        }
        return this.panel;
    }

    private void initComponents() {
        this.pairs.clear();
        this.pairs.add(new NameValuePair(0, Translation.get("archive_mode_selector_panel.none"), 0));
        this.pairs.add(new NameValuePair(1, Translation.get("archive_mode_selector_panel.version", "1"), 1));
        this.pairs.add(new NameValuePair(5, Translation.get("archive_mode_selector_panel.versions", "5"), 5));
        this.pairs.add(new NameValuePair(9, Translation.get("archive_mode_selector_panel.versions", "25"), 25));
        this.pairs.add(new NameValuePair(10, Translation.get("archive_mode_selector_panel.versions", "100"), 100));
        this.pairs.add(new NameValuePair(11, Translation.get("archive_mode_selector_panel.unlimited"), -1));
        String[] stringArray = new String[this.pairs.size()];
        int n = 0;
        for (NameValuePair nameValuePair : this.pairs) {
            stringArray[n++] = nameValuePair.getName();
        }
        this.archiveCombo = new JComboBox<String>(stringArray);
        this.archiveCombo.addItemListener(new MyItemListener());
    }

    private void fireChange() {
        int n = this.archiveCombo.getSelectedIndex();
        if (n <= 0) {
            for (ValueModel valueModel : this.versionModels) {
                valueModel.setValue(0);
            }
        } else {
            for (ValueModel valueModel : this.versionModels) {
                valueModel.setValue(this.pairs.toArray(new NameValuePair[0])[n].getValue());
            }
        }
    }

    private void buildPanel() {
        String string = this.purgeListener != null ? "pref, 3dlu, pref, pref:grow" : "pref:grow";
        FormLayout formLayout = new FormLayout(string, "pref");
        this.panel = new JPanel(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.panel.add(this.archiveCombo, cellConstraints.xy(1, 1));
        if (this.purgeListener != null) {
            this.purgeButton = new JButtonMini(Icons.getIconById("delete.icon"), Translation.get("archive_mode_selector_panel.purge.tip"));
            this.purgeButton.addActionListener(this.purgeListener);
            this.panel.add((Component)this.purgeButton, cellConstraints.xy(3, 1));
        }
        this.panel.setOpaque(false);
    }

    private static class NameValuePair
    implements Comparable<NameValuePair> {
        private final int order;
        private final String name;
        private final int value;

        private NameValuePair(int n, String string, int n2) {
            this.order = n;
            this.name = string;
            this.value = n2;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int compareTo(@NotNull NameValuePair nameValuePair) {
            return this.order - nameValuePair.order;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NameValuePair)) {
                return false;
            }
            NameValuePair nameValuePair = (NameValuePair)object;
            return this.order == nameValuePair.order;
        }

        public int hashCode() {
            return this.order;
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ArchiveModeSelectorPanel.this.archiveCombo) {
                ArchiveModeSelectorPanel.this.fireChange();
            }
        }
    }
}

