/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.OverallFolderStatListener;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.event.TransferManagerListener;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.PFUIComponent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;

public class SyncingModel
extends PFUIComponent {
    private final MyFolderListener folderListener;
    private final OverallFolderStatListener overallFolderStatListenerSupport;
    private boolean syncing = false;
    private Date lastSyncDate = null;
    private Date estimatedSyncDate = null;
    private double overallSyncPercentage = 0.0;
    private final List<FolderInfo> interestedFolders = new ArrayList<FolderInfo>();

    SyncingModel(Controller controller) {
        super(controller);
        this.folderListener = new MyFolderListener();
        this.overallFolderStatListenerSupport = ListenerSupportFactory.createListenerSupport(OverallFolderStatListener.class);
        this.calculateOverallStats();
        FolderRepository folderRepository = controller.getFolderRepository();
        for (Folder folder : folderRepository.getFolders(true)) {
            folder.addFolderListener(this.folderListener);
        }
        controller.getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        controller.getTransferManager().addListener(new MyTransferManagerListener());
        controller.getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
    }

    public void addOverallFolderStatListener(OverallFolderStatListener overallFolderStatListener) {
        ListenerSupportFactory.addListener(this.overallFolderStatListenerSupport, overallFolderStatListener);
    }

    public void removeOverallFolderStatListener(OverallFolderStatListener overallFolderStatListener) {
        ListenerSupportFactory.removeListener(this.overallFolderStatListenerSupport, overallFolderStatListener);
    }

    public boolean isSyncing() {
        return this.syncing;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public Date getEstimatedSyncDate() {
        return this.estimatedSyncDate;
    }

    public double getOverallSyncPercentage() {
        return this.overallSyncPercentage;
    }

    private void calculateOverallStats() {
        boolean bl = false;
        Date date = null;
        Date date2 = null;
        double d = 0.0;
        long l = 0L;
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            double d2;
            if (folder.isTransferring()) {
                bl = true;
            }
            Date date3 = folder.getLastSyncDate();
            Date date4 = folder.getStatistic().getEstimatedSyncDate();
            if (date3 != null && (date == null || date3.after(date))) {
                date = date3;
            }
            if (date4 != null && (date2 == null || date4.after(date2))) {
                date2 = date4;
            }
            if (!((d2 = folder.getStatistic().getHarmonizedSyncPercentage()) > 0.0)) continue;
            l += folder.getStatistic().getTotalSize();
            d += d2 * (double)folder.getStatistic().getTotalSize();
        }
        d = l == 0L ? 0.0 : (d /= (double)l);
        if (!this.getController().getOSClient().getServer().isCompletelyConnected()) {
            d = -1.0;
        }
        this.syncing = bl;
        this.lastSyncDate = date;
        this.estimatedSyncDate = date2;
        this.overallSyncPercentage = d;
        this.overallFolderStatListenerSupport.statCalculated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestedFolderInfo(FolderInfo folderInfo) {
        List<FolderInfo> list = this.interestedFolders;
        synchronized (list) {
            this.interestedFolders.add(folderInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterestedFolderInfo(FolderInfo folderInfo) {
        List<FolderInfo> list = this.interestedFolders;
        synchronized (list) {
            this.interestedFolders.remove(folderInfo);
        }
    }

    private class MyFolderListener
    extends FolderAdapter {
        private MyFolderListener() {
        }

        @Override
        public void statisticsCalculated(FolderEvent folderEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scanResultCommitted(final FolderEvent folderEvent) {
            if (folderEvent.getScanResult().isChangeDetected()) {
                SyncingModel.this.calculateOverallStats();
            }
            FolderInfo folderInfo = folderEvent.getFolder().getInfo();
            List list = SyncingModel.this.interestedFolders;
            synchronized (list) {
                if (SyncingModel.this.interestedFolders.contains(folderInfo)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SyncingModel.this.getUIController().scanResultCreated(folderEvent.getScanResult());
                        }
                    });
                    SyncingModel.this.interestedFolders.remove(folderInfo);
                }
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getFolder().addFolderListener(SyncingModel.this.folderListener);
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getFolder().removeFolderListener(SyncingModel.this.folderListener);
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getOldFolder().removeFolderListener(SyncingModel.this.folderListener);
            folderRepositoryEvent.getFolder().addFolderListener(SyncingModel.this.folderListener);
        }

        @Override
        public void maintenanceFinished(FolderRepositoryEvent folderRepositoryEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void maintenanceStarted(FolderRepositoryEvent folderRepositoryEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void cleanupStarted(FolderRepositoryEvent folderRepositoryEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void cleanupFinished(FolderRepositoryEvent folderRepositoryEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class MyTransferManagerListener
    implements TransferManagerListener {
        private TransferManager tm;

        public MyTransferManagerListener() {
            this.tm = SyncingModel.this.getController().getTransferManager();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void downloadRequested(TransferManagerEvent transferManagerEvent) {
        }

        @Override
        public void downloadQueued(TransferManagerEvent transferManagerEvent) {
        }

        @Override
        public void downloadStarted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void downloadAborted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void downloadBroken(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void completedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
        }

        @Override
        public void pendingDownloadEnqueued(TransferManagerEvent transferManagerEvent) {
        }

        @Override
        public void uploadRequested(TransferManagerEvent transferManagerEvent) {
        }

        @Override
        public void uploadStarted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void uploadAborted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void uploadBroken(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
            SyncingModel.this.calculateOverallStats();
        }

        @Override
        public void completedUploadRemoved(TransferManagerEvent transferManagerEvent) {
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void nodeConnecting(NodeManagerEvent nodeManagerEvent) {
            if (nodeManagerEvent.getNode().hasJoinedAnyFolder()) {
                SyncingModel.this.calculateOverallStats();
            }
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            if (nodeManagerEvent.getNode().hasJoinedAnyFolder()) {
                SyncingModel.this.calculateOverallStats();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

