/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.SwingWorker;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Reject;

public class ServerClientModel
extends PFUIComponent {
    private ServerClient client;

    public ServerClientModel(Controller controller, ServerClient serverClient) {
        super(controller);
        Reject.ifNull(serverClient, "Client is null");
        this.client = serverClient;
    }

    public ServerClient getClient() {
        return this.client;
    }

    public void checkAndSetupAccount() {
        if (Boolean.FALSE.equals(PreferencesEntry.USE_ONLINE_STORAGE.getValueBoolean(this.getController()))) {
            return;
        }
        if (this.client.isLoggedIn()) {
            return;
        }
        if (!this.client.isLastLoginKnown()) {
            PFWizard.openLoginWizard(this.getController(), this.client);
            return;
        }
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                return ServerClientModel.this.client.loginWithLastKnown().isValid();
            }

            @Override
            public void finished() {
                if (this.get() == null || !((Boolean)this.get()).booleanValue()) {
                    PFWizard.openLoginWizard(ServerClientModel.this.getController(), ServerClientModel.this.client);
                }
            }
        };
        swingWorker.start();
    }
}

