/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.uploads;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.information.uploads.UploadsTable;
import de.dal33t.powerfolder.ui.information.uploads.UploadsTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.util.SwingWorker;
import de.dal33t.powerfolder.ui.util.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class UploadsTablePanel
extends PFUIComponent {
    private JPanel uiComponent;
    private JScrollPane tablePane;
    private UploadsTable table;
    private UploadsTableModel tableModel;
    private Action clearCompletedUploadsAction;
    private Action addIgnoreAction;
    private JPopupMenu fileMenu;

    public UploadsTablePanel(Controller controller, Action action, Action action2) {
        super(controller);
        this.clearCompletedUploadsAction = action;
        this.addIgnoreAction = action2;
    }

    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void initialize() {
        TransferManagerModel transferManagerModel = this.getUIController().getTransferManagerModel();
        this.table = new UploadsTable(transferManagerModel);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.tablePane = new JScrollPane(this.table);
        this.tableModel = (UploadsTableModel)this.table.getModel();
        this.table.addMouseListener(new TableMouseListener());
        this.table.registerKeyboardAction(new SelectAllAction(), KeyStroke.getKeyStroke(65, 2), 0);
        UIUtil.whiteStripTable(this.table);
        UIUtil.setZeroHeight(this.tablePane);
        UIUtil.removeBorder(this.tablePane);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getUIComponent();
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.getUIComponent();
        this.tableModel.addTableModelListener(tableModelListener);
    }

    public void clearUploads() {
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                int n = UploadsTablePanel.this.table.getRowCount();
                if (n == 0) {
                    return null;
                }
                boolean bl = true;
                for (int i = 0; i < UploadsTablePanel.this.table.getRowCount(); ++i) {
                    if (!UploadsTablePanel.this.table.isRowSelected(i)) continue;
                    bl = false;
                    break;
                }
                ArrayList<Upload> arrayList = new ArrayList<Upload>();
                for (int i = 0; i < UploadsTablePanel.this.table.getRowCount(); ++i) {
                    Upload upload;
                    if (!bl && !UploadsTablePanel.this.table.isRowSelected(i) || !(upload = UploadsTablePanel.this.tableModel.getUploadAtRow(i)).isCompleted()) continue;
                    arrayList.add(upload);
                }
                for (Upload upload : arrayList) {
                    UploadsTablePanel.this.getController().getTransferManager().clearCompletedUpload(upload);
                }
                return null;
            }
        };
        swingWorker.start();
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:0:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.tablePane, cellConstraints.xy(1, 1));
        this.buildPopupMenus();
        this.uiComponent = panelBuilder.getPanel();
    }

    private void buildPopupMenus() {
        this.fileMenu = new JPopupMenu();
        this.fileMenu.add(this.clearCompletedUploadsAction);
        this.fileMenu.add(this.addIgnoreAction);
    }

    public FileInfo getSelectdFile() {
        if (this.table == null || this.tableModel == null) {
            return null;
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1) {
            Upload upload = (Upload)this.tableModel.getValueAt(nArray[0], 2);
            return upload != null ? upload.getFile() : null;
        }
        return null;
    }

    public int countActiveUploadCount() {
        int n = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Upload upload = this.tableModel.getUploadAtRow(i);
            if (!upload.isStarted() || upload.isCompleted()) continue;
            ++n;
        }
        return n;
    }

    public int countCompletedUploadCount() {
        int n = 0;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            Upload upload = this.tableModel.getUploadAtRow(i);
            if (!upload.isCompleted()) continue;
            ++n;
        }
        return n;
    }

    public Upload[] getSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        return this.tableModel.getUploadsAtRows(nArray);
    }

    private static class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                UploadsTableModel uploadsTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof UploadsTableModel && !(bl = (uploadsTableModel = (UploadsTableModel)tableModel).sortBy(n2))) {
                    uploadsTableModel.reverseList();
                }
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            UploadsTablePanel.this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UploadsTablePanel.this.table.selectAll();
        }
    }
}

