/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.uploads;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.event.TransferManagerAdapter;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import de.dal33t.powerfolder.util.compare.TransferComparator;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class UploadsTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    public static final int UPDATE_TIME = 1000;
    public static final int COLTYPE = 0;
    public static final int COLFILE = 1;
    public static final int COLPROGRESS = 2;
    public static final int COLSIZE = 3;
    public static final int COLFOLDER = 4;
    public static final int COLTO = 5;
    private Collection<TableModelListener> listeners;
    private List<Upload> uploads;
    private int fileInfoComparatorType = -1;
    private boolean sortAscending = true;
    private int sortColumn;
    private final TransferManagerModel model;
    private volatile boolean periodicUpdate;

    public UploadsTableModel(TransferManagerModel transferManagerModel) {
        super(transferManagerModel.getController());
        this.model = transferManagerModel;
        this.listeners = new LinkedList<TableModelListener>();
        this.uploads = new ArrayList<Upload>();
        transferManagerModel.getTransferManager().addListener(new UploadTransferManagerListener());
        this.periodicUpdate = true;
        MyTimerTask myTimerTask = new MyTimerTask();
        this.getController().scheduleAndRepeat(myTimerTask, 1000L);
    }

    public void initialize() {
        TransferManager transferManager = this.model.getTransferManager();
        for (Upload upload : transferManager.getActiveUploads()) {
            if (this.isMetaFolderUpload(upload)) continue;
            this.uploads.add(upload);
        }
        for (Upload upload : transferManager.getQueuedUploads()) {
            if (this.isMetaFolderUpload(upload)) continue;
            this.uploads.add(upload);
        }
    }

    private boolean isMetaFolderUpload(Upload upload) {
        return upload.getFile().getFolderInfo().isMetaFolder();
    }

    public boolean isPeriodicUpdate() {
        return this.periodicUpdate;
    }

    public void setPeriodicUpdate(boolean bl) {
        if (!this.periodicUpdate && bl) {
            this.resortAndUpdate();
        }
        this.periodicUpdate = bl;
    }

    public Upload getUploadAtRow(int n) {
        if (n >= this.uploads.size() || n == -1) {
            this.logSevere("Illegal rowIndex requested. rowIndex " + n + ", uploads " + this.uploads.size());
            return null;
        }
        return this.uploads.get(n);
    }

    @Override
    public boolean sortBy(int n) {
        this.sortColumn = n;
        switch (n) {
            case 0: {
                return this.sortMe(0);
            }
            case 1: {
                return this.sortMe(1);
            }
            case 2: {
                return this.sortMe(2);
            }
            case 3: {
                return this.sortMe(3);
            }
            case 4: {
                return this.sortMe(4);
            }
            case 5: {
                return this.sortMe(5);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        int n2 = this.fileInfoComparatorType;
        this.fileInfoComparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.fileInfoComparatorType != -1) {
            TransferComparator transferComparator = new TransferComparator(this.fileInfoComparatorType);
            List<Upload> list = this.uploads;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.uploads, transferComparator);
                } else {
                    Collections.sort(this.uploads, new ReverseComparator<Transfer>(transferComparator));
                }
            }
            return true;
        }
        return false;
    }

    private void fireModelChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TableModelEvent tableModelEvent = new TableModelEvent(UploadsTableModel.this);
                for (Object e : UploadsTableModel.this.listeners) {
                    TableModelListener tableModelListener = (TableModelListener)e;
                    tableModelListener.tableChanged(tableModelEvent);
                }
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<Upload> list = this.uploads;
        synchronized (list) {
            Collections.reverse(this.uploads);
        }
        this.fireModelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdateUpload(Upload upload) {
        int n;
        if (this.isMetaFolderUpload(upload)) {
            return;
        }
        boolean bl = false;
        List<Upload> list = this.uploads;
        synchronized (list) {
            Upload upload2;
            n = this.findUploadIndex(upload);
            Upload upload3 = upload2 = n >= 0 ? this.uploads.get(n) : null;
            if (upload2 == null) {
                this.uploads.add(upload);
                bl = true;
            } else {
                this.uploads.set(n, upload);
            }
        }
        if (bl) {
            this.rowAdded();
        } else {
            this.rowsUpdated(n, n);
        }
    }

    private int findUploadIndex(Upload upload) {
        for (int i = 0; i < this.uploads.size(); ++i) {
            Upload upload2 = this.uploads.get(i);
            if (!upload2.getFile().isVersionDateAndSizeIdentical(upload.getFile()) || !Util.equals(upload2.getPartner(), upload.getPartner())) continue;
            return i;
        }
        return -1;
    }

    private int removeUpload(Upload upload) {
        int n = this.uploads.indexOf(upload);
        if (n >= 0) {
            this.logFiner("Remove upload from tablemodel: " + upload);
            this.uploads.remove(n);
        } else {
            this.logSevere("Unable to remove upload from tablemodel, not found: " + upload);
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.uploads.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return Translation.get("general.file");
            }
            case 2: {
                return Translation.get("transfers.progress");
            }
            case 3: {
                return Translation.get("general.size");
            }
            case 4: {
                return Translation.get("general.folder");
            }
            case 5: {
                return Translation.get("transfers.to");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("Unable to set value in UploadTableModel, not editable");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    private void rowAdded() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1);
        this.modelChanged(tableModelEvent);
    }

    private synchronized void rowRemoved(int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
        this.modelChanged(tableModelEvent);
    }

    private void rowsUpdated(int n, int n2) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, -1, 0);
        this.modelChanged(tableModelEvent);
    }

    private void rowsUpdatedAll() {
        if (!this.uploads.isEmpty()) {
            this.rowsUpdated(0, this.uploads.size());
        }
    }

    private void modelChanged(final TableModelEvent tableModelEvent) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection collection = UploadsTableModel.this.listeners;
                synchronized (collection) {
                    for (Object e : UploadsTableModel.this.listeners) {
                        TableModelListener tableModelListener = (TableModelListener)e;
                        tableModelListener.tableChanged(tableModelEvent);
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterInEDT(runnable);
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return FileInfo.class;
            }
            case 2: {
                return Upload.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return FolderInfo.class;
            }
            case 5: {
                return Member.class;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.uploads.size()) {
            this.logSevere("Illegal rowIndex requested. rowIndex " + n + ", uploads " + this.uploads.size());
            return null;
        }
        Upload upload = this.uploads.get(n);
        switch (n2) {
            case 0: 
            case 1: {
                return upload.getFile();
            }
            case 2: {
                return upload;
            }
            case 3: {
                return upload.getFile().getSize();
            }
            case 4: {
                return upload.getFile().getFolderInfo();
            }
            case 5: {
                return upload.getPartner();
            }
        }
        return null;
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    public Upload[] getUploadsAtRows(int[] nArray) {
        Upload[] uploadArray = new Upload[nArray.length];
        int n = 0;
        for (int n2 : nArray) {
            if (n2 < this.uploads.size()) {
                uploadArray[n] = this.uploads.get(n2);
            }
            ++n;
        }
        return uploadArray;
    }

    public int getSelectedRowCount() {
        return 0;
    }

    private void resortAndUpdate() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (UploadsTableModel.this.fileInfoComparatorType == 2) {
                    UploadsTableModel.this.sort();
                }
                UploadsTableModel.this.rowsUpdatedAll();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private class UploadTransferManagerListener
    extends TransferManagerAdapter {
        private UploadTransferManagerListener() {
        }

        @Override
        public void uploadRequested(TransferManagerEvent transferManagerEvent) {
            UploadsTableModel.this.addOrUpdateUpload(transferManagerEvent.getUpload());
        }

        @Override
        public void uploadStarted(TransferManagerEvent transferManagerEvent) {
            UploadsTableModel.this.addOrUpdateUpload(transferManagerEvent.getUpload());
        }

        @Override
        public void uploadAborted(TransferManagerEvent transferManagerEvent) {
            if (UploadsTableModel.this.isMetaFolderUpload(transferManagerEvent.getUpload())) {
                return;
            }
            int n = UploadsTableModel.this.removeUpload(transferManagerEvent.getUpload());
            if (n >= 0) {
                UploadsTableModel.this.rowRemoved(n);
            }
        }

        @Override
        public void uploadBroken(TransferManagerEvent transferManagerEvent) {
            if (UploadsTableModel.this.isMetaFolderUpload(transferManagerEvent.getUpload())) {
                return;
            }
            int n = UploadsTableModel.this.removeUpload(transferManagerEvent.getUpload());
            if (n >= 0) {
                UploadsTableModel.this.rowRemoved(n);
            }
        }

        @Override
        public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
            if (UploadsTableModel.this.isMetaFolderUpload(transferManagerEvent.getUpload())) {
                return;
            }
            int n = UploadsTableModel.this.uploads.indexOf(transferManagerEvent.getUpload());
            if (n >= 0) {
                UploadsTableModel.this.rowsUpdated(n, n);
            } else {
                UploadsTableModel.this.logSevere("Upload not found in model: " + transferManagerEvent.getUpload());
                UploadsTableModel.this.rowsUpdatedAll();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void completedUploadRemoved(TransferManagerEvent transferManagerEvent) {
            if (UploadsTableModel.this.isMetaFolderUpload(transferManagerEvent.getUpload())) {
                return;
            }
            int n = UploadsTableModel.this.removeUpload(transferManagerEvent.getUpload());
            if (n >= 0) {
                UploadsTableModel.this.rowRemoved(n);
            }
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            if (!UploadsTableModel.this.periodicUpdate) {
                return;
            }
            UploadsTableModel.this.resortAndUpdate();
        }
    }
}

