/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.notices;

import de.dal33t.powerfolder.ui.information.notices.NoticesTableModel;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.notices.NoticeSeverity;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class NoticesTable
extends JTable {
    public NoticesTable(NoticesTableModel noticesTableModel) {
        super(noticesTableModel);
        this.setShowGrid(false);
        this.setSelectionMode(0);
        this.setDefaultRenderer(Notice.class, new MyDefaultTreeCellRenderer());
        this.setRowHeight(Icons.getIconById("information.icon").getIconHeight() + 3);
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.setupColumns();
        SortedTableHeaderRenderer.associateHeaderRenderer(noticesTableModel, this.getColumnModel(), noticesTableModel.getSortColumn(), noticesTableModel.isSortAscending());
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        return container instanceof JViewport && this.getPreferredSize().height < container.getHeight();
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        int n2 = Icons.getIconById("information.icon").getIconHeight() + 3;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(20);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(500);
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            String string = "";
            boolean bl3 = false;
            if (object != null) {
                serializable = (Notice)object;
                this.setIcon(null);
                switch (n2) {
                    case 0: {
                        this.setHorizontalAlignment(2);
                        Icon icon = serializable.getNoticeSeverity() == NoticeSeverity.INFORMATION ? Icons.getIconById("information.icon") : (serializable.getNoticeSeverity() == NoticeSeverity.WARNING ? Icons.getIconById("warning.icon") : Icons.getIconById("blank.icon"));
                        this.setIcon(icon);
                        break;
                    }
                    case 1: {
                        string = Format.formatDateShort(serializable.getDate());
                        this.setHorizontalAlignment(4);
                        break;
                    }
                    case 2: {
                        string = serializable.getSummary();
                        this.setHorizontalAlignment(2);
                    }
                }
                bl3 = !serializable.isRead();
            }
            serializable = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (bl3) {
                ((Component)serializable).setFont(new Font(((Component)serializable).getFont().getFontName(), 1, ((Component)serializable).getFont().getSize()));
            } else {
                ((Component)serializable).setFont(new Font(((Component)serializable).getFont().getFontName(), 0, ((Component)serializable).getFont().getSize()));
            }
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            return serializable;
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                NoticesTableModel noticesTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof NoticesTableModel && !(bl = (noticesTableModel = (NoticesTableModel)tableModel).sortBy(n2))) {
                    noticesTableModel.reverseList();
                }
            }
        }
    }
}

