/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileDetailsPanel
extends PFUIComponent {
    private final boolean includeSeparator;
    private JPanel panel;
    private JTextField nameField;
    private JTextField locationField;
    private JLabel folderField;
    private JTextField sizeField;
    private JLabel statusField;
    private JTextField sourcesField;
    private JLabel modifiedByField;
    private JTextField modifiedDateField;
    private JTextField versionField;
    private JTextField localCopyAtField;

    public FileDetailsPanel(Controller controller, boolean bl) {
        super(controller);
        this.includeSeparator = bl;
    }

    public void setFileInfo(FileInfo fileInfo) {
        Object object;
        Object object2;
        Object object3;
        StringBuilder stringBuilder;
        if (this.panel == null) {
            return;
        }
        if (fileInfo == null) {
            this.clearComponents();
            return;
        }
        List<Object> list = this.getController().getFolderRepository().hasJoinedFolder(fileInfo.getFolderInfo()) ? this.getController().getTransferManager().getSourcesFor(fileInfo) : new ArrayList();
        int n = list == null ? 0 : list.size();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            stringBuilder2.append(((Member)list.get(0)).getNick());
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder2.append(", " + ((Member)list.get(i)).getNick());
            }
        }
        Icon icon = Icons.getIconFor(this.getController(), fileInfo);
        if (fileInfo.isUploading(this.getController())) {
            stringBuilder = new StringBuilder(Translation.get("file_details_panel.uploading"));
            icon = Icons.getIconById("upload.icon");
        } else if (fileInfo.isDownloading(this.getController())) {
            object3 = this.getController().getTransferManager().getActiveDownload(fileInfo);
            stringBuilder = new StringBuilder(Translation.get("file_details_panel.downloading"));
            if (object3 != null && object3.isStarted()) {
                stringBuilder.append(" (" + Format.formatDecimal(object3.getCounter().calculateCompletionPercentage()) + "%)");
            }
        } else if (fileInfo.isDeleted()) {
            stringBuilder = new StringBuilder(Translation.get("file_details_panel.deleted"));
        } else if (fileInfo.isExpected(this.getController().getFolderRepository())) {
            stringBuilder = new StringBuilder(Translation.get("file_details_panel.expected"));
        } else if (this.hasJoinedFolder(fileInfo)) {
            if (fileInfo.isNewerAvailable(this.getController().getFolderRepository())) {
                object3 = fileInfo.getNewestVersion(this.getController().getFolderRepository());
                object2 = object3 != null ? "" + ((FileInfo)object3).getVersion() : "?";
                stringBuilder = new StringBuilder(Translation.get("file_details_panel.newer_available", new String[]{object2}));
            } else {
                stringBuilder = new StringBuilder(Translation.get("file_details_panel.normal"));
            }
        } else {
            stringBuilder = n > 0 ? new StringBuilder(Translation.get("file_details_panel.available")) : new StringBuilder(Translation.get("file_details_panel.not_available"));
        }
        object3 = fileInfo.getDiskFile(this.getController().getFolderRepository());
        if (object3 != null && Files.notExists((Path)object3, new LinkOption[0])) {
            object3 = null;
        }
        this.nameField.setText(fileInfo.getFilenameOnly());
        this.nameField.setCaretPosition(0);
        this.locationField.setText(fileInfo.getRelativeName());
        this.locationField.setCaretPosition(0);
        this.folderField.setText(fileInfo.getFolderInfo().getLocalizedName());
        this.sizeField.setText(Format.formatBytes(fileInfo.getSize()));
        this.statusField.setText(stringBuilder.toString());
        this.statusField.setIcon(icon);
        object2 = fileInfo.getModifiedBy();
        this.modifiedByField.setText(((MemberInfo)object2).nick);
        this.modifiedDateField.setText(Format.formatDateShort(fileInfo.getModifiedDate()));
        this.versionField.setText(String.valueOf(fileInfo.getVersion()));
        this.sourcesField.setText(stringBuilder2.toString());
        Object object4 = object = object3 != null ? object3.toAbsolutePath().toString() : "- " + Translation.get("general.not_available") + " -";
        if (this.localCopyAtField.getText() == null || !this.localCopyAtField.getText().equals(object)) {
            this.localCopyAtField.setText((String)object);
            this.localCopyAtField.setCaretPosition(0);
        }
    }

    private boolean hasJoinedFolder(FileInfo fileInfo) {
        return this.getFolderOfFile(fileInfo) != null;
    }

    private Folder getFolderOfFile(FileInfo fileInfo) {
        return fileInfo.getFolder(this.getController().getFolderRepository());
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = this.includeSeparator ? new FormLayout("right:max(p;50dlu), 3dlu, 107dlu, 40dlu, right:p, 3dlu, 107dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu") : new FormLayout("right:max(p;50dlu), 3dlu, 107dlu, 40dlu, right:p, 3dlu, 107dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu");
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            if (this.includeSeparator) {
                defaultFormBuilder.addSeparator(null, cellConstraints.xyw(1, n, 8));
                n += 2;
            }
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.name"), cellConstraints.xy(1, n));
            defaultFormBuilder.add((Component)this.nameField, cellConstraints.xywh(3, n, 5, 1));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.location"), cellConstraints.xy(1, n += 2));
            defaultFormBuilder.add((Component)this.locationField, cellConstraints.xy(3, n));
            defaultFormBuilder.addLabel(Translation.get("general.folder"), cellConstraints.xy(5, n));
            defaultFormBuilder.add((Component)this.folderField, cellConstraints.xy(7, n));
            defaultFormBuilder.addLabel(Translation.get("general.size"), cellConstraints.xy(1, n += 2));
            defaultFormBuilder.add((Component)this.sizeField, cellConstraints.xy(3, n));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.modified_by"), cellConstraints.xy(5, n));
            defaultFormBuilder.add((Component)this.modifiedByField, cellConstraints.xy(7, n));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.status"), cellConstraints.xy(1, n += 2));
            defaultFormBuilder.add((Component)this.statusField, cellConstraints.xy(3, n));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.modified_date"), cellConstraints.xy(5, n));
            defaultFormBuilder.add((Component)this.modifiedDateField, cellConstraints.xy(7, n));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.version"), cellConstraints.xy(5, n += 2));
            defaultFormBuilder.add((Component)this.versionField, cellConstraints.xy(7, n));
            defaultFormBuilder.addLabel(Translation.get("file_details_panel.availability"), cellConstraints.xy(1, n));
            defaultFormBuilder.add((Component)this.sourcesField, cellConstraints.xy(3, n));
            defaultFormBuilder.addLabel(Translation.get("general.local_copy_at"), cellConstraints.xy(1, n += 2));
            defaultFormBuilder.add((Component)this.localCopyAtField, cellConstraints.xywh(3, n, 5, 1));
            this.panel = defaultFormBuilder.getPanel();
            this.panel.setVisible(false);
        }
        return this.panel;
    }

    private void clearComponents() {
        this.nameField.setText("");
        this.locationField.setText("");
        this.folderField.setText("");
        this.folderField.setIcon(null);
        this.sizeField.setText("");
        this.localCopyAtField.setText("");
        this.statusField.setText("");
        this.sourcesField.setText("");
        this.modifiedByField.setText("");
        this.modifiedByField.setIcon(null);
        this.modifiedDateField.setText("");
        this.versionField.setText("");
    }

    private void initComponents() {
        this.nameField = SimpleComponentFactory.createTextField(false);
        this.locationField = SimpleComponentFactory.createTextField(false);
        this.folderField = SimpleComponentFactory.createLabel();
        this.sizeField = SimpleComponentFactory.createTextField(false);
        this.localCopyAtField = SimpleComponentFactory.createTextField(false);
        this.statusField = SimpleComponentFactory.createLabel();
        this.sourcesField = SimpleComponentFactory.createTextField(false);
        this.modifiedByField = SimpleComponentFactory.createLabel();
        this.modifiedDateField = SimpleComponentFactory.createTextField(false);
        this.versionField = SimpleComponentFactory.createTextField(false);
    }
}

