/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.iconoverlay;

import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.SyncStatus;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.ui.iconoverlay.IconOverlayIndex;
import de.dal33t.powerfolder.util.StringUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class IconOverlayHandler
extends PFComponent
implements FileIconControlCallback {
    public IconOverlayHandler(Controller controller) {
        super(controller);
    }

    @Override
    public int getIconForFile(String string) {
        if (StringUtils.isBlank(string)) {
            this.logFine("No path name passed");
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
        return this.getIconForFile(Paths.get(string, new String[0]));
    }

    public int getIconForFile(Path path) {
        if (path == null) {
            this.logFine("No path name passed");
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
        try {
            Folder folder;
            Object object;
            FolderRepository folderRepository = this.getController().getFolderRepository();
            Path path2 = folderRepository.getFoldersBasedir();
            boolean bl = false;
            if (path.getFileName() != null) {
                bl = path.getFileName().toString().endsWith(".lnk");
            }
            if (path2.equals(path.getParent()) && Files.isRegularFile(path, new LinkOption[0]) && !bl) {
                if ("Getting started.pdf".equals(path.getFileName().toString()) || "desktop.ini".equals(path.getFileName().toString())) {
                    return IconOverlayIndex.NO_OVERLAY.getIndex();
                }
                return IconOverlayIndex.WARNING_OVERLAY.getIndex();
            }
            if (bl) {
                object = path.getFileName().toString();
                String string = ((String)object).split("\\.")[0];
                folder = folderRepository.findExistingFolder(string);
                if (folder != null) {
                    path = folder.getLocalBase();
                }
            } else {
                folder = folderRepository.findContainingFolder(path);
            }
            if (folder == null) {
                return IconOverlayIndex.NO_OVERLAY.getIndex();
            }
            if (path.toString().contains(Constants.POWERFOLDER_SYSTEM_SUBDIR)) {
                return IconOverlayIndex.NO_OVERLAY.getIndex();
            }
            object = FileInfoFactory.lookupInstance(folder, path);
            return this.getIconForFile((FileInfo)object);
        }
        catch (RuntimeException runtimeException) {
            this.logSevere("An error occured while determining the icon overlay for file '" + path.toString() + "'. " + runtimeException);
            runtimeException.printStackTrace();
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
    }

    public int getIconForFile(FileInfo fileInfo) {
        if (fileInfo == null) {
            this.logFine("No fileinfo passed");
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            this.logFine("No folder found for " + fileInfo.toDetailString());
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
        try {
            SyncStatus syncStatus = SyncStatus.of(this.getController(), fileInfo, folder);
            switch (syncStatus) {
                case SYNC_OK: {
                    return IconOverlayIndex.OK_OVERLAY.getIndex();
                }
                case SYNCING: {
                    return IconOverlayIndex.SYNCING_OVERLAY.getIndex();
                }
                case IGNORED: {
                    return IconOverlayIndex.IGNORED_OVERLAY.getIndex();
                }
                case LOCKED: {
                    return IconOverlayIndex.LOCKED_OVERLAY.getIndex();
                }
                case WARNING: {
                    return IconOverlayIndex.WARNING_OVERLAY.getIndex();
                }
            }
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
        catch (RuntimeException runtimeException) {
            this.logSevere("An error occured while determining the icon overlay for file '" + fileInfo.toDetailString() + "'. " + runtimeException);
            return IconOverlayIndex.NO_OVERLAY.getIndex();
        }
    }
}

