/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.folders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ProblemListener;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.TransferManagerAdapter;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.event.ExpansionEvent;
import de.dal33t.powerfolder.ui.event.ExpansionListener;
import de.dal33t.powerfolder.ui.folders.ExpandableFolderModel;
import de.dal33t.powerfolder.ui.folders.ExpandableFolderView;
import de.dal33t.powerfolder.ui.folders.FoldersTab;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.util.UserDirectories;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FoldersList
extends PFUIComponent {
    private final List<ExpandableFolderView> views;
    private JPanel uiComponent;
    private JPanel folderListPanel;
    private FolderRepository repository;
    private ServerClient client;
    private JScrollPane scrollPane;
    private ExpansionListener expansionListener;
    private FolderMembershipListener membershipListener;
    private FoldersTab foldersTab;
    private boolean empty = true;
    private volatile boolean populated;
    private boolean showTypical = PreferencesEntry.SHOW_TYPICAL_FOLDERS.getValueBoolean(this.getController());
    private DelayedUpdater transfersUpdater;
    private DelayedUpdater foldersUpdater;

    FoldersList(Controller controller, FoldersTab foldersTab) {
        super(controller);
        this.foldersTab = foldersTab;
        this.transfersUpdater = new DelayedUpdater(this.getController());
        this.foldersUpdater = new DelayedUpdater(this.getController());
        this.expansionListener = new MyExpansionListener();
        this.membershipListener = new MyFolderMembershipListener();
        this.views = new CopyOnWriteArrayList<ExpandableFolderView>();
        this.buildUI();
        this.getController().getTransferManager().addListener(new MyTransferManagerListener());
    }

    public JPanel getUIComponent() {
        return this.uiComponent;
    }

    private void buildUI() {
        this.repository = this.getController().getFolderRepository();
        this.client = this.getController().getOSClient();
        this.folderListPanel = new JPanel();
        this.folderListPanel.setLayout(new BoxLayout(this.folderListPanel, 3));
        this.registerListeners();
        FormLayout formLayout = new FormLayout("pref:grow", "pref, pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.folderListPanel, cellConstraints.xy(1, 1));
        this.uiComponent = panelBuilder.getPanel();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void registerListeners() {
        this.getController().getFolderRepository().addProblemListenerToAllFolders(new MyProblemListener());
        this.getController().getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            folder.addMembershipListener(this.membershipListener);
        }
        this.getController().getOSClient().addListener(new MyServerClientListener());
    }

    private void updateFolders() {
        this.foldersUpdater.schedule(this::updateFolders0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateFolders0() {
        Cloneable cloneable;
        if (!this.populated) {
            return;
        }
        if (this.getController().isShuttingDown()) {
            return;
        }
        ArrayList<ExpandableFolderModel> arrayList = new ArrayList<ExpandableFolderModel>();
        for (Folder object2 : this.repository.getFolders()) {
            FolderInfo folderInfo = object2.getInfo();
            cloneable = new ExpandableFolderModel(ExpandableFolderModel.Type.Local, folderInfo, object2, this.getController().getOSClient().joinedByCloud(object2));
            arrayList.add((ExpandableFolderModel)((Object)cloneable));
        }
        for (FolderInfo folderInfo : this.client.getAccountFolders()) {
            ExpandableFolderModel expandableFolderModel = new ExpandableFolderModel(ExpandableFolderModel.Type.CloudOnly, folderInfo, null, true);
            if (arrayList.contains(expandableFolderModel)) continue;
            arrayList.add(expandableFolderModel);
        }
        if (this.showTypical) {
            boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
            for (String string : UserDirectories.getUserDirectoriesFiltered(this.getController(), bl).keySet()) {
                cloneable = FolderInfoFactory.newTopFolder(string);
                ExpandableFolderModel expandableFolderModel = new ExpandableFolderModel(ExpandableFolderModel.Type.Typical, (FolderInfo)cloneable, null, false);
                if (arrayList.contains(expandableFolderModel)) continue;
                arrayList.add(expandableFolderModel);
            }
        }
        arrayList.sort(FolderBeanComparator.INSTANCE);
        this.empty = arrayList.isEmpty();
        List<ExpandableFolderView> list = this.views;
        synchronized (list) {
            void var4_19;
            void var3_11;
            Object var3_10 = null;
            Object var4_18 = null;
            for (ExpandableFolderView expandableFolderView : this.views) {
                if (var3_11 == null && expandableFolderView.isExpanded()) {
                    FolderInfo folderInfo = expandableFolderView.getFolderInfo();
                }
                if (var4_19 != null || !expandableFolderView.hasFocus()) continue;
                FolderInfo folderInfo = expandableFolderView.getFolderInfo();
            }
            cloneable = new ArrayList<ExpandableFolderView>();
            for (ExpandableFolderView expandableFolderView : this.views) {
                cloneable.add(expandableFolderView);
                this.views.remove(expandableFolderView);
            }
            for (ExpandableFolderModel expandableFolderModel : arrayList) {
                this.addView(expandableFolderModel, (FolderInfo)var3_11, (FolderInfo)var4_19, (List<ExpandableFolderView>)((Object)cloneable));
            }
            for (ExpandableFolderView expandableFolderView : cloneable) {
                this.views.remove(expandableFolderView);
                expandableFolderView.dispose();
                expandableFolderView.removeExpansionListener(this.expansionListener);
                expandableFolderView.unregisterListeners();
                this.folderListPanel.remove(expandableFolderView.getUIComponent());
            }
            this.folderListPanel.invalidate();
            if (this.uiComponent != null) {
                this.uiComponent.invalidate();
            }
            if (this.scrollPane != null) {
                this.scrollPane.repaint();
            }
        }
        this.foldersTab.updateEmptyLabel();
    }

    private void addView(ExpandableFolderModel expandableFolderModel, FolderInfo folderInfo, FolderInfo folderInfo2, List<ExpandableFolderView> list) {
        ExpandableFolderView expandableFolderView = null;
        Iterator<ExpandableFolderView> iterator = list.iterator();
        while (iterator.hasNext()) {
            ExpandableFolderView expandableFolderView2 = iterator.next();
            if (!expandableFolderView2.getFolderInfo().equals(expandableFolderModel.getFolderInfo())) continue;
            expandableFolderView = expandableFolderView2;
            iterator.remove();
            break;
        }
        boolean bl = false;
        if (expandableFolderView == null) {
            expandableFolderView = new ExpandableFolderView(this.getController(), expandableFolderModel.getFolderInfo());
            bl = true;
        }
        expandableFolderView.configure(expandableFolderModel);
        this.folderListPanel.add(expandableFolderView.getUIComponent());
        this.views.add(expandableFolderView);
        if (expandableFolderModel.getFolderInfo().equals(folderInfo)) {
            expandableFolderView.expand();
        }
        if (expandableFolderModel.getFolderInfo().equals(folderInfo2)) {
            expandableFolderView.setFocus(true);
        }
        if (bl) {
            expandableFolderView.addExpansionListener(this.expansionListener);
        }
    }

    public void setScroller(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    public void populate() {
        this.populated = true;
        this.updateFolders();
    }

    private void updateProblems() {
        for (ExpandableFolderView expandableFolderView : this.views) {
            expandableFolderView.updateIconAndOS();
        }
    }

    public void scrollToFolderInfo(FolderInfo folderInfo) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (ExpandableFolderView expandableFolderView : this.views) {
            expandableFolderView.getUIComponent().getHeight();
            int n3 = expandableFolderView.getUIComponent().getHeight();
            n += n3;
            if (expandableFolderView.getFolderInfo().equals(folderInfo)) {
                bl = true;
            }
            if (bl) continue;
            n2 += n3;
        }
        if (bl) {
            int n4 = this.scrollPane.getViewport().getHeight();
            if (n4 > n) {
                return;
            }
            this.scrollPane.getVerticalScrollBar().setValue(n2);
        }
    }

    private class MyExpansionListener
    implements ExpansionListener {
        private MyExpansionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetAllButSource(ExpansionEvent expansionEvent) {
            List list = FoldersList.this.views;
            synchronized (list) {
                for (ExpandableFolderView expandableFolderView : FoldersList.this.views) {
                    if (expandableFolderView.equals(expansionEvent.getSource())) continue;
                    expandableFolderView.collapse();
                    expandableFolderView.setFocus(false);
                }
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderMembershipListener
    implements FolderMembershipListener {
        private MyFolderMembershipListener() {
        }

        @Override
        public void memberJoined(FolderMembershipEvent folderMembershipEvent) {
            if (folderMembershipEvent.getMember().isServer()) {
                FoldersList.this.updateFolders();
            }
        }

        @Override
        public void memberLeft(FolderMembershipEvent folderMembershipEvent) {
            if (folderMembershipEvent.getMember().isServer()) {
                FoldersList.this.updateFolders();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyTransferManagerListener
    extends TransferManagerAdapter {
        private MyTransferManagerListener() {
        }

        private void notifyView(TransferManagerEvent transferManagerEvent) {
            FileInfo fileInfo = transferManagerEvent.getFile();
            FoldersList.this.transfersUpdater.schedule(() -> {
                FolderInfo folderInfo = fileInfo.getFolderInfo();
                List list = FoldersList.this.views;
                synchronized (list) {
                    for (ExpandableFolderView expandableFolderView : FoldersList.this.views) {
                        if (!expandableFolderView.getFolderInfo().equals(folderInfo)) continue;
                        expandableFolderView.updateNameLabel();
                        break;
                    }
                }
            });
        }

        @Override
        public void completedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
            this.notifyView(transferManagerEvent);
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            this.notifyView(transferManagerEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        @Override
        public void problemAdded(Problem problem) {
            FoldersList.this.updateProblems();
        }

        @Override
        public void problemRemoved(Problem problem) {
            FoldersList.this.updateProblems();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            FoldersList.this.updateFolders();
            folderRepositoryEvent.getFolder().removeMembershipListener(FoldersList.this.membershipListener);
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            FoldersList.this.updateFolders();
            folderRepositoryEvent.getFolder().addMembershipListener(FoldersList.this.membershipListener);
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            FoldersList.this.updateFolders();
            folderRepositoryEvent.getOldFolder().removeMembershipListener(FoldersList.this.membershipListener);
            folderRepositoryEvent.getFolder().addMembershipListener(FoldersList.this.membershipListener);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private boolean lastLoginSuccess;

        private MyServerClientListener() {
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            if (serverClientEvent.isLoginSuccess()) {
                FoldersList.this.updateFolders();
                this.lastLoginSuccess = true;
            } else if (this.lastLoginSuccess) {
                FoldersList.this.updateFolders();
            }
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            FoldersList.this.updateFolders();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            if (serverClientEvent.getServerNode().hasJoinedAnyFolder()) {
                FoldersList.this.updateFolders();
            }
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            if (serverClientEvent.getServerNode().hasJoinedAnyFolder()) {
                FoldersList.this.updateFolders();
            }
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private static class FolderBeanComparator
    implements Comparator<ExpandableFolderModel> {
        private static final FolderBeanComparator INSTANCE = new FolderBeanComparator();

        private FolderBeanComparator() {
        }

        @Override
        public int compare(ExpandableFolderModel expandableFolderModel, ExpandableFolderModel expandableFolderModel2) {
            return expandableFolderModel.getFolderInfo().getLocalizedName().compareToIgnoreCase(expandableFolderModel2.getFolderInfo().getLocalizedName());
        }
    }
}

