/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog.directory;

import de.dal33t.powerfolder.ui.dialog.directory.DirectoryTreeNode;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Cursor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class DirectoryTree
extends JTree {
    private static final Logger log = Logger.getLogger(DirectoryTree.class.getName());
    private final List<String> onlineFolders;

    DirectoryTree(TreeModel treeModel, List<String> list) {
        super(treeModel);
        this.onlineFolders = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePath(Path path) {
        if (path == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No file supplied.");
            }
            this.doDefault();
            return;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "File does not exist : " + path.toAbsolutePath());
            }
            this.doDefault();
            return;
        }
        Cursor cursor = CursorUtils.setWaitCursor(this);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(path.toAbsolutePath().toString(), path.getFileSystem().getSeparator());
            TreeNode treeNode = (TreeNode)this.getModel().getRoot();
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            arrayList.add(treeNode);
            boolean bl = true;
            long l = 0L;
            while (stringTokenizer.hasMoreTokens()) {
                Object[] objectArray;
                Object object;
                Object object2;
                if ((OSUtil.isLinux() || OSUtil.isMacOS()) && bl) {
                    stringBuilder.append(path.getFileSystem().getSeparator());
                } else {
                    object2 = stringTokenizer.nextToken();
                    stringBuilder.append((String)object2).append(path.getFileSystem().getSeparator());
                }
                object2 = Paths.get(stringBuilder.toString(), new String[0]);
                if (Files.notExists((Path)object2, new LinkOption[0]) || !Files.isReadable((Path)object2) || !Files.isDirectory((Path)object2, new LinkOption[0]) || Files.isHidden((Path)object2) && !bl) {
                    if (bl && log.isLoggable(Level.FINE)) {
                        String string = "Cannot access the base of " + path.toAbsolutePath() + " because" + (Files.exists((Path)object2, new LinkOption[0]) ? "" : " (file does not exist)") + (Files.isReadable((Path)object2) ? "" : " (file cannot be read)") + (Files.isDirectory((Path)object2, new LinkOption[0]) ? "" : " (file is not a directory)");
                        log.log(Level.FINE, string.trim());
                    }
                    this.doDefault();
                    return;
                }
                int n = treeNode.getChildCount();
                boolean bl2 = false;
                for (int i = 0; i < n; ++i) {
                    Path path2;
                    TreeNode treeNode2 = treeNode.getChildAt(i);
                    if (!(treeNode2 instanceof DirectoryTreeNode) || !DirectoryTree.fileCompare(path2 = (Path)((DefaultMutableTreeNode)(object = (DirectoryTreeNode)treeNode2)).getUserObject(), (Path)object2)) continue;
                    treeNode = treeNode2;
                    arrayList.add(treeNode);
                    ((DirectoryTreeNode)object).scan(this.onlineFolders);
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    objectArray = new TreeNode[arrayList.size()];
                    int n2 = 0;
                    for (TreeNode treeNode2 : arrayList) {
                        objectArray[n2++] = treeNode2;
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Failed to navigate the tree depth " + l + " for " + path.toAbsolutePath());
                    }
                    this.doDefault();
                    return;
                }
                object = new TreePath(objectArray);
                this.expandPath((TreePath)object);
                this.setSelectionPath((TreePath)object);
                this.scrollPathToVisible((TreePath)object);
                bl = false;
                ++l;
            }
        }
        catch (IOException iOException) {
            log.warning(iOException.getMessage());
        }
        finally {
            CursorUtils.returnToOriginal(this, cursor);
        }
    }

    private void doDefault() {
        TreeNode treeNode;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Doing the default tree expansion.");
        }
        if ((treeNode = (TreeNode)this.getModel().getRoot()) instanceof DefaultMutableTreeNode) {
            Object[] objectArray = new TreeNode[]{treeNode};
            TreePath treePath = new TreePath(objectArray);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Expanding default root tree path...");
            }
            this.expandPath(treePath);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Expanded default root tree path.");
            }
        }
    }

    private static boolean fileCompare(Path path, Path path2) {
        String string = path.toAbsolutePath().toString();
        while (string.endsWith(path.getFileSystem().getSeparator())) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = path2.toAbsolutePath().toString();
        while (string2.endsWith(path2.getFileSystem().getSeparator())) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string.equals(string2);
    }

    @Override
    public void expandPath(TreePath treePath) {
        Cursor cursor = CursorUtils.setWaitCursor(this);
        try {
            this.scanPath(treePath);
            super.expandPath(treePath);
        }
        finally {
            CursorUtils.returnToOriginal(this, cursor);
        }
    }

    private void scanPath(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            DirectoryTreeNode directoryTreeNode;
            if (treePath2.getLastPathComponent() instanceof DirectoryTreeNode) {
                this.scanPath(treePath2);
            }
            if (treePath.getLastPathComponent() instanceof DirectoryTreeNode && !(directoryTreeNode = (DirectoryTreeNode)treePath.getLastPathComponent()).isScanned()) {
                directoryTreeNode.scan(this.onlineFolders);
            }
        }
    }
}

