/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.wizard.ChooseMultiDiskLocationPanel;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class LinkFolderOnlineDialog
extends BaseDialog {
    private ServerClientListener listener;
    private Action linkAction;
    private JButton linkButton;
    private JButton clearButton;
    private JButton cancelButton;
    private DefaultComboBoxModel<String> folderListModel;
    private JComboBox<String> folderList;
    private final AtomicBoolean populated = new AtomicBoolean();
    private final Path file;
    private final String currentFolderName;
    private final ChooseMultiDiskLocationPanel parent;

    public LinkFolderOnlineDialog(Controller controller, ChooseMultiDiskLocationPanel chooseMultiDiskLocationPanel, Path path, String string) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.parent = chooseMultiDiskLocationPanel;
        this.file = path;
        this.currentFolderName = string;
        this.listener = new MyServerClientListener();
        this.getController().getOSClient().addListener(this.listener);
    }

    private void initComponents() {
        this.folderListModel = new DefaultComboBoxModel();
        this.folderList = new JComboBox<String>(this.folderListModel);
        this.folderListModel.addElement("-- " + Translation.get("dialog.link_folder_online.select_text") + " --");
        this.folderList.addItemListener(new MyItemListener());
        MyLinkClearAction myLinkClearAction = new MyLinkClearAction(this.getController());
        this.clearButton = new JButton(myLinkClearAction);
        if (StringUtils.isBlank(this.currentFolderName)) {
            myLinkClearAction.setEnabled(false);
        }
        this.linkAction = new MyLinkAction(this.getController());
        this.linkButton = new JButton(this.linkAction);
        this.cancelButton = LinkFolderOnlineDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkFolderOnlineDialog.this.close();
            }
        });
        this.populateOnlineFolders();
    }

    @Override
    public String getTitle() {
        return Translation.get("link_folder.dialog.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("pref, 3dlu, max(140dlu;pref):grow", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel(Translation.get("link_folder.dialog.description"), cellConstraints.xyw(1, n, 3));
        panelBuilder.addLabel(Translation.get("link_folder.dialog.link_text"), cellConstraints.xy(1, n += 2));
        panelBuilder.add(this.folderList, cellConstraints.xy(3, n));
        return panelBuilder.getPanel();
    }

    @Override
    protected Component getButtonBar() {
        return ButtonBarFactory.buildCenteredBar(this.linkButton, this.clearButton, this.cancelButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.linkButton;
    }

    private void link() {
        this.parent.link(this.file, (String)this.folderList.getSelectedItem());
        this.close();
    }

    private void clearLink() {
        this.parent.link(this.file, null);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateOnlineFolders() {
        ServerClient serverClient = this.getController().getOSClient();
        AtomicBoolean atomicBoolean = this.populated;
        synchronized (atomicBoolean) {
            boolean bl = this.populated.get();
            if (serverClient != null && serverClient.isConnected() && serverClient.isLoggedIn()) {
                if (!bl) {
                    this.folderListModel.removeAllElements();
                    this.folderListModel.addElement("-- " + Translation.get("dialog.link_folder_online.select_text") + " --");
                    Collection<FolderInfo> collection = this.getController().getFolderRepository().getJoinedFolderInfos();
                    Collection<FolderInfo> collection2 = serverClient.getAccountFolders();
                    for (FolderInfo folderInfo : collection2) {
                        if (collection.contains(folderInfo)) continue;
                        this.folderListModel.addElement(folderInfo.getName());
                    }
                    this.populated.set(true);
                    if (this.folderList.getSelectedIndex() == 0 && !StringUtils.isBlank(this.currentFolderName)) {
                        for (int i = 0; i < this.folderListModel.getSize(); ++i) {
                            if (!this.folderListModel.getElementAt(i).equals(this.currentFolderName)) continue;
                            this.folderList.setSelectedIndex(i);
                            break;
                        }
                    }
                }
            } else if (bl) {
                this.folderListModel.removeAllElements();
                this.folderListModel.addElement("-- " + Translation.get("dialog.link_folder_online.select_text") + " --");
                this.populated.set(false);
            }
            this.enableLinkAction();
        }
    }

    private void enableLinkAction() {
        this.linkAction.setEnabled(this.folderList.getSelectedIndex() > 0);
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            LinkFolderOnlineDialog.this.populateOnlineFolders();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            LinkFolderOnlineDialog.this.enableLinkAction();
        }
    }

    private class MyLinkClearAction
    extends BaseAction {
        MyLinkClearAction(Controller controller) {
            super("action_clear_link_directory", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LinkFolderOnlineDialog.this.clearLink();
        }
    }

    private class MyLinkAction
    extends BaseAction {
        MyLinkAction(Controller controller) {
            super("action_link_directory", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LinkFolderOnlineDialog.this.link();
        }
    }
}

