/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class FolderRemoveDialog
extends BaseDialog {
    private final FolderInfo foInfo;
    private Folder folder;
    private boolean localFolder;
    private boolean onlineFolder;
    private boolean admin;
    private JButton removeButton;
    private JButton cancelButton;
    private JLabel messageLabel;
    private JCheckBox removeFromServerBox;
    private JCheckBox deleteSystemSubFolderBox;
    private JCheckBox deleteFolderCompletelyBox;

    public FolderRemoveDialog(Controller controller, FolderInfo folderInfo) {
        super(BaseDialog.Senior.MAIN_FRAME, controller, true);
        Reject.ifNull(folderInfo, "FolderInfo");
        this.foInfo = folderInfo;
        this.folder = folderInfo.getFolder(this.getController());
        this.onlineFolder = this.getController().getOSClient().getAccount().hasReadPermissions(folderInfo);
        this.admin = this.getController().getOSClient().getAccount().hasAdminPermission(folderInfo);
        this.localFolder = this.folder != null;
    }

    private void initComponents() {
        String string;
        String string2;
        boolean bl;
        boolean bl2 = ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()) == false || this.getController().getOSClient().getAccount().hasPermission(FolderRemovePermission.INSTANCE);
        boolean bl3 = bl = this.folder != null && this.folder.isTransferring();
        if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
            string2 = "folder_remove.dialog.strict.online_text";
            string = "folder_remove.dialog.strict.online_text.admin";
        } else {
            string2 = "folder_remove.dialog.online_text";
            string = "folder_remove.dialog.online_text.admin";
        }
        String string3 = this.admin ? (this.onlineFolder && !this.localFolder ? string : "folder_remove.dialog.text") : (this.onlineFolder && !this.localFolder ? string2 : "folder_remove.dialog.text");
        Object object = bl ? Translation.get(string3, this.foInfo.getLocalizedName()) + "\n" + Translation.get("folder_remove.dialog.sync_warning") : Translation.get(string3, this.foInfo.getLocalizedName());
        this.messageLabel = new JLabel((String)object);
        this.deleteSystemSubFolderBox = SimpleComponentFactory.createCheckBox(Translation.get("folder_remove.dialog.delete"));
        this.deleteSystemSubFolderBox.setEnabled(bl2);
        this.deleteSystemSubFolderBox.setVisible(bl2);
        this.removeFromServerBox = SimpleComponentFactory.createCheckBox(Translation.get("folder_remove.dialog.remove_from_os"));
        this.removeFromServerBox.addActionListener(new ConvertActionListener());
        this.removeFromServerBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FolderRemoveDialog.this.getApplicationModel().getServerClientModel().checkAndSetupAccount();
            }
        });
        this.removeFromServerBox.setSelected(!this.localFolder && this.onlineFolder);
        this.removeFromServerBox.setEnabled(bl2);
        this.removeFromServerBox.setVisible(bl2);
        this.deleteFolderCompletelyBox = SimpleComponentFactory.createCheckBox(Translation.get("folder_remove.dialog.remove_completely"));
        this.deleteFolderCompletelyBox.setEnabled(bl2);
        this.deleteFolderCompletelyBox.setVisible(bl2);
        this.deleteFolderCompletelyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FolderRemoveDialog.this.deleteSystemSubFolderBox.setEnabled(!FolderRemoveDialog.this.deleteFolderCompletelyBox.isSelected());
                FolderRemoveDialog.this.deleteSystemSubFolderBox.setSelected(FolderRemoveDialog.this.deleteFolderCompletelyBox.isSelected());
                FolderRemoveDialog.this.configureComponents();
            }
        });
        this.createRemoveButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FolderRemoveDialog.this.confirmedFolderLeave(FolderRemoveDialog.this.deleteSystemSubFolderBox.isSelected(), FolderRemoveDialog.this.removeFromServerBox.isSelected(), FolderRemoveDialog.this.deleteFolderCompletelyBox.isSelected());
            }
        });
        this.cancelButton = FolderRemoveDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FolderRemoveDialog.this.close();
            }
        });
    }

    private void createRemoveButton(ActionListener actionListener) {
        String string;
        String string2 = string = !this.admin ? "folder_remove_online.dialog.button.name" : "folder_remove_online.dialog.button.name.admin";
        if (!this.localFolder) {
            this.removeButton = new JButton(Translation.get(string));
            this.removeButton.setMnemonic(Translation.get("folder_remove_online.dialog.button.key").trim().charAt(0));
        } else {
            this.removeButton = new JButton(Translation.get("folder_remove.dialog.button.name"));
            this.removeButton.setMnemonic(Translation.get("folder_remove.dialog.button.key").trim().charAt(0));
        }
        this.removeButton.addActionListener(actionListener);
    }

    @Override
    public String getTitle() {
        String string;
        String string2 = string = !this.admin ? "folder_remove_online.dialog.title" : "folder_remove_online.dialog.title.admin";
        if (!this.localFolder) {
            return Translation.get(string);
        }
        return Translation.get("folder_remove.dialog.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.initComponents();
        FormLayout formLayout = this.localFolder ? (this.onlineFolder ? new FormLayout("pref:grow, 3dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref") : new FormLayout("pref:grow, 3dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref")) : (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()) != false ? new FormLayout("pref:grow, 3dlu, pref:grow", "pref, 3dlu, pref") : new FormLayout("pref:grow, 3dlu, pref:grow", "pref"));
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.messageLabel, cellConstraints.xyw(1, n, 3));
        n += 2;
        if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue() && !this.localFolder) {
            String string = this.admin ? Translation.get("folder_remove_online.strict.note.admin") : Translation.get("folder_remove_online.strict.note");
            panelBuilder.add((Component)new JLabel(string), cellConstraints.xyw(1, n, 3));
            n += 2;
        }
        if (this.localFolder) {
            panelBuilder.add((Component)this.deleteSystemSubFolderBox, cellConstraints.xyw(1, n, 3));
            panelBuilder.add((Component)this.deleteFolderCompletelyBox, cellConstraints.xyw(1, n += 2, 3));
            n += 2;
        }
        this.configureComponents();
        return panelBuilder.getPanel();
    }

    @Override
    protected Component getButtonBar() {
        return ButtonBarFactory.buildCenteredBar(this.removeButton, this.cancelButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.removeButton;
    }

    private void configureComponents() {
        if (!this.localFolder && !this.onlineFolder) {
            this.removeButton.setEnabled(false);
        }
    }

    private void confirmedFolderLeave(boolean bl, boolean bl2, boolean bl3) {
        SwingWorker swingWorker;
        this.close();
        FolderRepository folderRepository = this.getController().getFolderRepository();
        final Folder folder = this.foInfo.getFolder(this.getController());
        if (folder != null) {
            folderRepository.addToIgnoredFolders(folder);
            folderRepository.removeFolder(folder, bl);
        }
        if (bl2) {
            swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ServerClient serverClient = FolderRemoveDialog.this.getController().getOSClient();
                    serverClient.getFolderService(FolderRemoveDialog.this.foInfo).removeFolder(FolderRemoveDialog.this.foInfo, true, true);
                    return null;
                }
            };
            swingWorker.execute();
        }
        if (bl3 && folder != null) {
            swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() {
                    try {
                        PathUtils.recursiveDelete(folder.getLocalBase());
                    }
                    catch (IOException iOException) {
                        FolderRemoveDialog.this.logFine("Could not remove folder content. " + iOException);
                    }
                    return null;
                }
            };
            swingWorker.execute();
        }
    }

    private class ConvertActionListener
    implements ActionListener {
        private ConvertActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderRemoveDialog.this.configureComponents();
        }
    }
}

