/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ErrorDialog
extends PFUIComponent {
    private JButton okButton;
    private JButton detailsButton;
    private JDialog uiComponent;
    private boolean modal;
    private String errorTxt;
    private JPanel downPanel;
    private TitledBorder title;
    private JTextArea errorsField;
    private int oldWidth;
    private int oldHeight;
    private int kindOfError;
    private int h = 120;

    public ErrorDialog(Controller controller, boolean bl) {
        super(controller);
        this.modal = bl;
    }

    public final void open(String string, int n) {
        this.errorTxt = string;
        this.kindOfError = n;
        this.logFiner("Open called: " + this);
        if (this.isOpen()) {
            this.close();
        }
        this.getUIComponent().setVisible(true);
    }

    public final void close() {
        this.logFiner("Close called: " + this);
        if (this.uiComponent != null) {
            this.uiComponent.dispose();
            this.uiComponent = null;
        }
    }

    public final boolean isOpen() {
        this.logFiner("Close called: " + this);
        return this.uiComponent != null;
    }

    protected JButton createOKButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.ok"));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected JButton createDetailsButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("exp.preferences.dyn_dns.error_expand_button"));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void initComponents() {
        this.errorsField = new JTextArea(this.errorTxt);
        this.errorsField.setLineWrap(true);
        this.errorsField.setWrapStyleWord(true);
        this.detailsButton = this.createDetailsButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        ErrorDialog.this.setDetailsPanelVisible(!ErrorDialog.this.downPanel.isVisible());
                        ErrorDialog.this.errorsField.setSize(ErrorDialog.this.uiComponent.getWidth() - 40, ErrorDialog.this.uiComponent.getHeight());
                        ErrorDialog.this.uiComponent.validate();
                        ErrorDialog.this.uiComponent.repaint();
                    }
                }.start();
            }
        });
        this.okButton = this.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.close();
            }
        });
    }

    private JPanel createErrorPanel() {
        FormLayout formLayout = new FormLayout("max(0;pref):grow,pref,pref", "max(0;pref):grow, pref, pref, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.errorsField, cellConstraints.xywh(1, 1, 2, 3));
        JPanel jPanel = panelBuilder.getPanel();
        if (this.kindOfError == 2) {
            this.title = BorderFactory.createTitledBorder("Error Details");
        }
        if (this.kindOfError == 1) {
            this.title = BorderFactory.createTitledBorder("Warning Details");
        }
        jPanel.setBorder(this.title);
        return jPanel;
    }

    private final Component getErrorContent() {
        this.downPanel = new JPanel();
        this.downPanel.add(this.createErrorPanel());
        return this.downPanel;
    }

    private JPanel createGeneralPanel() {
        FormLayout formLayout = new FormLayout("max(0;pref):grow, pref", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        if (this.kindOfError == 1) {
            panelBuilder.add((Component)new JLabel(Translation.get("exp.preferences.dyn_dns_update_warning") + "  " + this.getController().getDynDnsManager().activeDynDns.getErrorShortText() + "  "), cellConstraints.xywh(1, 1, 1, 1));
        }
        if (this.kindOfError == 2) {
            panelBuilder.add((Component)new JLabel(Translation.get("exp.preferences.dyn_dns.update_error") + "  " + this.getController().getDynDnsManager().activeDynDns.getErrorShortText() + "  "), cellConstraints.xywh(1, 1, 1, 1));
        }
        JPanel jPanel = panelBuilder.getPanel();
        return jPanel;
    }

    protected Component getContent() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.createGeneralPanel());
        return jPanel;
    }

    private String getTitle() {
        return Translation.get("preferences.dyn_dns.update_title");
    }

    protected Component getButtonBar() {
        return ButtonBarFactory.buildRightAlignedBar(this.okButton, this.detailsButton);
    }

    private Dimension setPrefferedSize(int n, int n2) {
        return new Dimension(n, n2);
    }

    private void shrink() {
        this.uiComponent.setSize(this.oldWidth, this.oldHeight);
    }

    private void expand() {
        this.oldWidth = this.uiComponent.getWidth();
        this.oldHeight = this.uiComponent.getHeight();
        this.uiComponent.setSize(this.uiComponent.getWidth(), this.uiComponent.getHeight() + 110);
    }

    private void setDetailsPanelVisible(boolean bl) {
        this.downPanel.setVisible(bl);
        if (this.downPanel.isVisible()) {
            this.expand();
            this.detailsButton.setText(Translation.get("exp.preferences.dyn_dns.error_shrink_button"));
        } else {
            this.shrink();
            this.detailsButton.setText(Translation.get("exp.preferences.dyn_dns.error_expand_button"));
        }
    }

    protected final JDialog getUIComponent() {
        this.initComponents();
        if (this.uiComponent == null) {
            this.logFiner("Building ui component for " + this);
            this.uiComponent = new JDialog(this.getUIController().getMainFrame().getUIComponent(), this.getTitle(), this.modal);
            this.uiComponent.setResizable(false);
            this.uiComponent.setDefaultCloseOperation(2);
            FormLayout formLayout = new FormLayout("max(0;pref):grow, 15dlu, pref, 6dlu, pref, pref", "pref, 25dlu, pref, 25dlu, pref, 25dlu, pref, 25dlu, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.DLU7_BORDER);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add(this.getContent(), cellConstraints.xywh(1, 1, 4, 1));
            panelBuilder.add(this.getButtonBar(), cellConstraints.xywh(1, 2, 4, 1));
            panelBuilder.add(this.getErrorContent(), cellConstraints.xywh(1, 4, 4, 5));
            this.setDetailsPanelVisible(false);
            this.uiComponent.getContentPane().add(panelBuilder.getPanel());
            this.uiComponent.pack();
            Window window = this.uiComponent.getOwner();
            int n = window.getX() + (window.getWidth() - this.uiComponent.getWidth()) / 2;
            int n2 = window.getY() + (window.getHeight() - this.uiComponent.getHeight()) / 2;
            this.uiComponent.setSize(this.setPrefferedSize(this.uiComponent.getWidth(), this.h));
            this.uiComponent.setLocation(n, n2);
        }
        return this.uiComponent;
    }
}

