/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.notification.NotificationHandlerBase;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Translation;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class ShareFolderNotificationHandler
extends NotificationHandlerBase {
    ShareFolderNotificationHandler(final Controller controller, final FolderInfo folderInfo) {
        super(controller);
        this.setTitle(Translation.get("context_menu.share_folder.notification.title"));
        this.setMessageText(Translation.get("context_menu.share_folder.notification.message", folderInfo.getLocalizedName(), folderInfo.getFolder(controller).getLocalBase().toString()));
        if (ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(controller).booleanValue()) {
            this.setAcceptOptionLabel(Translation.get("context_menu.share_folder.notification.accept_label"));
            this.setAcceptAction(new AbstractAction(){
                private static final long serialVersionUID = 100L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    controller.getIOProvider().startIO(new Runnable(){

                        @Override
                        public void run() {
                            ShareFolderNotificationHandler.this.sliderClose();
                            String string = controller.getOSClient().getFolderURLWithCredentials(folderInfo);
                            BrowserLauncher.openURL(controller, string);
                        }
                    });
                }
            });
        }
        this.setCancelOptionLabel(Translation.get("context_menu.share_folder.notification.cancel_label"));
        this.setCancelAction(new AbstractAction(){
            private static final long serialVersionUID = 100L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UIUtil.invokeLaterInEDT(new Runnable(){

                    @Override
                    public void run() {
                        ShareFolderNotificationHandler.this.sliderClose();
                        PFWizard.openSendInvitationWizard(controller, folderInfo);
                        controller.getUIController().getMainFrame().toFront();
                    }
                });
            }
        });
    }
}

