/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.task.CreateFolderOnServerTask;
import de.dal33t.powerfolder.ui.contextmenu.ShareFolderNotificationHandler;
import de.dal33t.powerfolder.ui.wizard.ChooseDiskLocationPanel;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

class ShareFolderAction
extends ContextMenuAction {
    private static final Logger log = Logger.getLogger(ShareFolderAction.class.getName());
    private Controller controller;
    private FolderRepository repository;

    ShareFolderAction(Controller controller) {
        this.controller = controller;
        this.repository = controller.getFolderRepository();
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            for (String string : stringArray) {
                Path path = Paths.get(string, new String[0]);
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                Folder folder = this.repository.findExistingFolder(path);
                final FolderInfo folderInfo = this.getFolderInfo(path, folder);
                SyncProfile syncProfile = SyncProfile.getDefault(this.controller);
                boolean bl = this.controller.getOSClient().isBackupByDefault();
                if (this.controller.isUIEnabled()) {
                    if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(this.controller).booleanValue()) {
                        if (folder != null) {
                            this.controller.getIOProvider().startIO(new Runnable(){

                                @Override
                                public void run() {
                                    PFWizard.openSendInvitationWizard(ShareFolderAction.this.controller, folderInfo);
                                    ShareFolderAction.this.controller.getUIController().getMainFrame().toFront();
                                }
                            });
                            continue;
                        }
                        this.createFolder(path, folderInfo, syncProfile, bl);
                        this.showNotification(folderInfo);
                        continue;
                    }
                    if (folder != null) {
                        this.controller.getIOProvider().startIO(new Runnable(){

                            @Override
                            public void run() {
                                PFWizard.openSendInvitationWizard(ShareFolderAction.this.controller, folderInfo);
                                ShareFolderAction.this.controller.getUIController().getMainFrame().toFront();
                            }
                        });
                        continue;
                    }
                    this.showFolderSetupWizard(path, folderInfo, syncProfile, bl);
                    continue;
                }
                this.createFolder(path, folderInfo, syncProfile, bl);
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while trying to share folder " + runtimeException, runtimeException);
        }
    }

    private FolderInfo getFolderInfo(Path path, Folder folder) {
        FolderInfo folderInfo;
        if (folder != null) {
            folderInfo = folder.getInfo();
        } else {
            String string = PathUtils.getSuggestedFolderName(path);
            folderInfo = FolderInfoFactory.newTopFolder(string);
        }
        return folderInfo;
    }

    private void createFolder(Path path, FolderInfo folderInfo, SyncProfile syncProfile, boolean bl) {
        FolderSettings folderSettings = new FolderSettings(path, syncProfile, null, ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.controller), true);
        Folder folder = this.repository.createFolder(folderInfo, folderSettings);
        folder.addDefaultExcludes();
        if (bl) {
            new CreateFolderOnServerTask(folderInfo, null).scheduleTask(this.controller);
        }
    }

    private void showFolderSetupWizard(final Path path, final FolderInfo folderInfo, final SyncProfile syncProfile, final boolean bl) {
        this.controller.getIOProvider().startIO(new Runnable(){

            @Override
            public void run() {
                PFWizard pFWizard = new PFWizard(ShareFolderAction.this.controller, Translation.get("wizard.pfwizard.folder_title"));
                pFWizard.getWizardContext().setAttribute("disklocation.initial_folder_name", folderInfo.getName());
                pFWizard.getWizardContext().setAttribute("disklocation.sync_profile", syncProfile);
                pFWizard.getWizardContext().setAttribute("folder_create.backup_by_os", bl);
                pFWizard.getWizardContext().setAttribute("disklocation.folder_info", folderInfo);
                FolderCreatePanel folderCreatePanel = new FolderCreatePanel(ShareFolderAction.this.controller);
                TextPanelPanel textPanelPanel = new TextPanelPanel(ShareFolderAction.this.controller, Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
                pFWizard.getWizardContext().setAttribute("successpanel", textPanelPanel);
                ChooseDiskLocationPanel chooseDiskLocationPanel = new ChooseDiskLocationPanel(ShareFolderAction.this.controller, path.toAbsolutePath().toString(), folderCreatePanel);
                pFWizard.open(chooseDiskLocationPanel);
                ShareFolderAction.this.controller.getUIController().getMainFrame().toFront();
            }
        });
    }

    private void showNotification(FolderInfo folderInfo) {
        ShareFolderNotificationHandler shareFolderNotificationHandler = new ShareFolderNotificationHandler(this.controller, folderInfo);
        shareFolderNotificationHandler.show();
    }
}

