/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.notification.NotificationHandlerBase;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ShareFileNotificationHandler
extends NotificationHandlerBase {
    public ShareFileNotificationHandler(final Controller controller, final FileInfo fileInfo, final String string) {
        super(controller);
        this.setTitle(Translation.get("context_menu.share_link.notification.title"));
        this.setMessageText(Translation.get("context_menu.share_link.notification.message", fileInfo.getFilenameOnly()));
        this.setCancelOptionLabel(Translation.get("context_menu.share_link.notification.cancel_label"));
        this.setCancelAction(new AbstractAction(){
            private static final long serialVersionUID = 100L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controller.getIOProvider().startIO(new Runnable(){

                    @Override
                    public void run() {
                        ShareFileNotificationHandler.this.sliderClose();
                        Util.setClipboardContents(string);
                        try {
                            controller.getOSClient().getFolderService(fileInfo.getFolderInfo()).removeFileLink(fileInfo);
                        }
                        catch (RuntimeException runtimeException) {
                            ShareFileNotificationHandler.this.logWarning("The server you use does not support file link removal. Please consider to update your server.");
                        }
                    }
                });
            }
        });
    }
}

