/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.ui.contextmenu.PFContextMenuAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.util.Translation;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LockInfoAction
extends PFContextMenuAction {
    private static final Logger log = Logger.getLogger(LockInfoAction.class.getName());

    LockInfoAction(Controller controller) {
        super(controller);
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            final List<FileInfo> list = this.getFileInfos(stringArray);
            if (list.size() != 1) {
                log.warning("More than one file was selected for locking information. Not showing any info.");
                return;
            }
            this.getController().getIOProvider().startIO(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileInfo fileInfo = (FileInfo)list.get(0);
                        Lock lock = fileInfo.getLock(LockInfoAction.this.getController());
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm");
                        String string = fileInfo.getFilenameOnly();
                        String string2 = simpleDateFormat.format(lock.getCreated());
                        String string3 = lock.getAccountInfo().getDisplayName();
                        String string4 = Translation.get("context_menu.lock_information.message.web");
                        MemberInfo memberInfo = lock.getMemberInfo();
                        if (memberInfo != null) {
                            string4 = memberInfo.getNick();
                        }
                        DialogFactory.genericDialog(LockInfoAction.this.getController(), Translation.get("context_menu.lock_information.title"), Translation.get("context_menu.lock_information.message", string, string3, string2, string4), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.INFO);
                    }
                    catch (RuntimeException runtimeException) {
                        log.log(Level.WARNING, "Problem while trying to view locking dialog. " + runtimeException, runtimeException);
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while trying to view locking information. " + runtimeException, runtimeException);
        }
    }
}

