/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer.swarm;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.swarm.FileRecordProvider;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.delta.FilePartsRecordBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;

public abstract class AbstractFileRecordProvider
implements FileRecordProvider {
    private static final Logger log = Logger.getLogger(AbstractFileRecordProvider.class.getName());
    private Controller controller;

    public AbstractFileRecordProvider(Controller controller) {
        Reject.ifNull(controller, "Controller is null!");
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    protected FilePartsRecord computeFilePartsRecord(FileInfo fileInfo, ProgressListener progressListener) throws IOException {
        FilePartsRecord filePartsRecord;
        block11: {
            assert (fileInfo != null);
            long l = System.currentTimeMillis();
            Path path = fileInfo.getDiskFile(this.controller.getFolderRepository());
            int n = Math.max(4096, (int)(Math.pow(Files.size(path), 0.25) * 2048.0));
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                FilePartsRecordBuilder filePartsRecordBuilder = new FilePartsRecordBuilder(new Adler32(), MessageDigest.getInstance("SHA-256"), MessageDigest.getInstance("MD5"), n);
                int n2 = 0;
                byte[] byArray = new byte[8192];
                long l2 = 0L;
                long l3 = Files.size(path);
                while ((n2 = inputStream.read(byArray)) > 0) {
                    filePartsRecordBuilder.update(byArray, 0, n2);
                    if (progressListener == null) continue;
                    progressListener.progressReached((double)l2 / (double)l3);
                    l2 += (long)n2;
                }
                FilePartsRecord filePartsRecord2 = filePartsRecordBuilder.getRecord();
                long l4 = System.currentTimeMillis() - l;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Built file parts for " + this + ". took " + l4 + "ms while processing " + l2 + " bytes.");
                }
                filePartsRecord = filePartsRecord2;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
            inputStream.close();
        }
        return filePartsRecord;
    }
}

