/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.test;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.PathUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.logging.Logger;

public class Test {
    private static final Logger log = Logger.getLogger(Test.class.getName());

    public static void main(String[] stringArray) throws IOException {
        Test test = new Test();
        log.info("------------- Starting tests ----------------------------------");
        test.testWebStartMime();
        log.info("---------------------------------------------------------------");
        test.testCorruptZipFile();
        log.info("---------------------------------------------------------------");
        test.testInt2Bytes();
        log.info("---------------------------------------------------------------");
        test.testFileChunkSize();
        log.info("---------------------------------------------------------------");
        if (stringArray != null && stringArray.length > 0) {
            test.testSocketResolving(stringArray[0]);
            log.info("---------------------------------------------------------------");
        }
        test.testTimeCalculations();
        log.info("---------------------------------------------------------------");
        test.testFileWrite();
        log.info("---------------------------------------------------------------");
    }

    private void testWebStartMime() {
        try {
            URL uRL = new URL("http://webstart.powerfolder.com/release/PowerFolder.jnlp");
            log.info("Testing mime type for webstart URL '" + uRL + "'");
            log.info("Mime type is " + uRL.openConnection().getContentType());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void testCorruptZipFile() {
        Path path = Paths.get("test.jar", new String[0]);
        log.info(path + " is a valid zip ? " + PathUtils.isValidZipFile(path));
    }

    private void testInt2Bytes() {
        int n = 12345678;
        log.info("Testing int 2 byte conversion with " + n);
        byte by = (byte)(n & 0xFF);
        byte by2 = (byte)(0xFF & n >> 8);
        byte by3 = (byte)(0xFF & n >> 16);
        int n2 = 0xFF & n >> 24;
        log.info("Byte 1: " + by);
        log.info("Byte 2: " + by2);
        log.info("Byte 3: " + by3);
        log.info("Byte 4: " + (byte)n2);
        int n3 = 0;
        n3 = n2 < 0 ? n2 + 256 : n2;
        n3 <<= 8;
        n3 = by3 < 0 ? (n3 += by3 + 256) : (n3 += by3);
        n3 <<= 8;
        n3 = by2 < 0 ? (n3 += by2 + 256) : (n3 += by2);
        n3 <<= 8;
        n3 = by < 0 ? (n3 += by + 256) : (n3 += by);
        n3 = Convert.convert2Int(new byte[]{n2, by3, by2, by});
        log.info("Converted back to: " + n3);
    }

    private void testFileChunkSize() throws IOException {
        FileChunk fileChunk = new FileChunk();
        fileChunk.data = new byte[Integer.valueOf(ConfigurationEntry.TRANSFERS_MAX_FILE_CHUNK_SIZE.getDefaultValue()).intValue()];
        Path path = Paths.get("test.chunk", new String[0]);
        log.info("Writing test chunk (" + fileChunk.data.length + " bytes) to " + path);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));
        objectOutputStream.writeObject(fileChunk);
        objectOutputStream.close();
    }

    private void testSocketResolving(String string) {
        log.info("Testing local socket resolving for '" + string + "'");
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, 1337);
        log.info("Socket successfully created: " + inetSocketAddress);
        log.info("Is fully resolved ?: " + !inetSocketAddress.isUnresolved());
    }

    private void testTimeCalculations() {
        log.info("Testing date calculation/UTC");
        log.info("Current time in UTC: " + new Date(Convert.convertToUTC(new Date())));
    }

    private boolean testFileWrite() throws IOException {
        Path path = Paths.get("test.xxx", new String[0]);
        log.info("Testing modified Date differ on file " + path);
        Object object = "xx";
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 20; ++i) {
            OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.APPEND);
            object = (String)object + (String)object;
            outputStream.write(((String)object).getBytes());
            outputStream.close();
            long l = Convert.convertToGlobalPrecision(System.currentTimeMillis());
            Files.setLastModifiedTime(path, FileTime.fromMillis(l));
            long l2 = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            long l3 = Convert.convertToGlobalPrecision(l);
            if (l2 == l) {
                ++n;
            } else {
                log.warning("Last-modfied differs from last-modified on file:");
                log.warning("Set:  " + new Date(l) + " in ms: " + l);
                log.warning("File: " + new Date(l2) + " in ms: " + l2);
                log.warning("Expt: " + new Date(l3) + " in ms: " + l3);
                ++n2;
            }
            try {
                Thread.sleep((long)(Math.random() * 500.0));
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        log.info("testFileWrite finished. matches: " + n + ", incorrect dates: " + n2);
        return n2 != 0;
    }
}

