/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.task.PersistentTask;

public class SendMessageTask
extends PersistentTask {
    private static final long serialVersionUID = 1L;
    private Message message;
    private String targetID;
    private transient NodeManagerListener listener;

    public SendMessageTask(Message message, String string) {
        super(30);
        this.message = message;
        this.targetID = string;
    }

    @Override
    public void initialize() {
        if (this.message == null || this.targetID == null || this.isExpired()) {
            this.remove();
            return;
        }
        this.listener = new MessageTrigger();
        if (!this.execute()) {
            this.getController().getNodeManager().addNodeManagerListener(this.listener);
            Member member = this.getController().getNodeManager().getNode(this.targetID);
            if (member != null) {
                member.markForImmediateConnect();
            }
        }
    }

    private boolean execute() {
        Member member = this.getController().getNodeManager().getNode(this.targetID);
        if (member != null && member.isCompletelyConnected()) {
            member.sendMessageAsynchron(this.message);
            this.remove();
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
        try {
            if (this.getController() != null && this.getController().getNodeManager() != null && this.listener != null) {
                this.getController().getNodeManager().removeNodeManagerListener(this.listener);
            }
        }
        finally {
            super.shutdown();
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public String toString() {
        return "SendMessageTask trying to send " + this.message + " to " + this.targetID + " until " + this.getExpires().getTime();
    }

    private class MessageTrigger
    extends NodeManagerAdapter {
        private MessageTrigger() {
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            if (nodeManagerEvent.getNode().getId().equals(SendMessageTask.this.targetID)) {
                SendMessageTask.this.execute();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

