/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.task.ServerRemoteCallTask;
import de.dal33t.powerfolder.util.Reject;
import java.util.logging.Logger;

public class CreateFolderOnServerTask
extends ServerRemoteCallTask {
    private static final Logger LOG = Logger.getLogger(CreateFolderOnServerTask.class.getName());
    private static final long serialVersionUID = 100L;
    private FolderInfo foInfo;
    private SyncProfile syncProfile;
    private Integer archiveVersions;

    public CreateFolderOnServerTask(AccountInfo accountInfo, FolderInfo folderInfo, SyncProfile syncProfile) {
        super(accountInfo, 30);
        Reject.ifNull(folderInfo, "FolderInfo");
        this.foInfo = folderInfo;
        this.syncProfile = syncProfile;
    }

    public CreateFolderOnServerTask(FolderInfo folderInfo, SyncProfile syncProfile) {
        super(30);
        Reject.ifNull(folderInfo, "FolderInfo");
        this.foInfo = folderInfo;
        this.syncProfile = syncProfile;
    }

    public Integer getArchiveVersions() {
        return this.archiveVersions;
    }

    public void setArchiveVersions(Integer n) {
        this.archiveVersions = n;
    }

    @Override
    public boolean executeRemoteCall(ServerClient serverClient) throws Exception {
        if (!this.getController().getFolderRepository().hasJoinedFolder(this.foInfo)) {
            LOG.warning("Not longer locally synced. Not setting up cloud sync for: " + this.foInfo);
            this.remove();
            return true;
        }
        if (serverClient.isLoggedIn()) {
            LOG.info("Setting folder up for cloud sync: " + this.foInfo);
            serverClient.getFolderService().createFolder(this.foInfo, this.syncProfile);
            if (this.archiveVersions != null && serverClient.getAccount().hasAdminPermission(this.foInfo)) {
                try {
                    serverClient.getFolderService(this.foInfo).setArchiveMode(this.foInfo, this.archiveVersions);
                }
                catch (RemoteCallException remoteCallException) {
                    LOG.warning(this.foInfo + ": Unable to set versions to " + this.archiveVersions + ": " + remoteCallException);
                }
            }
            if (serverClient.getAccount().hasReadPermissions(this.foInfo)) {
                this.remove();
                return true;
            }
            LOG.warning("Did not receive access permission to " + this.foInfo);
        }
        return false;
    }
}

