/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.AuditFields;
import de.dal33t.powerfolder.security.Auditable;
import de.dal33t.powerfolder.security.CustomFields;
import de.dal33t.powerfolder.security.OnlineStorageSubscription;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Organization
implements Serializable,
Auditable {
    private static final Logger LOG = Logger.getLogger(Organization.class.getName());
    private static final long serialVersionUID = 100L;
    public static final int UNLIMITED_USERS = 999999999;
    public static final String FILTER_MATCH_ALL = "/ALL/";
    public static final String PROPERTYNAME_OID = "oid";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_LDAPDN = "ldapDN";
    public static final String PROPERTYNAME_NOTES = "notes";
    public static final String PROPERTYNAME_OSS = "osSubscription";
    public static final String PROPERTYNAME_MAX_USERS = "maxUsers";
    @Id
    private String oid;
    @Index(name="IDX_ORGANIZATION_NAME")
    @Column(nullable=false)
    private String name;
    @Column(length=2048)
    private String notes;
    private int maxUsers;
    @Index(name="IDX_ORGANIZATION_LDAPDN")
    @Column(length=512)
    private String ldapDN;
    @Column(length=512)
    private String basePath;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    private OnlineStorageSubscription osSubscription;
    @CollectionOfElements
    @IndexColumn(name="IDX_DOMAINS", base=0, nullable=false)
    @Cascade(value={CascadeType.ALL})
    @Column(name="domain", length=512)
    @BatchSize(size=1337)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<String> domains;
    private String skin;
    @Column(length=4000)
    private String jsonData;
    private boolean isRestrictedToDomain;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    private CustomFields customFields;
    @Column(length=10)
    private String color1;
    @Column(length=10)
    private String color2;
    @Column(length=10)
    private String color3;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    public AuditFields auditFields = new AuditFields();

    public Organization() {
        this(IdGenerator.makeId());
    }

    public Organization(String string) {
        Reject.ifBlank(string, "OID");
        this.oid = string;
        this.osSubscription = new OnlineStorageSubscription();
        this.domains = new CopyOnWriteArrayList<String>();
        this.customFields = new CustomFields();
    }

    public String getOID() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setMaxUsers(int n) {
        this.maxUsers = n;
    }

    public void setUnlimitedUsers() {
        this.maxUsers = 999999999;
    }

    public boolean isUnlimitedUsers() {
        return this.maxUsers == 999999999;
    }

    public boolean hasMaxUsers() {
        return this.maxUsers > 0 && this.maxUsers != 999999999;
    }

    public void setLdapDN(String string) {
        this.ldapDN = string;
    }

    public String getLdapDN() {
        return this.ldapDN;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public OnlineStorageSubscription getOSSubscription() {
        return this.osSubscription;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String string) {
        this.skin = string;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = StringUtils.cutNotes(string);
    }

    public List<String> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    public void setDomains(List<String> list) {
        Reject.ifNull(list, "Domains");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string == null) continue;
            string = string.trim().toLowerCase();
            arrayList.add(string);
        }
        this.domains = arrayList;
    }

    public void setJSONData(String string) {
        this.jsonData = string;
    }

    public String getJSONData() {
        return this.jsonData;
    }

    public JSONObject getJSONObject() {
        if (StringUtils.isBlank(this.jsonData)) {
            return new JSONObject();
        }
        try {
            return new JSONObject(this.jsonData);
        }
        catch (JSONException jSONException) {
            boolean bl;
            boolean bl2 = bl = "undefined".equalsIgnoreCase(this.jsonData) || "[object Object]".equalsIgnoreCase(this.jsonData);
            if (!bl) {
                LOG.log(Level.WARNING, "Resetting JSON data for " + this.name + ". Illegal value '" + this.jsonData + "'. " + jSONException.getMessage(), jSONException);
            }
            return new JSONObject();
        }
    }

    public void setJSONObject(JSONObject jSONObject) {
        if (jSONObject == null) {
            this.jsonData = null;
            return;
        }
        this.jsonData = jSONObject.toString();
    }

    public boolean isRestrictedToDomain() {
        return this.isRestrictedToDomain;
    }

    public void setRestrictedToDomain(boolean bl) {
        this.isRestrictedToDomain = bl;
    }

    public boolean isInDomainList(String string) {
        string = string.substring(string.indexOf("@") + 1);
        for (String string2 : Organization.prepareDomains(string)) {
            if (!this.domains.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(Account account) {
        Reject.ifNull(account, "Account");
        return this.oid.equals(account.getOrganizationOID());
    }

    public void addNotesWithDate(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Object object = Format.formatDateCanonical(new Date());
        object = (String)object + ": ";
        object = (String)object + string;
        Object object2 = StringUtils.isBlank(this.notes) ? object : this.notes + "\n" + (String)object;
        this.setNotes((String)object2);
    }

    public static List<String> prepareDomains(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isBlank(string)) {
            return arrayList;
        }
        if (StringUtils.countChar(string, '.') > 1) {
            arrayList.add(string);
            while (StringUtils.countChar(string, '.') > 1) {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                String string3 = string.replace(string2, "");
                arrayList.add(string2);
                string = string.replaceFirst(string3, "");
            }
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    public CustomFields getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new CustomFields();
        }
        return this.customFields;
    }

    public boolean hasBranding() {
        return StringUtils.isNotBlank(this.color1);
    }

    public void setColor1(String string) {
        this.color1 = string;
    }

    public void setColor2(String string) {
        this.color2 = string;
    }

    public void setColor3(String string) {
        this.color3 = string;
    }

    public String getColor1() {
        return this.color1;
    }

    public String getColor2() {
        return this.color2;
    }

    public String getColor3() {
        return this.color3;
    }

    public synchronized void convertCollections() {
        if (!(this.domains instanceof CopyOnWriteArrayList)) {
            this.domains = new CopyOnWriteArrayList<String>(this.domains);
        }
    }

    public String toString() {
        return "Organization [oid=" + this.oid + ", name=" + this.name + ", maxUsers=" + this.maxUsers + ", osSubscription=" + this.osSubscription + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Organization organization = (Organization)object;
        return Objects.equals(this.oid, organization.oid);
    }

    public int hashCode() {
        return Objects.hash(this.oid);
    }

    @Override
    public void setCreatedNowBy(Account account) {
        this.auditFields().setCreatedNowBy(account);
    }

    @Override
    public void setModifiedNowBy(Account account) {
        this.auditFields().setModifiedNowBy(account);
    }

    private AuditFields auditFields() {
        if (this.auditFields == null) {
            this.auditFields = new AuditFields();
        }
        return this.auditFields;
    }
}

