/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.GroupInfo;
import de.dal33t.powerfolder.protocol.GroupInfoProto;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.AuditFields;
import de.dal33t.powerfolder.security.Auditable;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.security.ComputersAppPermission;
import de.dal33t.powerfolder.security.ConfigAppPermission;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.GroupAdminPermission;
import de.dal33t.powerfolder.security.OrganizationAdminPermission;
import de.dal33t.powerfolder.security.OrganizationCreatePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SingletonPermission;
import de.dal33t.powerfolder.security.SystemSettingsPermission;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Type;

@Entity(name="AGroup")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Group
implements Serializable,
D2DObject,
Auditable {
    public static final String PROPERTYNAME_OID = "oid";
    public static final String PROPERTYNAME_GROUPNAME = "name";
    public static final String PROPERTYNAME_NOTES = "notes";
    public static final String PROPERTYNAME_PERMISSIONS = "permissions";
    public static final String PROPERTYNAME_ORGANIZATION_ID = "organizationOID";
    public static final String PROPERTYNAME_LDAPDN = "ldapDN";
    private static final long serialVersionUID = 100L;
    private static final Logger LOG = Logger.getLogger(Group.class.getName());
    @Id
    private String oid;
    @Index(name="IDX_GROUP_NAME")
    @Column(nullable=false)
    private String name;
    @Index(name="IDX_GROUP_LDAPDN")
    @Column(length=512)
    private String ldapDN;
    @Column(length=2048)
    private String notes;
    @Index(name="IDX_GRP_ORG_ID")
    @Column(nullable=true, unique=false)
    private String organizationOID;
    @CollectionOfElements
    @Type(type="permissionType")
    @Cache(usage=CacheConcurrencyStrategy.NONE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Collection<Permission> permissions;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    public AuditFields auditFields = new AuditFields();

    public Group() {
    }

    public Group(String string) {
        this(IdGenerator.makeId(), string);
    }

    public Group(String string, String string2) {
        Reject.ifBlank(string, "OID");
        this.oid = string;
        this.name = string2;
        this.permissions = new CopyOnWriteArrayList<Permission>();
    }

    public Group(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public void grant(Permission ... permissionArray) {
        Reject.ifNull(permissionArray, "Permission is null");
        for (Permission permission : permissionArray) {
            if (this.hasPermission(permission)) continue;
            this.permissions.add(permission);
        }
    }

    public void revoke(Permission ... permissionArray) {
        Reject.ifNull(permissionArray, "Permission is null");
        for (Permission permission : permissionArray) {
            if (!this.permissions.remove(permission)) continue;
            LOG.fine("Revoked permission from " + this + ": " + permission);
        }
    }

    public void revokeAllFolderPermissions(FolderInfo folderInfo) {
        this.revoke(FolderPermission.read(folderInfo), FolderPermission.readWrite(folderInfo), FolderPermission.admin(folderInfo));
    }

    public void revokeAllGroupAdminPermissions() {
        for (Permission permission : this.permissions) {
            if (!(permission instanceof GroupAdminPermission)) continue;
            this.permissions.remove(permission);
        }
    }

    public void revokeAllOrgAdminPermissions() {
        for (Permission permission : this.permissions) {
            if (!(permission instanceof OrganizationAdminPermission)) continue;
            this.permissions.remove(permission);
        }
    }

    public boolean hasPermission(Permission permission) {
        Reject.ifNull(permission, "Permission is null");
        if (this.permissions == null) {
            LOG.severe("Illegal group " + this.name + ", permissions is null");
            return false;
        }
        for (Permission permission2 : this.permissions) {
            if (permission2 == null) {
                LOG.severe("Got null permission on " + this);
                continue;
            }
            if (permission2.equals(permission)) {
                return true;
            }
            if (!permission2.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public Collection<Permission> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions);
    }

    public FolderPermission getPermissionFor(FolderInfo folderInfo) {
        for (Permission permission : this.permissions) {
            FolderPermission folderPermission;
            if (!(permission instanceof FolderPermission) || !(folderPermission = (FolderPermission)permission).getFolder().equals(folderInfo)) continue;
            return folderPermission;
        }
        return FolderPermission.get(folderInfo, AccessMode.NO_ACCESS);
    }

    public Collection<FolderInfo> getFolders() {
        ArrayList<FolderInfo> arrayList = new ArrayList<FolderInfo>(this.permissions.size());
        for (Permission permission : this.permissions) {
            if (!(permission instanceof FolderPermission)) continue;
            FolderPermission folderPermission = (FolderPermission)permission;
            arrayList.add(folderPermission.getFolder());
        }
        return arrayList;
    }

    public Collection<OrganizationAdminPermission> getOrgAdminPermissions() {
        ArrayList<OrganizationAdminPermission> arrayList = new ArrayList<OrganizationAdminPermission>();
        for (Permission permission : this.permissions) {
            if (!(permission instanceof OrganizationAdminPermission)) continue;
            arrayList.add((OrganizationAdminPermission)permission);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getOID() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setLdapDN(String string) {
        this.ldapDN = string;
    }

    public String getLdapDN() {
        return this.ldapDN;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = StringUtils.cutNotes(string);
    }

    public void addNotesWithDate(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Object object = Format.formatDateCanonical(new Date());
        object = (String)object + ": ";
        object = (String)object + string;
        Object object2 = StringUtils.isBlank(this.notes) ? object : this.notes + "\n" + (String)object;
        this.setNotes((String)object2);
    }

    public String getOrganizationOID() {
        return this.organizationOID;
    }

    public void setOrganizationOID(String string) {
        this.organizationOID = string;
    }

    public GroupInfo createInfo() {
        return new GroupInfo(this.oid, this.name);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Group)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.oid.equals(((Group)object).oid);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.oid == null ? 0 : this.oid.hashCode());
        return n;
    }

    public synchronized void convertCollections() {
        if (!(this.permissions instanceof CopyOnWriteArrayList)) {
            CopyOnWriteArrayList<Permission> copyOnWriteArrayList = new CopyOnWriteArrayList<Permission>(this.permissions);
            this.permissions = copyOnWriteArrayList;
        }
    }

    public String toString() {
        return "Group [name=" + this.name + ", organizationOID=" + this.organizationOID + "]";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof GroupInfoProto.GroupInfo) {
            GroupInfoProto.GroupInfo groupInfo = (GroupInfoProto.GroupInfo)abstractMessage;
            this.oid = groupInfo.getId();
            this.name = groupInfo.getName();
            this.organizationOID = groupInfo.getOrganizationId();
            this.permissions = new CopyOnWriteArrayList<Permission>();
            for (PermissionInfoProto.PermissionInfo permissionInfo : groupInfo.getPermissionInfosList()) {
                switch (permissionInfo.getPermissionType()) {
                    case ADMIN: {
                        this.permissions.add(new AdminPermission(permissionInfo));
                        break;
                    }
                    case CHANGE_PREFERENCES: {
                        this.permissions.add(new ChangePreferencesPermission(permissionInfo));
                        break;
                    }
                    case CHANGE_TRANSFER_MODE: {
                        this.permissions.add(new ChangeTransferModePermission(permissionInfo));
                        break;
                    }
                    case COMPUTERS_APP: {
                        this.permissions.add(new ComputersAppPermission(permissionInfo));
                        break;
                    }
                    case CONFIG_APP: {
                        this.permissions.add(new ConfigAppPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_ADMIN: {
                        this.permissions.add(new FolderAdminPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_CREATE: {
                        this.permissions.add(new FolderCreatePermission(permissionInfo));
                        break;
                    }
                    case FOLDER_OWNER: {
                        this.permissions.add(new FolderOwnerPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_READ: {
                        this.permissions.add(new FolderReadPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_READ_WRITE: {
                        this.permissions.add(new FolderReadWritePermission(permissionInfo));
                        break;
                    }
                    case FOLDER_REMOVE: {
                        this.permissions.add(new FolderRemovePermission(permissionInfo));
                        break;
                    }
                    case GROUP_ADMIN: {
                        this.permissions.add(new GroupAdminPermission(permissionInfo));
                        break;
                    }
                    case ORGANIZATION_ADMIN: {
                        this.permissions.add(new OrganizationAdminPermission(permissionInfo));
                        break;
                    }
                    case ORGANIZATION_CREATE: {
                        this.permissions.add(new OrganizationCreatePermission(permissionInfo));
                        break;
                    }
                    case SYSTEM_SETTINGS: {
                        this.permissions.add(new SystemSettingsPermission(permissionInfo));
                        break;
                    }
                    case UNRECOGNIZED: {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        GroupInfoProto.GroupInfo.Builder builder = GroupInfoProto.GroupInfo.newBuilder();
        builder.setClazzName("GroupInfo");
        if (this.oid != null) {
            builder.setId(this.oid);
        }
        if (this.getDisplayName() != null) {
            builder.setName(this.getDisplayName());
        }
        if (this.organizationOID != null) {
            builder.setOrganizationId(this.organizationOID);
        }
        for (Permission permission : this.permissions) {
            if (permission instanceof FolderPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((FolderPermission)permission).toD2D());
                continue;
            }
            if (permission instanceof GroupAdminPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((GroupAdminPermission)permission).toD2D());
                continue;
            }
            if (permission instanceof OrganizationAdminPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((OrganizationAdminPermission)permission).toD2D());
                continue;
            }
            if (!(permission instanceof SingletonPermission)) continue;
            builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((SingletonPermission)permission).toD2D());
        }
        return builder.build();
    }

    @Override
    public void setCreatedNowBy(Account account) {
        this.auditFields().setCreatedNowBy(account);
    }

    @Override
    public void setModifiedNowBy(Account account) {
        this.auditFields().setModifiedNowBy(account);
    }

    private AuditFields auditFields() {
        if (this.auditFields == null) {
            this.auditFields = new AuditFields();
        }
        return this.auditFields;
    }
}

