/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.D;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.ConfigurationProEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.event.InvitationHandler;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.plugin.AbstractPFPlugin;
import de.dal33t.powerfolder.pro.D.A;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.preferences.PreferencesDialog;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.PropertiesUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.update.Updater;
import de.dal33t.powerfolder.util.update.UpdaterEvent;
import de.dal33t.powerfolder.util.update.UpdaterHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.tanukisoftware.wrapper.WrapperManager;

public class B
extends AbstractPFPlugin {
    private static final String i = "system.service.migrated.4.0.4";
    private static final String g = "wrapper.java.command";
    private static final String e = "wrapper.java.classpath.2";
    private static final String f = "wrapper.ntservice.name";
    private static final String X = "wrapper.ntservice.displayname";
    private static final String _ = "wrapper.ntservice.description";
    private static final String b = "wrapper.java.additional.";
    private static final String Z = "wrapper.java.maxmemory";
    private static String d = "";
    private boolean c;
    private boolean Y;
    private boolean a;

    public B(Controller controller) {
        super(controller);
    }

    public static B C(Controller controller) {
        return (B)B.findPluginByClass(controller, B.class);
    }

    public static boolean M() {
        return OSUtil.isWindowsSystem() && !OSUtil.isWebStart() && !OSUtil.isJETRuntime();
    }

    @Override
    public String getName() {
        return Translation.get("exp.system_service.name");
    }

    @Override
    public String getDescription() {
        return Translation.get("exp.system_service.description");
    }

    @Override
    public void init() {
        if (!B.M()) {
            this.logWarning("System service not supported on this platform");
            return;
        }
        if (!this.isEnabled()) {
            this.getController().getPreferences().putBoolean(i, true);
            return;
        }
        if (B.J()) {
            this.logInfo("Running as system service");
            this.V();
            Feature.FILEBROWSER_INTEGRATION.disable();
            return;
        }
        this.T();
        if (this.c) {
            this.K();
        }
        if (!this.getController().getPreferences().getBoolean(i, false)) {
            this.logWarning("New system service plugin state. Enabled? " + this.Y);
            this.getPluginManager().setEnabled(this, this.Y);
            this.getController().getPreferences().putBoolean(i, true);
        }
    }

    @Override
    public void start() {
        if (!B.M()) {
            this.getController().getPluginManager().setEnabled(this, false);
            if (this.getController().isUIOpen()) {
                DialogFactory.genericDialog(this.getController(), Translation.get("exp.systemservice.unsupported.title"), Translation.get("exp.systemservice.unsupported.message"), GenericDialogType.WARN);
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        if (!B.M()) {
            return;
        }
        if (B.J()) {
            return;
        }
        if (this.isEnabled()) {
            this.T();
            if (!this.Y) {
                this.S();
            }
            if (this.Y) {
                this.W();
                this.L();
            }
        } else if (this.Y) {
            this.O();
        }
    }

    @Override
    public boolean hasOptionsDialog() {
        return true;
    }

    @Override
    public void showOptionsDialog(PreferencesDialog preferencesDialog) {
        if (!B.M()) {
            this.getController().getPluginManager().setEnabled(this, false);
        } else {
            new A(this.getController(), preferencesDialog.getDialog()).\u00fd();
        }
    }

    public boolean S() {
        if (this.G("InstallService.bat")) {
            this.W();
            try {
                if (WinUtils.isSupported()) {
                    WinUtils.getInstance().setPFStartup(false, this.getController());
                }
            }
            catch (Exception exception) {
                this.logSevere("Unable to remove PowerFolder from autostart: " + exception.getMessage());
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            this.T();
            this.c = true;
            if (!this.Y) {
                this.logSevere("Failed to install system service");
                return false;
            }
            return true;
        }
        return false;
    }

    public void O() {
        this.G("UninstallService.bat");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        this.T();
    }

    private void L() {
        this.logInfo("Starting system service");
        this.G("StartService.bat");
    }

    private void K() {
        this.logInfo("Stopping system service");
        try {
            this.F("StopService.bat");
        }
        catch (IOException iOException) {
            this.logSevere("Unable to stop the system service", iOException);
        }
    }

    private void T() {
        int n = this.R();
        this.logFine("System service query result: " + n);
        this.c = (n & 2) == 2;
        this.Y = (n & 1) == 1;
    }

    private int R() {
        try {
            return this.F("wrapper.exe -qs");
        }
        catch (IOException iOException) {
            this.logSevere("Unable to execute the system service script: " + B.N().toAbsolutePath() + "/wrapper.exe -qs", iOException);
            return -1;
        }
    }

    private final int F(String string) throws IOException {
        try {
            this.P();
        }
        catch (IOException iOException) {
            this.logSevere("Unable to install/overwrite the required system service files. Please run as Administrator: " + iOException.getMessage());
        }
        String string2 = B.N().toAbsolutePath().resolve(string).toAbsolutePath().toString();
        final Process process = Runtime.getRuntime().exec(string2);
        try {
            this.getController().schedule(new Runnable(){

                @Override
                public void run() {
                    process.destroy();
                }
            }, 5000L);
            return process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.logFiner(interruptedException);
            return -1;
        }
    }

    private boolean G(String string) {
        try {
            this.P();
        }
        catch (IOException iOException) {
            this.logSevere("Unable to install/overwrite the required system service files. Please run as Administrator: " + iOException.getMessage());
        }
        try {
            Path path = B.N().resolve(string);
            if (Files.notExists(path, new LinkOption[0])) {
                throw new IOException("Script file not exist: " + path.toAbsolutePath());
            }
            Runtime.getRuntime().exec(path.toAbsolutePath().toString());
            return true;
        }
        catch (IOException iOException) {
            this.logSevere("Unable to execute the system service script: " + string, iOException);
            return false;
        }
    }

    private void W() {
        Reject.ifBlank(WinUtils.getAppDataAllUsers(), "Unable to retrieve app data (all users) directory. WinUtils: " + WinUtils.getInstance());
        Path path = Paths.get(WinUtils.getAppDataAllUsers(), d);
        Path path2 = Controller.getMiscFilesLocation();
        if (!path2.equals(path)) {
            this.A(path2, path);
        } else {
            this.logInfo("Not copying misc dir. Same directory: " + path2);
        }
        Path path3 = this.getController().getConfigFile();
        Path path4 = path.resolve(this.getController().getConfigFilename());
        if (!path3.equals(path4)) {
            try {
                PathUtils.copyFile(path3, path4);
                this.logInfo("Copied config file from " + path3 + " to " + path4);
            }
            catch (IOException iOException) {
                this.logSevere("Unable to copy config file to system service. From: " + path3 + " To: " + path4);
            }
        } else {
            this.logInfo("Not copying config. Same directory: " + path3);
        }
        Path path5 = this.getController().getConfigFolderFile();
        Path path6 = path.resolve(this.getController().getConfigFilename().replace(".config", "-Folder.config"));
        if (path5 != null && Files.exists(path5, new LinkOption[0]) && !path5.equals(path6)) {
            try {
                PathUtils.copyFile(path5, path6);
                this.logInfo("Copied config file from " + path5 + " to " + path6);
            }
            catch (IOException iOException) {
                this.logSevere("Unable to copy config file to system service. From: " + path5 + " To: " + path6);
            }
        } else {
            this.logInfo("Not copying config. Same directory: " + path5);
        }
    }

    private Path A(Path path, boolean bl) {
        if (Files.notExists(path, new LinkOption[0])) {
            this.logSevere("Source file does not exists: " + path);
            return null;
        }
        Path path2 = B.N().resolve(this.getController().getJARName());
        try {
            if (Files.exists(path2, new LinkOption[0]) && Files.size(path) == Files.size(path2)) {
                return path2;
            }
        }
        catch (IOException iOException) {
            this.logWarning("Unable to get the size of source jar '" + path.toAbsolutePath() + "' and target jar '" + path2.toAbsolutePath() + "'. " + iOException);
            return null;
        }
        int n = 0;
        while (true) {
            try {
                this.logInfo("Source jar: " + path.toAbsolutePath() + ". modified: " + new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) + " size: " + Files.size(path));
                if (Files.exists(path2, new LinkOption[0])) {
                    this.logInfo("Target jar: " + path2.toAbsolutePath() + ". modified: " + new Date(Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis()) + " size: " + Files.size(path2));
                }
                PathUtils.copyFile(path, path2);
                return path2;
            }
            catch (IOException iOException) {
                if (n > 100 || bl) {
                    this.logSevere("Uable to copy jar file to " + path2);
                    return null;
                }
                String string = this.getController().getJARName().replace(".", "-" + ++n + ".");
                path2 = B.N().resolve(string);
                continue;
            }
            break;
        }
    }

    private void A(Path path, Path path2) {
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            this.logSevere("Unable to create directory: " + path2.toAbsolutePath() + ". " + iOException);
            return;
        }
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) {
            this.logSevere("Unable to copy misc dir. Directory not created: " + path2.toAbsolutePath());
            return;
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            public boolean A(Path path) {
                return Files.isRegularFile(path, new LinkOption[0]);
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            int n = 0;
            int n2 = 0;
            for (Path path3 : directoryStream) {
                ++n2;
                Path path4 = path2.resolve(path3.getFileName());
                try {
                    PathUtils.copyFile(path3, path4);
                    ++n;
                }
                catch (IOException iOException) {
                    this.logFine("Unable to copy misc file from " + path3.toAbsolutePath() + " to " + path4.toAbsolutePath() + ". " + iOException);
                    this.logFiner(iOException);
                }
            }
            if (n == 0) {
                this.logWarning("Unable to copy " + n2 + " misc files from " + path.toAbsolutePath() + " to " + path2.toAbsolutePath());
            } else {
                this.logInfo("Copied " + n2 + " misc files from " + path + " to " + path2.toAbsolutePath());
            }
        }
        catch (IOException iOException) {
            this.logWarning("Unable to read directory: " + path.toAbsolutePath());
        }
    }

    private synchronized void P() throws IOException {
        if (this.a) {
            return;
        }
        Files.createDirectories(B.N(), new FileAttribute[0]);
        if (Files.notExists(B.N(), new LinkOption[0])) {
            this.logSevere("Unable to create service base dir: " + B.N());
            return;
        }
        this.E("InstallService.bat");
        this.E("UninstallService.bat");
        this.E("StartService.bat");
        this.E("StopService.bat");
        this.E("StartConsole.bat");
        this.C("wrapper.conf");
        String string = OSUtil.is64BitPlatform() ? "win64/" : "win32/";
        this.C(string + "wrapper.dll", "wrapper.dll");
        this.C(string + "wrapper.exe", "wrapper.exe");
        this.C(string + "wrapper.jar", "wrapper.jar");
        Path path = Paths.get(this.getController().getJARName(), new String[0]);
        Path path2 = this.A(path, true);
        this.D(path2 != null ? path2.getFileName().toString() : null);
        this.a = true;
    }

    private void C(String string) throws IOException {
        Path path = B.N().resolve(string);
        if (Files.notExists(path, new LinkOption[0])) {
            this.E(string);
            return;
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("service/" + string);
        if (uRL == null) {
            this.logSevere("Cannot locate 'wrapper.conf' in bundle. SystemService cannot be started.");
            return;
        }
        String string2 = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        int n = string2.indexOf(Z);
        int n2 = string2.indexOf(10, n += Z.length() + 1);
        String string3 = string2.substring(n, n2);
        URLConnection uRLConnection = uRL.openConnection();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
             OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.WRITE);){
            Object object;
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith(Z)) {
                    object = "wrapper.java.maxmemory=" + string3;
                }
                object = (String)object + "\n";
                outputStream.write(((String)object).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private void E(String string) throws IOException {
        this.C(string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void C(String string, String string2) throws IOException {
        boolean bl;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("service/" + string);
        URLConnection uRLConnection = uRL.openConnection();
        long l = uRLConnection.getLastModified();
        int n = uRLConnection.getContentLength();
        Path path = B.N().resolve(string2);
        boolean bl2 = bl = Files.notExists(path, new LinkOption[0]) || Files.size(path) != (long)n || !DateUtil.equalsFileDateCrossPlattform(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis(), l);
        if (!bl) {
            this.logFiner("File doesn't require an update: " + string2);
            return;
        }
        try (InputStream inputStream = uRLConnection.getInputStream();
             OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.logFine("Installing file: " + string + " to " + path);
            StreamUtils.copyToStream(inputStream, outputStream);
        }
        finally {
            if (Files.exists(path, new LinkOption[0])) {
                Files.setLastModifiedTime(path, FileTime.fromMillis(l));
            }
        }
    }

    public static Path N() {
        Object object = WinUtils.getAppDataAllUsers();
        Reject.ifBlank((String)object, "Unable to retrieve system service target directory. WinUtils: " + WinUtils.getInstance());
        object = (String)object + "/";
        object = (String)object + d;
        object = (String)object + "/service";
        return Paths.get((String)object, new String[0]);
    }

    private static boolean J() {
        return WrapperManager.isLaunchedAsService();
    }

    private void V() {
        try {
            ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.setValue(this.getController(), 0);
            ConfigurationEntry.UPLOAD_AUTO_CLEANUP_FREQUENCY.setValue(this.getController(), 0);
            if (!this.getController().getMySelf().isServer()) {
                Updater.installPeriodicalUpdateCheck(this.getController(), new _A());
            }
            this.getController().addInvitationHandler(new _B());
        }
        catch (NullPointerException nullPointerException) {
            this.logWarning("Unable to setup auto-update mechanism", nullPointerException);
        }
    }

    private boolean B(Path path) {
        Path path2 = WinUtils.getProgramInstallationPath(this.getController());
        if (path2 == null) {
            return false;
        }
        Path path3 = path2.resolve(this.getController().getJARName());
        try {
            if (Files.size(path) == Files.size(path3)) {
                this.logFine("No need to update Windows installation jar. Is already up to date: " + path3);
                return false;
            }
        }
        catch (IOException iOException) {
            this.logSevere("Unable to retrieve the file size of " + path + " or " + path3 + ". " + iOException, iOException);
            return false;
        }
        if (Files.notExists(path3, new LinkOption[0])) {
            this.logSevere("Unable to update Windows installation of PowerFolder. Jar file not found: " + path3);
            return false;
        }
        try {
            PathUtils.copyFile(path, path3);
            this.logInfo("Updated Windows installation jar: " + path3);
            return true;
        }
        catch (IOException iOException) {
            this.logSevere("Unable to update Windows installation of PowerFolder. Copy failed from " + path + " to " + path3 + ". " + iOException, iOException);
            return false;
        }
    }

    private void D(String string) {
        Properties properties = this.U();
        Reject.ifNull(properties, "Unable to modify wrapper.conf. File not found: " + B.Q());
        Path path = B.N().resolve("wrapper.conf.backup");
        try {
            PathUtils.copyFile(B.Q(), path);
        }
        catch (IOException iOException) {
            this.logSevere("Unable to create backup for wrapper.conf: " + path);
        }
        try {
            String string2;
            Object object2;
            Path path2 = WinUtils.getProgramInstallationPath(this.getController()).resolve("jre/bin/java.exe");
            if (Files.exists(path2, new LinkOption[0])) {
                properties.put(g, path2.toAbsolutePath().toString().replace(".exe", "").replace("\\", "/"));
            }
            if (this.getController().getDistribution() != null) {
                object2 = this.getController().getDistribution().getName();
                Iterator<String> iterator = this.getController().getDistribution().getBinaryName();
                properties.put(f, iterator);
                properties.put(X, object2);
                properties.put(_, (String)object2 + " System Service");
            }
            if (StringUtils.isNotBlank(string)) {
                properties.put(e, string);
            }
            object2 = new TreeSet();
            for (String object3 : properties.stringPropertyNames()) {
                if (!object3.startsWith(b)) continue;
                if (!object3.startsWith("-Dpf.")) {
                    object2.add(properties.getProperty(object3));
                }
                properties.remove(object3);
            }
            this.logFine("Extracted add props: " + (Set)object2);
            for (String string3 : System.getProperties().stringPropertyNames()) {
                if (!string3.startsWith("pf.")) continue;
                string2 = System.getProperty(string3);
                this.logFine("Adding add prop: " + string3 + " = " + string2);
                object2.add("-D" + string3 + "=" + string2);
            }
            int n = 1;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                properties.put(b + n, string2);
                ++n;
            }
            PropertiesUtil.saveConfig(B.Q(), properties, "System Service wrapper config file");
        }
        catch (Exception exception) {
            this.logSevere("Unable to modify wrapper config: " + B.Q());
        }
    }

    private Properties U() {
        Properties properties;
        block9: {
            Path path = B.Q();
            if (Files.notExists(path, new LinkOption[0])) {
                this.logWarning("Unable to modify wrapper.conf. File not existing: " + path);
                return null;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                properties = properties2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    this.logSevere("Unable to load wrapper config file: " + path + ". " + exception, exception);
                    return null;
                }
            }
            inputStream.close();
        }
        return properties;
    }

    private static Path Q() {
        return B.N().resolve("wrapper.conf");
    }

    static {
        try {
            Properties properties = ConfigurationLoader.loadPreConfigFromClasspath("Default.config");
            d = properties != null && properties.containsKey("dist.name") ? properties.getProperty("dist.name") : ConfigurationEntry.DIST_NAME.getDefaultValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class _A
    implements UpdaterHandler {
        private _A() {
        }

        @Override
        public void newReleaseAvailable(UpdaterEvent updaterEvent) {
            URL uRL = updaterEvent.getNewWindowsExeURL();
            if (uRL == null) {
                return;
            }
            try {
                String string = uRL.toExternalForm();
                int n = string.lastIndexOf(47);
                String string2 = string.subSequence(0, n + 1) + "PowerFolder.jar";
                URL uRL2 = new URL(string2);
                B.this.logWarning("New update available: " + uRL2 + ". Triggered auto update.");
                Path path = updaterEvent.getUpdater().download(uRL2, null);
                if (path == null) {
                    string2 = string.subSequence(0, n + 1) + "webstart/PowerFolder.jar";
                    uRL2 = new URL(string2);
                    path = updaterEvent.getUpdater().download(uRL2, null);
                }
                if (path == null) {
                    B.this.logSevere("Unable to download release jar file from " + uRL2);
                    return;
                }
                B.this.logWarning("Source jar: " + path);
                Path path2 = B.this.A(path, false);
                if (path2 == null) {
                    return;
                }
                B.this.D(path2.getFileName().toString());
                if (OSUtil.isWindowsSystem()) {
                    B.this.B(path2);
                }
                WrapperManager.restart();
            }
            catch (Exception exception) {
                B.this.logSevere("Error while auto updating system service. " + exception, exception);
            }
        }

        @Override
        public void noNewReleaseAvailable(UpdaterEvent updaterEvent) {
        }

        @Override
        public boolean shouldCheckForNewVersion() {
            return ConfigurationProEntry.SYSTEM_SERVICE_AUTO_UPDATE.getValueBoolean(B.this.getController());
        }
    }

    private class _B
    implements InvitationHandler {
        private _B() {
        }

        @Override
        public void gotInvitation(Invitation invitation) {
            if (ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.getValueBoolean(B.this.getController()).booleanValue()) {
                B.this.logWarning("Unable to auto accept invite");
            }
        }
    }
}

