/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.C;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderListener;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.FolderRepositoryListener;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.plugin.AbstractPFPlugin;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Translation;
import java.nio.file.Path;
import java.util.Collection;

public class A
extends AbstractPFPlugin {
    public static final String U = "Filelist.csv";
    private FolderRepositoryListener W = new _A();
    private FolderListener V = new _B();

    public A(Controller controller) {
        super(controller);
    }

    public static A B(Controller controller) {
        return (A)A.findPluginByClass(controller, A.class);
    }

    @Override
    public String getName() {
        return Translation.get("filelist_writer.name");
    }

    @Override
    public String getDescription() {
        return Translation.get("filelist_writer.description");
    }

    @Override
    public void start() {
        this.getController().getFolderRepository().addFolderRepositoryListener(this.W);
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders();
        for (Folder folder : collection) {
            folder.addFolderListener(this.V);
        }
    }

    @Override
    public void stop() {
        this.getController().getFolderRepository().removeFolderRepositoryListener(this.W);
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders();
        for (Folder folder : collection) {
            folder.removeFolderListener(this.V);
        }
    }

    private boolean A(Folder folder) {
        this.logFine("Writing filelist for folder " + folder);
        Collection<FileInfo> collection = folder.getKnownFiles();
        String string = "Filelist of folder '" + folder.getName() + "'. Sorted by change time - newest files ontop.";
        Path path = folder.getLocalBase().resolve(U);
        return Debug.writeFileListCSV(path, collection, string) != null;
    }

    private final class _A
    extends FolderRepositoryAdapter {
        private _A() {
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getFolder().addFolderListener(A.this.V);
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getFolder().removeFolderListener(A.this.V);
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            folderRepositoryEvent.getOldFolder().removeFolderListener(A.this.V);
            folderRepositoryEvent.getFolder().addFolderListener(A.this.V);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class _B
    extends FolderAdapter {
        private _B() {
        }

        private boolean A(FileInfo fileInfo) {
            return fileInfo.getRelativeName().endsWith(A.U);
        }

        @Override
        public void scanResultCommitted(FolderEvent folderEvent) {
            if (!folderEvent.getScanResult().isChangeDetected()) {
                return;
            }
            if (folderEvent.getScanResult().getChangedFiles().size() + folderEvent.getScanResult().getNewFiles().size() == 1) {
                if (folderEvent.getScanResult().getChangedFiles().size() == 1 && this.A(folderEvent.getScanResult().getChangedFiles().iterator().next())) {
                    A.this.logFine("Ignoring change caused by filelist csv change");
                    return;
                }
                if (folderEvent.getScanResult().getNewFiles().size() == 1 && this.A(folderEvent.getScanResult().getNewFiles().iterator().next())) {
                    A.this.logFine("Ignoring new caused by filelist csv change");
                    return;
                }
            }
            A.this.A(folderEvent.getFolder());
        }

        @Override
        public void fileChanged(FolderEvent folderEvent) {
            A.this.A(folderEvent.getFolder());
        }

        @Override
        public void filesDeleted(FolderEvent folderEvent) {
            A.this.A(folderEvent.getFolder());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

