/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.ConnectResult;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.AddFriendNotification;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.KnownNodes;
import de.dal33t.powerfolder.message.KnownNodesExt;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.MessageListener;
import de.dal33t.powerfolder.message.MessageProducer;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.message.RequestNodeList;
import de.dal33t.powerfolder.message.SearchNodeRequest;
import de.dal33t.powerfolder.message.SingleMessageProducer;
import de.dal33t.powerfolder.message.TransferStatus;
import de.dal33t.powerfolder.net.AbstractAcceptor;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.NodeFilter;
import de.dal33t.powerfolder.net.NodeList;
import de.dal33t.powerfolder.net.ReconnectManager;
import de.dal33t.powerfolder.task.RemoveComputerFromAccountTask;
import de.dal33t.powerfolder.task.SendMessageTask;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Filter;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.MessageListenerSupport;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.intern.MemberInfoInternalizer;
import de.dal33t.powerfolder.util.net.AddressRange;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeManager
extends PFComponent {
    private static final Logger log = Logger.getLogger(NodeManager.class.getName());
    List<AbstractAcceptor> acceptors;
    private Object acceptLock = new Object();
    private Map<String, Member> knownNodes;
    private Map<String, Member> friends;
    private Map<String, Member> connectedNodes;
    private List<AddressRange> lanRanges;
    private Member mySelf;
    private Set<MemberInfo> nodesWentOnline;
    private MessageListenerSupport valveMessageListenerSupport;
    private boolean started = false;
    private boolean nodefileLoaded = false;
    private NodeManagerListener listenerSupport;
    private List<NodeFilter> nodeFilters;

    public NodeManager(Controller controller) {
        super(controller);
        String[] stringArray;
        String string;
        String string2;
        String string3 = ConfigurationEntry.NICK.getValue(this.getController());
        if (controller.getCommandLine() != null && controller.getCommandLine().hasOption("n")) {
            string3 = controller.getCommandLine().getOptionValue("n");
        }
        if (StringUtils.isBlank(string2 = ConfigurationEntry.NODE_ID.getValue(this.getController()))) {
            string2 = IdGenerator.makeId();
            this.logInfo("Generated new ID for '" + string3 + "': " + string2);
            ConfigurationEntry.NODE_ID.setValue(this.getController(), string2);
        }
        if (StringUtils.isBlank(string = ConfigurationEntry.NETWORK_ID.getValue(this.getController()))) {
            string = ConfigurationEntry.NETWORK_ID.getDefaultValue();
        }
        this.mySelf = new Member(this.getController(), new MemberInfo(string3, string2, string));
        this.logInfo("I am '" + this.mySelf.getNick() + "'");
        this.knownNodes = Util.createConcurrentHashMap();
        this.friends = Util.createConcurrentHashMap();
        this.connectedNodes = Util.createConcurrentHashMap();
        this.nodesWentOnline = Collections.synchronizedSet(new HashSet());
        this.acceptors = new CopyOnWriteArrayList<AbstractAcceptor>();
        this.valveMessageListenerSupport = new MessageListenerSupport(this);
        this.listenerSupport = ListenerSupportFactory.createListenerSupport(NodeManagerListener.class);
        this.nodeFilters = new ArrayList<NodeFilter>();
        this.nodeFilters.add(new DefaultNodeFilter());
        this.lanRanges = new LinkedList<AddressRange>();
        for (String string4 : stringArray = ConfigurationEntry.LANLIST.getValue(controller).split(",")) {
            if ((string4 = string4.trim()).length() <= 0) continue;
            try {
                this.lanRanges.add(AddressRange.parseRange(string4));
            }
            catch (ParseException parseException) {
                this.logWarning("Invalid IP range format: " + string4);
            }
        }
    }

    public void init() {
        this.loadNodes();
        this.nodefileLoaded = true;
        if (MemberInfo.INTERNALIZER != null) {
            this.logFine("Overwriting old MemberInfo internalizer: " + MemberInfo.INTERNALIZER);
        }
        MemberInfo.INTERNALIZER = new MemberInfoInternalizer(this);
    }

    public void start() {
        if (!ConfigurationEntry.NODEMANAGER_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.logWarning("Not starting NodeManager. disabled by config");
            return;
        }
        this.setupPeridicalTasks();
        this.started = true;
        this.listenerSupport.startStop(new NodeManagerEvent(this, null));
        this.logFine("Started");
    }

    public void shutdown() {
        this.started = false;
        this.storeOnlineSupernodes();
        this.logFine("Shutting down " + this.acceptors.size() + " incoming connections (Acceptors)");
        for (AbstractAcceptor object2 : this.acceptors) {
            object2.shutdown();
        }
        this.acceptors.clear();
        this.logFine("Shutting down nodes");
        ArrayList<Member> arrayList = new ArrayList<Member>(this.connectedNodes.values());
        this.logFine("Shutting down connected nodes (" + arrayList.size() + ")");
        ExecutorService executorService = Executors.newFixedThreadPool(Math.max(1, arrayList.size() / 5));
        ArrayList arrayList2 = new ArrayList();
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            final Member member = (Member)iterator.next();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    member.shutdown();
                }
            };
            arrayList2.add(executorService.submit(runnable));
        }
        for (Future future : arrayList2) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                this.logFiner("InterruptedException", interruptedException);
                break;
            }
            catch (ExecutionException executionException) {
            }
        }
        executorService.shutdownNow();
        this.logFine("Shutting down " + this.knownNodes.size() + " nodes");
        for (Member member : this.getNodesAsCollection()) {
            member.shutdown();
        }
        if (this.nodefileLoaded) {
            this.storeNodes();
            this.nodefileLoaded = false;
        }
        this.listenerSupport.startStop(new NodeManagerEvent(this, null));
        this.logFine("Stopped");
    }

    public void setSuspendFireEvents(boolean bl) {
        ListenerSupportFactory.setSuspended(this.listenerSupport, bl);
        this.logFine("setSuspendFireEvents: " + bl);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setNetworkId(String string) {
        if (this.getNetworkId().equals(string)) {
            return;
        }
        if ("ANY".equals(string)) {
            this.logFine("Changing network ID to ANY for federation sync");
        }
        ConfigurationEntry.NETWORK_ID.setValue(this.getController(), string);
        this.getController().getMySelf().getInfo().networkId = string;
    }

    public boolean isFriend(Member member) {
        if (member.isMySelf()) {
            return true;
        }
        return this.friends.containsKey(member.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countOnlineNodes() {
        int n = 1;
        Map<String, Member> map = this.knownNodes;
        synchronized (map) {
            for (Member member : this.knownNodes.values()) {
                if (!member.isConnected() && !member.isConnectedToNetwork()) continue;
                ++n;
            }
        }
        return n;
    }

    public int countOnlineSupernodes() {
        int n = 1;
        for (Member member : this.knownNodes.values()) {
            if (!member.isSupernode() || !member.isConnected() && !member.isConnectedToNetwork()) continue;
            ++n;
        }
        return n;
    }

    public int countSupernodes() {
        int n = 0;
        for (Member member : this.knownNodes.values()) {
            if (!member.isSupernode()) continue;
            ++n;
        }
        return n;
    }

    public int countConnectedSupernodes() {
        int n = 0;
        for (Member member : this.connectedNodes.values()) {
            if (!member.isSupernode()) continue;
            ++n;
        }
        return n;
    }

    public boolean maxConnectionsReached() {
        int n;
        if (this.getController().getTransferManager().getUploadCPSForWAN() <= 0L) {
            return false;
        }
        double d = (double)this.getController().getTransferManager().getUploadCPSForWAN() / 1024.0;
        int n2 = this.countConnectedNodes();
        if (n2 > (n = (int)(d * 1.0))) {
            this.logFiner("Not more connection slots open. Used " + n2 + "/" + n);
        }
        return n2 > n;
    }

    @Override
    public Member getMySelf() {
        return this.mySelf;
    }

    public String getNetworkId() {
        return this.mySelf.getInfo().networkId;
    }

    public boolean knowsNode(Member member) {
        if (member == null) {
            return false;
        }
        return this.knowsNode(member.getId());
    }

    private boolean isNodeOnConfiguredLan(InetAddress inetAddress) {
        boolean bl = false;
        try {
            for (InterfaceAddress object : NetworkUtil.getAllLocalNetworkAddressesCached().keySet()) {
                if (!(object.getAddress() instanceof Inet4Address) || !this.isNodeOnConfiguredLan0(object.getAddress())) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to get LAN/Adapter configuration. " + exception);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        for (AddressRange addressRange : this.lanRanges) {
            if (!addressRange.contains((Inet4Address)inetAddress)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeOnConfiguredLan0(InetAddress inetAddress) {
        for (AddressRange addressRange : this.lanRanges) {
            if (!addressRange.contains((Inet4Address)inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnLANorConfiguredOnLAN(InetAddress inetAddress) {
        Reject.ifNull(inetAddress, "Address is null");
        if (!(inetAddress instanceof Inet4Address)) {
            return false;
        }
        if (Feature.CORRECT_LAN_DETECTION.isDisabled()) {
            return true;
        }
        if (Feature.CORRECT_INTERNET_DETECTION.isDisabled()) {
            return false;
        }
        if (NetworkUtil.isNullIP(inetAddress)) {
            return false;
        }
        return NetworkUtil.isOnLanOrLoopback(inetAddress) || this.isNodeOnConfiguredLan(inetAddress) || this.getController().getBroadcastManager() != null && this.getController().getBroadcastManager().receivedBroadcast(inetAddress);
    }

    public boolean knowsNode(MemberInfo memberInfo) {
        if (memberInfo == null) {
            return false;
        }
        return this.knowsNode(memberInfo.id);
    }

    public int countConnectedNodes() {
        return this.connectedNodes.size();
    }

    public Collection<Member> getConnectedNodes() {
        return Collections.unmodifiableCollection(this.connectedNodes.values());
    }

    public boolean knowsNode(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(this.mySelf.getId()) || this.knownNodes.containsKey(string);
    }

    public Member getNode(MemberInfo memberInfo) {
        if (memberInfo == null) {
            return null;
        }
        return this.getNode(memberInfo.id);
    }

    public Member getNode(String string) {
        if (string == null) {
            return null;
        }
        if (this.mySelf.getId().equals(string)) {
            return this.mySelf;
        }
        return this.knownNodes.get(string);
    }

    public Collection<Member> getNodesAsCollection() {
        return Collections.unmodifiableCollection(this.knownNodes.values());
    }

    public void removeNode(Member member) {
        if (this.isFiner()) {
            this.logFiner("Removing " + member.getNick() + " from nodelist");
        }
        if (member.isConnected()) {
            this.logInfo("Disconnecting " + member.getNick());
        }
        member.shutdown();
        this.getController().getFolderRepository().removeFromAllFolders(member);
        this.knownNodes.remove(member.getId());
        member.removeAllListeners();
        this.fireNodeRemoved(member);
        this.logFine(member + " removed from from know nodes list");
    }

    public int countOnlineFriends() {
        int n = 0;
        for (Member member : this.getFriends()) {
            if (!member.isConnectedToNetwork()) continue;
            ++n;
        }
        return n;
    }

    public int countFriends() {
        return this.friends.size();
    }

    public Member[] getFriends() {
        return this.friends.values().toArray(new Member[this.friends.values().size()]);
    }

    public void serverStateChanged(Member member, boolean bl) {
        if (member.isMySelf()) {
            return;
        }
        this.fireNodeSettingsChanged(member);
        if (this.nodefileLoaded) {
            this.storeNodes();
        }
    }

    public void friendStateChanged(Member member, boolean bl, String string) {
        if (member.isMySelf()) {
            return;
        }
        boolean bl2 = member.isFriend();
        boolean bl3 = false;
        if (bl) {
            this.friends.put(member.getId(), member);
            bl3 = true;
            this.fireFriendAdded(member);
            member.markForImmediateConnect();
            if (this.getController().getTaskManager().isStarted() && !this.getMySelf().isServer()) {
                this.getController().getTaskManager().scheduleTask(new SendMessageTask(new AddFriendNotification(this.mySelf.getInfo(), string), member.getId()));
            }
        } else if (bl2) {
            this.friends.remove(member.getId());
            bl3 = true;
            this.fireFriendRemoved(member);
            if (this.getController().getOSClient().isLoggedIn()) {
                this.getController().getTaskManager().scheduleTask(new RemoveComputerFromAccountTask(this.getController().getOSClient().getAccountInfo(), member.getInfo()));
            }
        }
        if (this.nodefileLoaded && bl3) {
            this.storeNodes();
        }
    }

    public void networkConnectionStateChanged(Member member) {
        Reject.ifNull(member, "Node");
        if (member.isConnectedToNetwork()) {
            this.fireNodeOnline(member);
        } else {
            this.fireNodeOffline(member);
        }
    }

    public void connectingStateChanged(Member member) {
        this.fireNodeConnecting(member);
    }

    public void connectStateChanged(Member member) {
        boolean bl = member.isCompletelyConnected();
        if (bl) {
            this.connectedNodes.put(member.getId(), member);
            this.nodesWentOnline.add(member.getInfo());
            if (ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.getValueBoolean(this.getController()).booleanValue() && this.getController().getIOProvider().getRelayedConnectionManager().isRelay(member.getInfo())) {
                this.logFine("Connect to relay detected. Rebuilding reconnection queue");
                this.getController().getReconnectManager().buildReconnectionQueue();
            }
        } else {
            this.connectedNodes.remove(member.getId());
            this.nodesWentOnline.remove(member.getInfo());
            this.getController().getTransferManager().breakTransfers(member);
            Problem problem = member.getLastProblem();
            boolean bl2 = true;
            if (problem != null) {
                boolean bl3 = bl2 = problem.problemCode != 777 && problem.problemCode != 666;
            }
            if (bl2 && member.isInteresting()) {
                this.getController().getReconnectManager().considerReconnectionTo(member);
            }
        }
        if (bl) {
            this.fireNodeConnected(member);
            if (this.isInfo()) {
                this.logInfo(member.getNick() + " connected (" + this.getController().getNodeManager().countConnectedNodes() + " total)");
            }
        } else {
            this.fireNodeDisconnected(member);
            if (this.isInfo()) {
                this.logInfo(member.getNick() + " disconnected (" + this.getController().getNodeManager().countConnectedNodes() + " still connected)");
            }
        }
    }

    public void messageReceived(Member member, Message message) {
        this.valveMessageListenerSupport.fireMessage(member, message);
    }

    public void receivedRequestNodeList(RequestNodeList requestNodeList, Member member) {
        List<MemberInfo> list = requestNodeList.filter(this.knownNodes.values());
        member.sendMessagesAsynchron(KnownNodes.createKnownNodesList(list, member.getProtocolVersion() >= 107));
    }

    public void receivedSearchNodeRequest(final SearchNodeRequest searchNodeRequest, final Member member) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LinkedList<MemberInfo> linkedList = new LinkedList<MemberInfo>();
                for (Member member2 : NodeManager.this.getController().getNodeManager().getNodesAsCollection()) {
                    if (member2.getInfo().isInvalid(NodeManager.this.getController()) || !member2.matches(searchNodeRequest.searchString)) continue;
                    linkedList.add(member2.getInfo());
                }
                if (!linkedList.isEmpty()) {
                    if (member.getProtocolVersion() >= 107) {
                        member.sendMessageAsynchron(new KnownNodesExt(linkedList.toArray(new MemberInfo[linkedList.size()])));
                    } else {
                        member.sendMessageAsynchron(new KnownNodes(linkedList.toArray(new MemberInfo[linkedList.size()])));
                    }
                }
            }
        };
        this.getController().getIOProvider().startIO(runnable);
    }

    public RequestNodeList createDefaultNodeListRequestMessage() {
        if (this.mySelf.isSupernode()) {
            return RequestNodeList.createRequestAllNodes();
        }
        return RequestNodeList.createRequest(this.friends.values(), RequestNodeList.NodesCriteria.ONLINE, RequestNodeList.NodesCriteria.ONLINE);
    }

    public void queueNewNodes(MemberInfo[] memberInfoArray) {
        if (memberInfoArray == null || memberInfoArray.length == 0) {
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Received new list of " + memberInfoArray.length + " nodes");
        }
        int n = 0;
        int n2 = 0;
        ReconnectManager reconnectManager = this.getController().getReconnectManager();
        for (int i = 0; i < memberInfoArray.length; ++i) {
            MemberInfo memberInfo = memberInfoArray[i];
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (memberInfo == null || memberInfo.isInvalid(this.getController())) {
                if (!this.isFiner()) continue;
                this.logFiner("Not adding new node: " + memberInfo);
                continue;
            }
            if (!memberInfo.isOnSameNetwork(this.getController())) continue;
            boolean bl = true;
            for (NodeFilter nodeFilter : this.nodeFilters) {
                if (!nodeFilter.shouldAddNode(memberInfo)) continue;
                bl = false;
                break;
            }
            if (!bl && ServerClient.isTempServerNode(memberInfo)) {
                this.logWarning("Ignoring temporary server node: " + memberInfo);
                bl = true;
            }
            if (bl) continue;
            Object object = this.getNode(memberInfo);
            if (memberInfo.matches(this.mySelf) || this.getController().isLanOnly() && memberInfo.getConnectAddress() != null && memberInfo.getConnectAddress().getAddress() != null && !this.getController().getNodeManager().isOnLANorConfiguredOnLAN(memberInfo.getConnectAddress().getAddress())) continue;
            if (object == null) {
                object = this.addNode(memberInfo);
                ++n;
            } else if (!((Member)object).isServer()) {
                ((Member)object).updateInfo(memberInfo);
            }
            if (!memberInfo.isConnected) continue;
            ((Member)object).setConnectedToNetwork(memberInfo.isConnected);
            boolean bl2 = reconnectManager.considerReconnectionTo((Member)object);
            if (!bl2) continue;
            ++n2;
        }
        if ((n2 > 0 || n > 0) && this.isFiner()) {
            this.logFiner("Queued " + n2 + " new nodes for reconnection, " + n + " added");
        }
    }

    public void acceptConnectionAsynchron(AbstractAcceptor abstractAcceptor) {
        Reject.ifNull(abstractAcceptor, "Acceptor is null");
        if (!this.started) {
            this.logFine("Not accepting connection " + abstractAcceptor + ". NodeManager is not started");
            abstractAcceptor.shutdown();
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Connection queued for acception: " + abstractAcceptor);
        }
        this.acceptors.add(abstractAcceptor);
        this.getController().getIOProvider().startIO(abstractAcceptor);
        long l = 10L * (long)this.acceptors.size();
        if (this.isFiner()) {
            this.logFiner("Currently processing incoming connections (" + this.acceptors.size() + "), throttled (" + l + "ms wait)");
        }
        if (this.acceptors.size() > 100) {
            String string = "Processing many incoming connections (" + this.acceptors.size() + "), throttled (" + l + "ms wait)";
            if (this.acceptors.size() > 300) {
                this.logWarning(string);
            } else {
                this.logFine(string);
            }
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            this.logFiner(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member acceptConnection(ConnectionHandler connectionHandler) throws ConnectionException {
        boolean bl;
        PFComponent pFComponent;
        Reject.ifNull(connectionHandler, "ConnectionHandler");
        if (!this.started) {
            this.logFine("Not accepting node from " + connectionHandler + ". NodeManager is not started");
            connectionHandler.shutdown();
            throw new ConnectionException("Not accepting node from " + connectionHandler + ". NodeManager is not started").with(connectionHandler);
        }
        Identity identity = connectionHandler.getIdentity();
        if (identity == null || !identity.isValid()) {
            this.logWarning("Received an illegal identity from " + connectionHandler + ". disconnecting. " + identity);
            connectionHandler.shutdown();
            throw new ConnectionException("Received an illegal identity from " + connectionHandler + ". disconnecting. " + identity).with(connectionHandler);
        }
        if (this.getMySelf().getInfo().equals(identity.getMemberInfo())) {
            this.logFine("Loopback connection detected to " + connectionHandler + ", disconnecting");
            connectionHandler.shutdown();
            throw new ConnectionException("Loopback connection detected to " + connectionHandler + ", disconnecting").with(connectionHandler);
        }
        if (!identity.getMemberInfo().isOnSameNetwork(this.getController())) {
            if (this.getController().getOSClient().isPrimaryServer(connectionHandler) && !this.mySelf.isServer()) {
                this.logWarning("Server not on same network " + connectionHandler + ", disconnecting. remote network ID: " + identity.getMemberInfo().networkId + ". Expected/Ours: " + this.getNetworkId());
            } else {
                this.logFine("Remote client not on same network " + connectionHandler + ", disconnecting. remote network ID: " + identity.getMemberInfo().networkId + ". Expected/Ours: " + this.getNetworkId());
            }
            connectionHandler.shutdown();
            throw new ConnectionException("Remote client not on same network " + connectionHandler + ", disconnecting. remote network ID: " + identity.getMemberInfo().networkId + ". Expected/Ours: " + this.getNetworkId()).with(connectionHandler);
        }
        if (!this.mySelf.isServer() && Feature.P2P_REQUIRES_LOGIN_AT_SERVER.isEnabled() && !((ServerClient)(pFComponent = this.getController().getOSClient())).isLoggedIn() && !((ServerClient)pFComponent).isPrimaryServer(connectionHandler)) {
            connectionHandler.shutdown();
            this.logFine("Not logged in at server (" + ((ServerClient)pFComponent).getServer().getNick() + ") yet. Disconnecting: " + connectionHandler.getIdentity());
            throw new ConnectionException("Not logged in at server (" + ((ServerClient)pFComponent).getServer().getNick() + ") yet. Disconnecting: " + connectionHandler.getIdentity()).with(connectionHandler);
        }
        String string = null;
        Object object = this.acceptLock;
        synchronized (object) {
            if (this.isFiner()) {
                this.logFiner("Accept lock taken. Member: " + identity.getMemberInfo() + ", Handler: " + connectionHandler);
            }
            if ((pFComponent = this.getNode(identity.getMemberInfo())) == null) {
                pFComponent = new Member(this.getController(), connectionHandler.getIdentity().getMemberInfo());
                this.addNode((Member)pFComponent);
                bl = true;
            } else if (!((Member)pFComponent).isOnLAN() && connectionHandler.isOnLAN()) {
                bl = true;
            } else if (!(connectionHandler instanceof D2DSocketConnectionHandler) && ((Member)pFComponent).isConnected()) {
                string = "Duplicate connection detected to " + ((Member)pFComponent).getNick() + " (" + ((Member)pFComponent).getReconnectAddress() + ")";
                bl = false;
            } else {
                bl = true;
            }
            if (this.isFiner()) {
                this.logFiner("Accept lock released. Member: " + identity.getMemberInfo() + ", Handler: " + connectionHandler);
            }
        }
        if (bl) {
            if (((Member)pFComponent).getPeer() != connectionHandler) {
                if (((Member)pFComponent).isConnected()) {
                    this.logInfo("Taking a better conHandler for " + ((Member)pFComponent).getNick() + ". current: " + ((Member)pFComponent).getPeer() + ", onLAN? " + ((Member)pFComponent).isOnLAN() + "/" + ((Member)pFComponent).getPeer().isOnLAN() + ". new: " + connectionHandler + ", onLAN? " + connectionHandler.isOnLAN());
                }
                try {
                    ConnectResult connectResult;
                    int n = ((Member)pFComponent).markConnecting();
                    if (n >= 2) {
                        this.logFine("Multiple connection tries detected (" + n + ") to " + (Member)pFComponent);
                    }
                    if ((connectResult = ((Member)pFComponent).setPeer(connectionHandler)).isFailure()) {
                        throw new ConnectionException("Unable to connect to node " + (Member)pFComponent + ". " + connectResult);
                    }
                }
                finally {
                    ((Member)pFComponent).unmarkConnecting();
                }
            }
        } else {
            if (this.isFine()) {
                this.logFine(string + ", connected? " + connectionHandler.isConnected());
            }
            try {
                connectionHandler.sendMessage(new Problem(string, true, 777));
            }
            finally {
                connectionHandler.shutdown();
            }
            throw new ConnectionException(string + ", connected? " + connectionHandler.isConnected());
        }
        return pFComponent;
    }

    public Member addNode(MemberInfo memberInfo) {
        Member member = new Member(this.getController(), memberInfo);
        this.addNode(member);
        return member;
    }

    private void addNode(Member member) {
        if (member == null) {
            throw new NullPointerException("Node is null");
        }
        Member member2 = this.knownNodes.get(member.getId());
        if (member2 == member) {
            return;
        }
        if (member2 != null) {
            this.logFine("Overwriting old node: " + member2 + " with " + member);
            this.removeNode(member2);
        }
        this.knownNodes.put(member.getId(), member);
        if (!member.isOnSameNetwork()) {
            if (this.isFine()) {
                this.logFine("Changed network ID of node " + member.getNick() + " from " + member.getInfo().networkId + " to " + this.getNetworkId());
            }
            member.getInfo().networkId = this.getNetworkId();
        }
        this.fireNodeAdded(member);
    }

    public void broadcastMessage(Message message) {
        this.broadcastMessage(message, null);
    }

    public void broadcastMessage(final Message message, Filter<Member> filter) {
        if (!this.started) {
            this.logFine("Not started. Not broadcasting message: " + message);
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Broadcasting message: " + message);
        }
        this.broadcastMessage(0, new MessageProducer(){

            @Override
            public Message[] getMessages(boolean bl) {
                return new Message[]{message};
            }
        }, filter);
    }

    public void broadcastMessage(final int n, final MessageProducer messageProducer, final Filter<Member> filter) {
        if (!this.started) {
            this.logFine("Not started. Not broadcasting message: " + Arrays.asList(messageProducer.getMessages(true)));
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Broadcasting message of producer " + messageProducer);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Message[] messageArray = null;
                Message[] messageArray2 = null;
                for (Member member : NodeManager.this.knownNodes.values()) {
                    if (!member.isCompletelyConnected() || filter != null && !filter.accept(member)) continue;
                    if (member.getProtocolVersion() >= n) {
                        if (messageArray2 == null) {
                            messageArray2 = messageProducer.getMessages(true);
                        }
                        if (messageArray2 != null && messageArray2.length > 0) {
                            member.sendMessagesAsynchron(messageArray2);
                        }
                    } else {
                        if (messageArray == null) {
                            messageArray = messageProducer.getMessages(false);
                        }
                        if (messageArray != null && messageArray.length > 0) {
                            member.sendMessagesAsynchron(messageArray);
                        }
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        NodeManager.this.logFiner("InterruptedException", interruptedException);
                        break;
                    }
                }
            }
        };
        this.getController().getIOProvider().startIO(runnable);
    }

    public int broadcastMessageToSupernodes(Message message, int n) {
        if (!this.started) {
            this.logFine("Not started. Not broadcasting message: " + message);
            return 0;
        }
        if (this.isFiner()) {
            this.logFiner("Broadcasting message to supernodes: " + message);
        }
        int n2 = 0;
        LinkedList<Member> linkedList = new LinkedList<Member>();
        for (Member member : this.knownNodes.values()) {
            if (!member.isCompletelyConnected() || !member.isSupernode()) continue;
            linkedList.add(member);
        }
        if (n <= 0) {
            n = linkedList.size();
        }
        n = Math.min(linkedList.size(), n);
        for (int i = 0; i < n; ++i) {
            int n3 = (int)(Math.random() * (double)linkedList.size());
            Member member = (Member)linkedList.get(n3);
            linkedList.remove(n3);
            this.logFine("Sending message to supernode: " + member.getNick() + ". " + message);
            member.sendMessageAsynchron(message);
            ++n2;
        }
        return n2;
    }

    public int broadcastMessageLANNodes(Message message, int n) {
        if (!this.started) {
            this.logFine("Not started. Not broadcasting message: " + message);
            return 0;
        }
        if (this.isFiner()) {
            this.logFiner("Broadcasting message to LAN nodes: " + message);
        }
        int n2 = 0;
        LinkedList<Member> linkedList = new LinkedList<Member>();
        for (Member member : this.knownNodes.values()) {
            if (!member.isCompletelyConnected() || !member.isOnLAN()) continue;
            linkedList.add(member);
        }
        if (n <= 0) {
            n = linkedList.size();
        }
        n = Math.min(linkedList.size(), n);
        for (int i = 0; i < n; ++i) {
            int n3 = (int)(Math.random() * (double)linkedList.size());
            Member member = (Member)linkedList.get(n3);
            linkedList.remove(n3);
            this.logFine("Sending message to lan node: " + member.getNick() + ". " + message);
            member.sendMessageAsynchron(message);
            ++n2;
        }
        return n2;
    }

    public void loadServerNodes() {
        this.getController().getOSClient().loadServerNodes();
    }

    private boolean loadNodesFrom(String string) {
        Path path = Controller.getMiscFilesLocation().resolve(string);
        if (Files.notExists(path, new LinkOption[0])) {
            path = Paths.get(string, new String[0]).toAbsolutePath();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            this.logFine("Unable to load nodes, file not found " + path.toAbsolutePath());
            return false;
        }
        try {
            NodeList nodeList = new NodeList();
            nodeList.load(path);
            this.logFine("Loaded " + nodeList.getNodeList().size() + " nodes from " + path.toAbsolutePath());
            return this.processNodeList(nodeList);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to load nodes from file '" + string + "'. " + iOException.getMessage());
            this.logFiner("IOException", iOException);
        }
        catch (ClassCastException classCastException) {
            this.logWarning("Illegal format of supernodes files '" + string + "', deleted");
            this.logFiner("ClassCastException", classCastException);
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                this.logSevere("Failed to delete supernodes file: " + path.toAbsolutePath());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logWarning("Illegal format of supernodes files '" + string + "', deleted");
            this.logFiner("ClassNotFoundException", classNotFoundException);
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                this.logInfo("Could not delete file '" + path.toAbsolutePath() + "'");
            }
        }
        return false;
    }

    private boolean processNodeList(NodeList nodeList) {
        PFComponent pFComponent;
        this.queueNewNodes(nodeList.getNodeList().toArray(new MemberInfo[nodeList.getNodeList().size()]));
        for (MemberInfo object : nodeList.getFriendsSet()) {
            pFComponent = object.getNode(this.getController(), true);
            if (this.friends.containsKey(((Member)pFComponent).getId()) || ((Member)pFComponent).isMySelf()) continue;
            this.friends.put(((Member)pFComponent).getId(), (Member)pFComponent);
        }
        for (Member member : this.knownNodes.values()) {
            pFComponent = this.getController().getOSClient();
            if (pFComponent != null && ((ServerClient)pFComponent).isPrimaryServer(member) || nodeList.getServersSet().contains(member.getInfo())) continue;
            member.setServer(false);
        }
        for (MemberInfo memberInfo : nodeList.getServersSet()) {
            pFComponent = memberInfo.getNode(this.getController(), true);
            ((Member)pFComponent).updateInfo(memberInfo);
            ((Member)pFComponent).setServer(true);
            if (!this.isFine()) continue;
            this.logFine("Loaded server: " + (Member)pFComponent);
        }
        return !nodeList.isEmpty();
    }

    private void loadNodes() {
        String string = this.getController().getConfigName() + ".nodes";
        if (!this.loadNodesFrom(string)) {
            string = string + ".backup";
            this.logFine("Failed to load nodes, trying backup nodefile '" + string + "'");
            this.loadNodesFrom(string);
        }
        this.getController().getIOProvider().startIO(new Runnable(){

            @Override
            public void run() {
                NodeManager.this.loadServerNodes();
            }
        });
    }

    private void storeNodes() {
        List<MemberInfo> list = Convert.asMemberInfos(this.knownNodes.values());
        list.add(this.getMySelf().getInfo());
        List<MemberInfo> list2 = Convert.asMemberInfos(this.friends.values());
        NodeList nodeList = new NodeList(list, list2, this.getServers());
        if (!this.storeNodes0(this.getController().getConfigName() + ".nodes", nodeList)) {
            this.logFine("Nodes file could not be written");
        }
    }

    private Collection<MemberInfo> getServers() {
        LinkedList<MemberInfo> linkedList = new LinkedList<MemberInfo>();
        for (Member member : this.knownNodes.values()) {
            if (!member.isServer()) continue;
            this.logFine("Server: " + member);
            linkedList.add(member.getInfo());
        }
        return linkedList;
    }

    private void storeOnlineSupernodes() {
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        ArrayList<Member> arrayList2 = new ArrayList<Member>();
        for (Member member : this.getNodesAsCollection()) {
            if (!member.isSupernode() || !member.isConnectedToNetwork()) continue;
            arrayList.add(member.getInfo());
            arrayList2.add(member);
        }
        if (this.getMySelf().isSupernode()) {
            arrayList.add(this.getMySelf().getInfo());
            arrayList2.add(this.getMySelf());
        }
    }

    private boolean storeNodes0(String string, NodeList nodeList) {
        Path path = Controller.getMiscFilesLocation().resolve(string);
        if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.logSevere("Failed to create directory: " + path.toAbsolutePath());
            }
        }
        if (nodeList.getNodeList().isEmpty()) {
            this.logFine("Not storing list of nodes, none known");
            return false;
        }
        this.logFine("Saving known nodes/friends with " + nodeList.getNodeList().size() + " nodes to " + string);
        try {
            nodeList.save(path);
            return true;
        }
        catch (IOException iOException) {
            this.logWarning("Unable to write supernodes to file '" + string + "'. " + iOException.getMessage());
            this.logFiner("IOException", iOException);
            return false;
        }
    }

    public void addMessageListenerToAllNodes(MessageListener messageListener) {
        this.valveMessageListenerSupport.addMessageListener(messageListener);
    }

    public void addMessageListenerToAllNodes(Class<? extends Message> clazz, MessageListener messageListener) {
        this.valveMessageListenerSupport.addMessageListener(clazz, messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.valveMessageListenerSupport.removeMessageListener(messageListener);
    }

    private void setupPeridicalTasks() {
        this.getController().scheduleAndRepeat(new TransferStatusBroadcaster(), 300000L, 600000L);
        this.getController().scheduleAndRepeat(new NodeListRequestor(), 240000L, 480000L);
        this.getController().scheduleAndRepeat(new NodesThatWentOnlineListBroadcaster(), 30000L, 60000L);
        this.getController().scheduleAndRepeat(new AcceptorsChecker(), 0L, 60000L);
        if (Feature.DEBUG_WRITE_NETSTAT.isEnabled()) {
            this.getController().scheduleAndRepeat(new StatisticsWriter(), 59000L, 60000L);
        }
    }

    public void addNodeManagerListener(NodeManagerListener nodeManagerListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, nodeManagerListener);
    }

    public void addWeakNodeManagerListener(NodeManagerListener nodeManagerListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, nodeManagerListener, true);
    }

    public void removeNodeManagerListener(NodeManagerListener nodeManagerListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, nodeManagerListener);
    }

    public void addNodeFilter(NodeFilter nodeFilter) {
        Reject.ifNull(nodeFilter, "Filter is null");
        this.nodeFilters.add(nodeFilter);
    }

    public void removeNodeFilter(NodeFilter nodeFilter) {
        Reject.ifNull(nodeFilter, "Filter is null");
        this.nodeFilters.remove(nodeFilter);
    }

    private void fireNodeRemoved(Member member) {
        this.listenerSupport.nodeRemoved(new NodeManagerEvent(this, member));
    }

    private void fireNodeAdded(Member member) {
        this.listenerSupport.nodeAdded(new NodeManagerEvent(this, member));
    }

    private void fireNodeConnecting(Member member) {
        this.listenerSupport.nodeConnecting(new NodeManagerEvent(this, member));
    }

    private void fireNodeConnected(Member member) {
        this.listenerSupport.nodeConnected(new NodeManagerEvent(this, member));
    }

    private void fireNodeDisconnected(Member member) {
        this.listenerSupport.nodeDisconnected(new NodeManagerEvent(this, member));
    }

    private void fireNodeOnline(Member member) {
        this.listenerSupport.nodeOnline(new NodeManagerEvent(this, member));
    }

    private void fireNodeOffline(Member member) {
        this.listenerSupport.nodeOffline(new NodeManagerEvent(this, member));
    }

    private void fireFriendAdded(Member member) {
        this.listenerSupport.friendAdded(new NodeManagerEvent(this, member));
    }

    private void fireFriendRemoved(Member member) {
        this.listenerSupport.friendRemoved(new NodeManagerEvent(this, member));
    }

    public void fireNodeSettingsChanged(Member member) {
        this.listenerSupport.settingsChanged(new NodeManagerEvent(this, member));
    }

    private final class DefaultNodeFilter
    implements NodeFilter {
        private DefaultNodeFilter() {
        }

        @Override
        public boolean shouldAddNode(MemberInfo memberInfo) {
            boolean bl = memberInfo.isSupernode || memberInfo.isConnected;
            return NodeManager.this.mySelf.isSupernode() || bl;
        }
    }

    private class TransferStatusBroadcaster
    extends TimerTask {
        private TransferStatusBroadcaster() {
        }

        @Override
        public void run() {
            TransferStatus transferStatus = NodeManager.this.getController().getTransferManager().getStatus();
            if (NodeManager.this.isFiner()) {
                NodeManager.this.logFiner("Broadcasting transfer status: " + transferStatus);
            }
            NodeManager.this.broadcastMessage(transferStatus);
        }
    }

    private class NodeListRequestor
    extends TimerTask {
        private NodeListRequestor() {
        }

        @Override
        public void run() {
            RequestNodeList requestNodeList = NodeManager.this.createDefaultNodeListRequestMessage();
            if (log.isLoggable(Level.FINE)) {
                NodeManager.this.logFine("Requesting nodelist: " + requestNodeList);
            }
            NodeManager.this.broadcastMessageToSupernodes(requestNodeList, 4);
        }
    }

    private class NodesThatWentOnlineListBroadcaster
    extends TimerTask {
        private NodesThatWentOnlineListBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MemberInfo[] memberInfoArray;
            if (NodeManager.this.nodesWentOnline.isEmpty()) {
                return;
            }
            NodeManager.this.logFine("Broadcasting " + NodeManager.this.nodesWentOnline.size() + " nodes that went online");
            Set set = NodeManager.this.nodesWentOnline;
            synchronized (set) {
                memberInfoArray = new MemberInfo[NodeManager.this.nodesWentOnline.size()];
                NodeManager.this.nodesWentOnline.toArray(memberInfoArray);
                NodeManager.this.nodesWentOnline.clear();
            }
            NodeManager.this.broadcastMessage(107, new SingleMessageProducer(){

                @Override
                public Message getMessage(boolean bl) {
                    return bl ? new KnownNodesExt(memberInfoArray) : new KnownNodes(memberInfoArray);
                }
            }, null);
        }
    }

    private class AcceptorsChecker
    extends TimerTask {
        private AcceptorsChecker() {
        }

        @Override
        public void run() {
            int n = NodeManager.this.acceptors.size();
            if (NodeManager.this.isFine()) {
                NodeManager.this.logFine("Checking incoming connection queue (" + n + ")");
            }
            if (n > 100) {
                String string = "Processing many incoming connections (" + n + ")";
                if (n > 300) {
                    NodeManager.this.logWarning(string);
                } else {
                    NodeManager.this.logFine(string);
                }
            }
            for (AbstractAcceptor abstractAcceptor : NodeManager.this.acceptors) {
                if (abstractAcceptor.hasTimeout()) {
                    NodeManager.this.logFine("Acceptor has timeout: " + abstractAcceptor);
                    abstractAcceptor.shutdown();
                    NodeManager.this.acceptors.remove(abstractAcceptor);
                    continue;
                }
                if (!abstractAcceptor.isShutdown()) continue;
                NodeManager.this.logFine("Acceptor has been shutdown: " + abstractAcceptor);
                NodeManager.this.acceptors.remove(abstractAcceptor);
            }
        }
    }

    private class StatisticsWriter
    extends TimerTask {
        private StatisticsWriter() {
        }

        @Override
        public void run() {
            Debug.writeStatistics(NodeManager.this.getController());
        }
    }
}

