/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.net.DynDns;
import de.dal33t.powerfolder.net.DynDnsOrg;
import de.dal33t.powerfolder.net.DynDnsUpdateData;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.ErrorDialog;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.preferences.DynDnsSettingsTab;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class DynDnsManager
extends PFComponent {
    private static final long DYNDNS_TIMER_INTERVAL = 300000L;
    private TimerTask updateTask;
    private Thread updateThread;
    private Hashtable<String, DynDns> dynDnsTable;
    public DynDns activeDynDns;
    public String externalIP;
    private ErrorDialog errorDialog;
    private JDialog uiComponent;

    public DynDnsManager(Controller controller) {
        super(controller);
        this.registerDynDns("DynDnsOrg", new DynDnsOrg(controller));
        this.errorDialog = new ErrorDialog(controller, true);
    }

    public void registerDynDns(String string, DynDns dynDns) {
        this.dynDnsTable = new Hashtable();
        dynDns.setDynDnsManager(this);
        this.dynDnsTable.put(string, dynDns);
    }

    public String getUsername() {
        if (DynDnsSettingsTab.getUsername() == null) {
            return ConfigurationEntry.DYNDNS_USERNAME.getValue(this.getController());
        }
        return DynDnsSettingsTab.getUsername();
    }

    public String getUserPassword() {
        if (DynDnsSettingsTab.getPassword() == null) {
            return ConfigurationEntry.DYNDNS_PASSWORD.getValue(this.getController());
        }
        return DynDnsSettingsTab.getPassword();
    }

    public String getHost2Update() {
        if (DynDnsSettingsTab.getNewDyndns() == null) {
            return ConfigurationEntry.HOSTNAME.getValue(this.getController());
        }
        return DynDnsSettingsTab.getNewDyndns();
    }

    public boolean isDynDnsSet() {
        return !StringUtils.isBlank(this.getHost2Update());
    }

    public void fillDefaultUpdateData(DynDnsUpdateData dynDnsUpdateData) {
        dynDnsUpdateData.username = this.getUsername();
        dynDnsUpdateData.pass = this.getUserPassword();
        dynDnsUpdateData.host = this.getHost2Update();
        dynDnsUpdateData.ipAddress = this.getIPviaHTTPCheckIP();
    }

    public boolean validateDynDns(String string) {
        if (StringUtils.isBlank(string)) {
            if (this.getController().getConnectionListener() != null) {
                this.getController().getConnectionListener().setMyDynDns(null, false);
            }
        } else if (this.getController().hasConnectionListener()) {
            int n = this.getController().getConnectionListener().setMyDynDns(string, true);
            switch (n) {
                case 2: {
                    String string2 = Translation.get("exp.preferences.dyn_dns.manager_no_match_text");
                    String string3 = Translation.get("exp.preferences.dyn_dns.manager_no_match_title");
                    int n2 = DialogFactory.genericDialog(this.getController(), string3, string2, new String[]{Translation.get("general.continue"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
                    if (n2 == 0) {
                        this.getController().getConnectionListener().setMyDynDns(string, false);
                        break;
                    }
                    this.getController().getConnectionListener().setMyDynDns(null, false);
                    return false;
                }
                case 1: {
                    this.getController().getConnectionListener().setMyDynDns(null, false);
                    return false;
                }
                case 0: {
                    this.logInfo("Successfully validated dyndns '" + string + "'");
                }
            }
        }
        return true;
    }

    public void showWarningMsg(int n, String string) {
        switch (n) {
            case 2: {
                DialogFactory.genericDialog(this.getController(), Translation.get("exp.preferences.dyn_dns.warning_message"), Translation.get("exp.preferences.dyn_dns.status_valid_failed", string), GenericDialogType.WARN);
                break;
            }
            case 1: {
                DialogFactory.genericDialog(this.getController(), Translation.get("exp.preferences.dyn_dns.warning_message"), Translation.get("exp.preferences.dyn_dns.status_valid_failed", string), GenericDialogType.WARN);
            }
        }
    }

    public void showPanelErrorMessage() {
        String string = "";
        if (this.getHost2Update().length() == 0) {
            string = "hostname";
        } else if (this.getUsername().length() == 0) {
            string = "username";
        } else if (this.getUserPassword().length() == 0) {
            string = "password";
        }
        DialogFactory.genericDialog(this.getController(), Translation.get("exp.preferences.dyn_dns.update_title"), Translation.get("exp.preferences.dyn_dns.update_text", string), GenericDialogType.ERROR);
    }

    public void showDynDnsUpdaterMsg(int n) {
        switch (n) {
            case 0: {
                DialogFactory.genericDialog(this.getController(), Translation.get("exp.preferences.dyn_dns.update_title"), this.activeDynDns.getErrorText(), GenericDialogType.INFO);
                break;
            }
            case 1: 
            case 2: {
                this.errorDialog.open(this.activeDynDns.getErrorText(), n);
                break;
            }
            case 3: {
                DialogFactory.genericDialog(this.getController(), Translation.get("exp.preferences.dyn_dns.update_title"), Translation.get("exp.preferences.dyn_dns.update_unknown_error"), GenericDialogType.ERROR);
            }
        }
    }

    public final void close() {
        this.logFiner("Close called: " + this);
        if (this.uiComponent != null) {
            this.uiComponent.dispose();
            this.uiComponent = null;
        }
    }

    public final void show(String string) {
        this.logFiner("Open called: " + this);
        this.getUIComponent(string).setVisible(true);
    }

    private String getTitle() {
        return Translation.get("preferences.dialog.title_processing");
    }

    private void saveUpdatedIP(DynDnsUpdateData dynDnsUpdateData) {
        ConfigurationEntry.DYNDNS_LAST_UPDATED_IP.setValue(this.getController(), dynDnsUpdateData.ipAddress);
        this.getController().saveConfig();
    }

    protected final JDialog getUIComponent(String string) {
        if (this.uiComponent == null) {
            this.logFiner("Building ui component for " + this);
            this.uiComponent = new JDialog((Frame)this.getController().getUIController().getMainFrame().getUIComponent(), this.getTitle());
            this.uiComponent.setResizable(false);
            this.uiComponent.setDefaultCloseOperation(2);
            FormLayout formLayout = new FormLayout("pref, 14dlu, pref:grow", "pref, pref:grow, 6dlu, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.DLU14_BORDER);
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            panelBuilder.add((Component)new JLabel(Translation.get("exp.preferences.dyn_dns.status_wait", string)), cellConstraints.xywh(n, n2, n3, n4));
            this.uiComponent.getContentPane().add(panelBuilder.getPanel());
            this.uiComponent.pack();
            Window window = this.uiComponent.getOwner();
            int n5 = window.getX() + (window.getWidth() - this.uiComponent.getWidth()) / 2;
            int n6 = window.getY() + (window.getHeight() - this.uiComponent.getHeight()) / 2;
            this.uiComponent.setLocation(n5, n6);
        }
        return this.uiComponent;
    }

    private boolean dyndnsValid() {
        String string = this.getHostIP(ConfigurationEntry.HOSTNAME.getValue(this.getController()));
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        String string2 = this.getIPviaHTTPCheckIP();
        String string3 = ConfigurationEntry.DYNDNS_LAST_UPDATED_IP.getValue(this.getController());
        this.logFine("Dyndns hostname IP: " + string + ". Real IP: " + string2 + ". Last update IP: " + string3);
        if (string.equals(string2)) {
            return true;
        }
        return string2.equals(string3);
    }

    private int updateDynDNS() {
        this.activeDynDns = this.dynDnsTable.get("DynDnsOrg");
        DynDnsUpdateData dynDnsUpdateData = this.activeDynDns.getDynDnsUpdateData();
        int n = this.activeDynDns.update(dynDnsUpdateData);
        this.logInfo("Updated dyndns. Result: " + n);
        if (n == 0) {
            this.saveUpdatedIP(dynDnsUpdateData);
        }
        this.logFiner("the updated dyndns > " + this.externalIP);
        return n;
    }

    public void forceUpdate() {
        this.showDynDnsUpdaterMsg(this.updateDynDNS());
    }

    public synchronized void updateIfNessesary() {
        if (!ConfigurationEntry.DYNDNS_AUTO_UPDATE.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        if (this.updateTask == null) {
            this.setupUpdateTask();
            this.logFiner("DNS Autoupdate requested. Starting updater.");
        }
        if (this.updateThread != null) {
            this.logFine("No dyndns update performed. Already running");
            return;
        }
        this.updateThread = new Thread("DynDns Updater"){

            @Override
            public void run() {
                boolean bl = DynDnsManager.this.dyndnsValid();
                DynDnsManager.this.logFine("Dyndns updater start. Update required? " + !bl);
                if (bl) {
                    DynDnsManager.this.logFiner("No dyndns update performed: IP still valid");
                } else {
                    DynDnsManager.this.updateDynDNS();
                }
                DynDnsManager.this.logFiner("Dyndns updater finished");
                DynDnsManager.this.updateThread = null;
            }
        };
        this.updateThread.start();
    }

    private void setupUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = new TimerTask(){

            @Override
            public void run() {
                DynDnsManager.this.updateIfNessesary();
            }
        };
        this.getController().scheduleAndRepeat(this.updateTask, 0L, 300000L);
    }

    public String getHostIP(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                string2 = inetAddress.getHostAddress();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logSevere("Can't get the host ip address" + illegalArgumentException.toString());
        }
        catch (UnknownHostException unknownHostException) {
            this.logSevere("Can't get the host ip address" + unknownHostException.toString());
        }
        return string2;
    }

    public String getIPviaHTTPCheckIP() {
        String string = "";
        try {
            int n;
            URL uRL = new URL("http://checkip.dyndns.org/");
            URLConnection uRLConnection = uRL.openConnection();
            int n2 = uRLConnection.getContentLength();
            ByteArrayOutputStream byteArrayOutputStream = n2 < 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(n2);
            InputStream inputStream = uRLConnection.getInputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            String string2 = byteArrayOutputStream.toString();
            this.logFiner("Received '" + string2 + "' from " + uRL);
            string = DynDnsManager.filterIPs(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private static String filterIPs(String string) {
        String string2 = null;
        Pattern pattern = Pattern.compile("[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string2 = string.substring(matcher.start(), matcher.end());
        }
        return string2;
    }
}

