/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DReplyFromServer;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.protocol.LoginReplyProto;
import de.dal33t.powerfolder.protocol.ServerInfoProto;
import java.util.Map;

public class LoginReply
extends D2DReplyMessage
implements D2DReplyFromServer {
    protected String replyCode;
    private ServerInfo redirectServerInfo;
    private Map<String, String> tokens;

    public LoginReply() {
    }

    public LoginReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public LoginReply(String string, StatusCode statusCode, ServerInfo serverInfo) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.redirectServerInfo = serverInfo;
    }

    public LoginReply(String string, StatusCode statusCode, Map<String, String> map) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.tokens = map;
    }

    public LoginReply(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof LoginReplyProto.LoginReply) {
            LoginReplyProto.LoginReply loginReply = (LoginReplyProto.LoginReply)abstractMessage;
            this.replyCode = loginReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(loginReply.getReplyStatusCode());
            this.redirectServerInfo = new ServerInfo(loginReply.getRedirectServerInfo());
            this.tokens = loginReply.getTokensMap();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        LoginReplyProto.LoginReply.Builder builder = LoginReplyProto.LoginReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder.setReplyCode(this.replyCode);
        }
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.redirectServerInfo != null) {
            builder.setRedirectServerInfo((ServerInfoProto.ServerInfo)this.redirectServerInfo.toD2D());
        }
        if (this.tokens != null) {
            builder.putAllTokens(this.tokens);
        }
        return builder.build();
    }
}

