/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.activity.domain.ActivityItem;
import de.dal33t.powerfolder.d2d.D2DReplyFromServer;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.protocol.ActivityItemProto;
import de.dal33t.powerfolder.protocol.ActivityListReplyProto;
import java.util.Collection;

public class ActivityListReply
extends D2DReplyMessage
implements D2DReplyFromServer {
    private Collection<ActivityItem> activityItems;

    public ActivityListReply() {
    }

    public ActivityListReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public ActivityListReply(String string, StatusCode statusCode, Collection<ActivityItem> collection) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.activityItems = collection;
    }

    public Collection<ActivityItem> getActivityItems() {
        return this.activityItems;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        ActivityListReplyProto.ActivityListReply.Builder builder = ActivityListReplyProto.ActivityListReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder.setReplyCode(this.replyCode);
        }
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.getActivityItems() != null) {
            for (ActivityItem activityItem : this.getActivityItems()) {
                builder.addActivityItems((ActivityItemProto.ActivityItem)activityItem.toD2D());
            }
        }
        return builder.build();
    }
}

