/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.MessageOrBuilder;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DReplyFromServer;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.protocol.AccountInfoProto;
import de.dal33t.powerfolder.protocol.AccountInfoReplyProto;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.ServerInfoProto;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderPermission;
import java.util.Collection;
import java.util.Map;

public class AccountInfoReply
extends D2DReplyMessage
implements D2DReplyFromServer {
    private Account account;
    private Collection<FolderPermission> invitations;
    private Map<String, String> folderMapping;
    private long avatarLastModifiedDate;
    private long usedQuota;
    private long backupQuota;
    private long freeQuota;
    private int maxFolders;
    private String organizationName;
    private AccountInfo accountInfo;

    public AccountInfoReply() {
    }

    public AccountInfoReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public AccountInfoReply(String string, StatusCode statusCode, Account account, Collection<FolderPermission> collection, Map<String, String> map, long l, long l2, long l3, long l4, int n, String string2) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.account = account;
        this.invitations = collection;
        this.folderMapping = map;
        this.avatarLastModifiedDate = l;
        this.usedQuota = l2;
        this.backupQuota = l3;
        this.freeQuota = l4;
        this.maxFolders = n;
        this.organizationName = string2;
    }

    public AccountInfoReply(String string, StatusCode statusCode, AccountInfo accountInfo, long l) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.accountInfo = accountInfo;
        this.avatarLastModifiedDate = l;
    }

    public AccountInfoReply(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public Account getAccount() {
        return this.account;
    }

    public Collection<FolderPermission> getInvitations() {
        return this.invitations;
    }

    public long getAvatarLastModifiedDate() {
        return this.avatarLastModifiedDate;
    }

    public long getUsedQuota() {
        return this.usedQuota;
    }

    public void setUsedQuota(long l) {
        this.usedQuota = l;
    }

    public long getBackupQuota() {
        return this.backupQuota;
    }

    public void setBackupQuota(long l) {
        this.backupQuota = l;
    }

    public long getFreeQuota() {
        return this.freeQuota;
    }

    public void setFreeQuota(long l) {
        this.freeQuota = l;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AccountInfoReplyProto.AccountInfoReply) {
            AccountInfoReplyProto.AccountInfoReply accountInfoReply = (AccountInfoReplyProto.AccountInfoReply)abstractMessage;
            this.replyCode = accountInfoReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(accountInfoReply.getReplyStatusCode());
            this.accountInfo = new AccountInfo(accountInfoReply.getAccountInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AccountInfoReplyProto.AccountInfoReply.Builder builder = AccountInfoReplyProto.AccountInfoReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder.setReplyCode(this.replyCode);
        }
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.account != null) {
            MessageOrBuilder messageOrBuilder;
            AccountInfoProto.AccountInfo accountInfo = (AccountInfoProto.AccountInfo)this.account.toD2D();
            AccountInfoProto.AccountInfo.Builder builder2 = accountInfo.toBuilder();
            for (FolderPermission object : this.invitations) {
                messageOrBuilder = ((PermissionInfoProto.PermissionInfo)object.toD2D()).toBuilder();
                ((PermissionInfoProto.PermissionInfo.Builder)messageOrBuilder).setIsInvitation(true);
                builder2.addPermissionInfos(((PermissionInfoProto.PermissionInfo.Builder)messageOrBuilder).build());
            }
            if (this.account.getServer() != null && this.account.getServer().getNode() != null) {
                builder2.setHostingServerInfo((ServerInfoProto.ServerInfo)this.account.getServer().toD2D());
            }
            for (Map.Entry entry : this.account.getTokens().entrySet()) {
                messageOrBuilder = (ServerInfoProto.ServerInfo)((ServerInfo)entry.getKey()).toD2D();
                ServerInfoProto.ServerInfo.Builder builder3 = ((ServerInfoProto.ServerInfo)messageOrBuilder).toBuilder();
                builder3.setToken((String)entry.getValue());
                builder2.addServerInfos(builder3.build());
            }
            if (this.folderMapping != null) {
                builder2.putAllFolderMapping(this.folderMapping);
            }
            builder2.setAvatarLastModifiedDate(this.avatarLastModifiedDate);
            builder2.setUsedQuota(this.usedQuota);
            builder2.setBackupQuota(this.backupQuota);
            builder2.setFreeQuota(this.freeQuota);
            builder2.setMaxFolders(this.maxFolders);
            if (this.organizationName != null) {
                builder2.setOrganizationId(this.organizationName);
            }
            accountInfo = builder2.build();
            builder.setAccountInfo(accountInfo);
        } else if (this.accountInfo != null) {
            builder.setAccountInfo((AccountInfoProto.AccountInfo)this.accountInfo.toD2D());
        }
        return builder.build();
    }
}

