/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.util.Reject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class RequestNodeList
extends Message {
    private static final long serialVersionUID = 101L;
    private NodesCriteria supernodesCriteria;
    private NodesCriteria nodesCriteria;
    private Collection<String> nodeIds;

    private RequestNodeList(Collection<String> collection, NodesCriteria nodesCriteria, NodesCriteria nodesCriteria2) {
        Reject.ifNull((Object)nodesCriteria2, "Nodes criteria is null");
        Reject.ifNull((Object)nodesCriteria, "Supernodes criteria is null");
        this.supernodesCriteria = nodesCriteria;
        this.nodesCriteria = nodesCriteria2;
        this.nodeIds = collection;
    }

    public static RequestNodeList createRequestAllNodes() {
        return new RequestNodeList(null, NodesCriteria.ALL, NodesCriteria.ALL);
    }

    public static RequestNodeList createRequest(Collection<Member> collection, NodesCriteria nodesCriteria, NodesCriteria nodesCriteria2) {
        Reject.ifNull(collection, "Nodes is null");
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (Member member : collection) {
            hashSet.add(member.getId());
        }
        return new RequestNodeList(hashSet, nodesCriteria, nodesCriteria2);
    }

    public List<MemberInfo> filter(Collection<Member> collection) {
        ArrayList<MemberInfo> arrayList = null;
        arrayList = NodesCriteria.ALL.equals((Object)this.nodesCriteria) ? new ArrayList(collection.size()) : new ArrayList<MemberInfo>();
        for (Member member : collection) {
            if (!this.matches(member)) continue;
            arrayList.add(member.getInfo());
        }
        return arrayList;
    }

    private boolean matches(Member member) {
        if (ServerClient.isTempServerNode(member.getInfo())) {
            return false;
        }
        if (NodesCriteria.ALL.equals((Object)this.nodesCriteria)) {
            return true;
        }
        if (NodesCriteria.ONLINE.equals((Object)this.nodesCriteria) && member.isConnectedToNetwork()) {
            return true;
        }
        if (NodesCriteria.ALL.equals((Object)this.supernodesCriteria) && member.isSupernode()) {
            return true;
        }
        if (NodesCriteria.ONLINE.equals((Object)this.supernodesCriteria) && member.isSupernode() && member.isConnectedToNetwork()) {
            return true;
        }
        return this.nodeIds != null && this.nodeIds.contains(member.getId());
    }

    public String toString() {
        return "Request for NodeList (supernodes: " + this.supernodesCriteria + ", normal-nodes: " + this.nodesCriteria + ", " + (Serializable)(this.nodeIds == null ? "all" : Integer.valueOf(this.nodeIds.size())) + " nodes)";
    }

    public static enum NodesCriteria {
        ALL,
        ONLINE,
        NONE;

    }
}

