/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.protocol.FilePartInfoListReplyProto;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ReplyFilePartsRecord
extends Message
implements D2DObject {
    private static final long serialVersionUID = 100L;
    private FileInfo file;
    private FilePartsRecord record;

    public ReplyFilePartsRecord() {
    }

    public ReplyFilePartsRecord(FileInfo fileInfo, FilePartsRecord filePartsRecord) {
        this.file = fileInfo;
        this.record = filePartsRecord;
        this.validate();
    }

    public FileInfo getFile() {
        return this.file;
    }

    public FilePartsRecord getRecord() {
        return this.record;
    }

    private void validate() {
        Reject.noNullElements(this.file, this.record);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validate();
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FilePartInfoListReplyProto.FilePartInfoListReply) {
            FilePartInfoListReplyProto.FilePartInfoListReply filePartInfoListReply = (FilePartInfoListReplyProto.FilePartInfoListReply)abstractMessage;
            this.file = new FileInfo(filePartInfoListReply.getFileInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FilePartInfoListReplyProto.FilePartInfoListReply.Builder builder = FilePartInfoListReplyProto.FilePartInfoListReply.newBuilder();
        builder.setClazzName("FilePartInfoListReply");
        builder.setFileInfo((FileInfoProto.FileInfo)this.file.toD2D());
        return builder.build();
    }
}

