/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Ping;
import de.dal33t.powerfolder.protocol.PongProto;
import de.dal33t.powerfolder.util.Format;

public class Pong
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 100L;
    public String id;
    private long receiveTime;
    byte[] payload;

    public Pong() {
    }

    public Pong(Ping ping) {
        this.payload = ping.payload;
        this.id = ping.id;
    }

    public long took(Ping ping) {
        if (ping == null) {
            throw new NullPointerException("Ping is null");
        }
        if (!ping.id.equals(this.id)) {
            throw new IllegalArgumentException("Pong (ID: " + this.id + ") does not match Ping (ID: " + ping.id + ")");
        }
        if (this.receiveTime == 0L) {
            this.receiveTime = System.currentTimeMillis();
        }
        if (ping.sendTime == 0L) {
            throw new IllegalStateException("Ping has not been flagged as sent");
        }
        return this.receiveTime - ping.sendTime;
    }

    public String toString() {
        return "Pong" + (String)(this.payload != null ? " " + Format.formatBytes(this.payload.length) + " bytes payload" : "");
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof PongProto.Pong) {
            PongProto.Pong pong = (PongProto.Pong)abstractMessage;
            this.receiveTime = pong.getReceiveTime();
            this.payload = pong.getPayload().getBytes();
            this.id = pong.getId();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PongProto.Pong.Builder builder = PongProto.Pong.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setReceiveTime(this.receiveTime);
        builder.setPayload(String.valueOf(this.payload));
        builder.setId(this.id);
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.PONG;
    }
}

