/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.protocol.IdentityProto;
import de.dal33t.powerfolder.protocol.NodeInfoProto;
import de.dal33t.powerfolder.util.Reject;
import java.util.Calendar;

public class Identity
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 101L;
    private MemberInfo member;
    private String magicId;
    private boolean supportsEncryption;
    private boolean supportsQuickLogin = true;
    private boolean tunneled;
    private boolean acknowledgesHandshakeCompletion = true;
    private boolean supportsSerializedRequest = true;
    private String programVersion = "23.4.100";
    private String operatingSystem;
    private Calendar timeGMT = Calendar.getInstance();
    private boolean supportingPartTransfers = true;
    private Boolean useCompressedStream;
    public static final int PROTOCOL_VERSION_106 = 106;
    public static final int PROTOCOL_VERSION_107 = 107;
    public static final int PROTOCOL_VERSION_108 = 108;
    public static final int PROTOCOL_VERSION_109 = 109;
    public static final int PROTOCOL_VERSION_110 = 110;
    public static final int PROTOCOL_VERSION_111 = 111;
    public static final int PROTOCOL_VERSION_112 = 112;
    public static final int PROTOCOL_VERSION_113 = 113;
    private int protocolVersion = 113;
    private boolean requestFullFolderlist;
    private boolean pendingMessages = false;
    private String configurationURL;

    public Identity() {
    }

    public Identity(Controller controller, MemberInfo memberInfo, String string, boolean bl, boolean bl2, ConnectionHandler connectionHandler) {
        Reject.ifNull(controller, "Controller is null");
        Reject.ifNull(memberInfo, "Member is null");
        this.operatingSystem = System.getProperty("os.name");
        this.member = memberInfo;
        this.magicId = string;
        this.supportsEncryption = bl;
        this.tunneled = bl2;
        this.pendingMessages = controller.getTaskManager().hasSendMessageTask();
        boolean bl3 = ConfigurationEntry.USE_ZIP_ON_LAN.getValueBoolean(controller);
        this.useCompressedStream = !connectionHandler.isOnLAN() || connectionHandler.isOnLAN() && bl3;
        this.requestFullFolderlist = controller.getMySelf().isServer();
        this.configurationURL = ConfigurationEntry.CONFIG_URL.getValue(controller);
    }

    public boolean isValid() {
        return this.member != null && this.member.id != null && this.member.nick != null;
    }

    public String getNick() {
        return this.member != null ? this.member.nick : null;
    }

    public String getMagicId() {
        return this.magicId;
    }

    public MemberInfo getMemberInfo() {
        return this.member;
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public boolean isSupportsEncryption() {
        return this.supportsEncryption;
    }

    public boolean isSupportingPartTransfers() {
        return this.supportingPartTransfers;
    }

    public boolean isSupportsQuickLogin() {
        return this.supportsQuickLogin;
    }

    public Boolean isUseCompressedStream() {
        return this.useCompressedStream;
    }

    public boolean isRequestFullFolderlist() {
        return this.requestFullFolderlist;
    }

    public boolean isTunneled() {
        return this.tunneled;
    }

    public boolean isSupportsSerializedRequest() {
        return this.supportsSerializedRequest;
    }

    public boolean isPendingMessages() {
        return this.pendingMessages;
    }

    public Calendar getTimeGMT() {
        return this.timeGMT;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getConfigURL() {
        return this.configurationURL;
    }

    public String toString() {
        return "Identity: " + this.member;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof IdentityProto.Identity) {
            IdentityProto.Identity identity = (IdentityProto.Identity)abstractMessage;
            this.member = new MemberInfo(identity.getNodeInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        IdentityProto.Identity.Builder builder = IdentityProto.Identity.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.member != null) {
            builder.setNodeInfo((NodeInfoProto.NodeInfo)this.member.toD2D());
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.IDENTITY;
    }
}

