/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FolderFilesChanged;
import de.dal33t.powerfolder.util.ExternalizableUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderFilesChangedExt
extends FolderFilesChanged
implements Externalizable {
    private static final long serialVersionUID = -2047091337743391978L;
    private static final long extVersionUID = 100L;
    private static final Logger LOG = Logger.getLogger(FolderFilesChangedExt.class.getName());

    public FolderFilesChangedExt() {
    }

    FolderFilesChangedExt(FileInfo fileInfo) {
        super(fileInfo, true);
    }

    FolderFilesChangedExt(FolderInfo folderInfo, FileInfo[] fileInfoArray) {
        super(folderInfo, fileInfoArray);
    }

    FolderFilesChangedExt(FolderInfo folderInfo) {
        super(folderInfo);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", expected: 100");
        }
        this.folder = ExternalizableUtil.readFolderInfo(objectInput);
        if (objectInput.readBoolean()) {
            int n = objectInput.readInt();
            this.added = new FileInfo[n];
            for (int i = 0; i < this.added.length; ++i) {
                this.added[i] = FileInfoFactory.readExt(objectInput);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(100L);
        ExternalizableUtil.writeFolderInfo(objectOutput, this.folder, false);
        objectOutput.writeBoolean(this.added != null);
        if (this.added != null) {
            objectOutput.writeInt(this.added.length);
            for (int i = 0; i < this.added.length; ++i) {
                this.added[i].writeExternal(objectOutput);
            }
        }
        if (this.removed != null && this.removed.length > 0 && LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("Field removed-files is not empty! This should not happen");
        }
    }
}

