/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.disk.DiskItemFilter;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FileListExt;
import de.dal33t.powerfolder.message.FolderFilesChanged;
import de.dal33t.powerfolder.message.FolderFilesChangedExt;
import de.dal33t.powerfolder.message.FolderRelatedMessage;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.util.Reject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileList
extends FolderRelatedMessage {
    private static final Logger log = Logger.getLogger(FileList.class.getName());
    private static final long serialVersionUID = 100L;
    public FileInfo[] files;
    public int nFollowingDeltas;

    public FileList() {
    }

    public FileList(FolderInfo folderInfo, FileInfo[] fileInfoArray, int n) {
        Reject.ifNull(folderInfo, "FolderInfo is null");
        Reject.ifNull(fileInfoArray, "Files is null");
        Reject.ifTrue(n < 0, "Invalid number for following detla messages");
        this.files = fileInfoArray;
        this.folder = folderInfo;
        this.nFollowingDeltas = n;
    }

    protected FileList(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "FolderInfo is null");
        this.files = null;
        this.folder = folderInfo;
        this.nFollowingDeltas = 0;
    }

    public static FileList createEmpty(FolderInfo folderInfo, boolean bl) {
        if (bl) {
            return new FileListExt(folderInfo);
        }
        return new FileList(folderInfo);
    }

    public static Message[] create(Folder folder, boolean bl) {
        return FileList.createFileListMessages(folder.getInfo(), folder.getKnownFiles(), folder.getKnownDirectories(), folder.getDiskItemFilter(), bl);
    }

    public static Message[] create4Test(FolderInfo folderInfo, Collection<FileInfo> collection, DiskItemFilter diskItemFilter) {
        List<DirectoryInfo> list = Collections.emptyList();
        return FileList.createFileListMessages(folderInfo, collection, list, diskItemFilter, true);
    }

    private static Message[] createFileListMessages(FolderInfo folderInfo, Collection<FileInfo> collection, Collection<DirectoryInfo> collection2, DiskItemFilter diskItemFilter, boolean bl) {
        Reject.ifNull(folderInfo, "Folder info is null");
        Reject.ifNull(collection, "Files is null");
        Reject.ifNull(diskItemFilter, "DiskItemFilter is null");
        Reject.ifTrue(false, "Unable to split filelist. nFilesPerMessage: 500");
        if (collection.isEmpty() && collection2.isEmpty()) {
            if (bl) {
                return new Message[]{new FileListExt(folderInfo, new FileInfo[0], 0)};
            }
            return new Message[]{new FileList(folderInfo, new FileInfo[0], 0)};
        }
        ArrayList<FolderRelatedMessage> arrayList = new ArrayList<FolderRelatedMessage>(collection.size() / 500);
        int n = 0;
        boolean bl2 = true;
        int n2 = 0;
        FileInfo[] fileInfoArray = new FileInfo[500];
        for (FileInfo fileInfo : collection) {
            if (diskItemFilter.isExcluded(fileInfo)) continue;
            fileInfoArray[n2] = fileInfo;
            if (++n2 < 500) continue;
            if (bl2) {
                if (bl) {
                    arrayList.add(new FileListExt(folderInfo, fileInfoArray, 0));
                } else {
                    arrayList.add(new FileList(folderInfo, fileInfoArray, 0));
                }
                bl2 = false;
            } else {
                ++n;
                if (bl) {
                    arrayList.add(new FolderFilesChangedExt(folderInfo, fileInfoArray));
                } else {
                    arrayList.add(new FolderFilesChanged(folderInfo, fileInfoArray));
                }
            }
            fileInfoArray = new FileInfo[500];
            n2 = 0;
        }
        for (DirectoryInfo directoryInfo : collection2) {
            if (diskItemFilter.isExcluded(directoryInfo)) continue;
            fileInfoArray[n2] = directoryInfo;
            if (++n2 < 500) continue;
            if (bl2) {
                if (bl) {
                    arrayList.add(new FileListExt(folderInfo, fileInfoArray, 0));
                } else {
                    arrayList.add(new FileList(folderInfo, fileInfoArray, 0));
                }
                bl2 = false;
            } else {
                ++n;
                if (bl) {
                    arrayList.add(new FolderFilesChangedExt(folderInfo, fileInfoArray));
                } else {
                    arrayList.add(new FolderFilesChanged(folderInfo, fileInfoArray));
                }
            }
            fileInfoArray = new FileInfo[500];
            n2 = 0;
        }
        if (bl2 && n2 == 0) {
            if (bl) {
                return new Message[]{new FileListExt(folderInfo, new FileInfo[0], 0)};
            }
            return new Message[]{new FileList(folderInfo, new FileInfo[0], 0)};
        }
        if (n2 != 0 && n2 < fileInfoArray.length) {
            FileInfo[] fileInfoArray2 = new FileInfo[n2];
            System.arraycopy(fileInfoArray, 0, fileInfoArray2, 0, fileInfoArray2.length);
            if (bl2) {
                if (bl) {
                    arrayList.add(new FileListExt(folderInfo, fileInfoArray2, 0));
                } else {
                    arrayList.add(new FileList(folderInfo, fileInfoArray2, 0));
                }
                bl2 = false;
            } else {
                ++n;
                if (bl) {
                    arrayList.add(new FolderFilesChangedExt(folderInfo, fileInfoArray2));
                } else {
                    arrayList.add(new FolderFilesChanged(folderInfo, fileInfoArray2));
                }
            }
        }
        if (!arrayList.isEmpty() && arrayList.get(0) instanceof FileList) {
            ((FileList)arrayList.get((int)0)).nFollowingDeltas = n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Splitted filelist into " + arrayList.size() + ", deltas: " + n + ", folder: " + folderInfo + ", files: " + collection.size() + ", dirs: " + collection2.size() + "\nSplitted msgs: " + arrayList);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    public boolean isNull() {
        return this.files == null;
    }

    public String toString() {
        return "FileList of " + this.folder + ": " + (String)(this.files != null ? this.files.length + " file(s)" : "No information about files.");
    }
}

