/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.pro.F.D;
import de.dal33t.powerfolder.pro.F.G;
import de.dal33t.powerfolder.util.Util;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionSetup
extends Message {
    private static final long serialVersionUID = 102L;
    private static final String SHA1_WITH_RSA = "SHA1withRSA";
    public List<byte[]> sessionKeyData;
    public byte[] signature;

    public EncryptionSetup(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws G {
        try {
            Cipher cipher = D.B(privateKey);
            Cipher cipher2 = D.B(publicKey);
            byte[] byArray = secretKey.getEncoded();
            byte[] byArray2 = cipher.doFinal(byArray);
            List<byte[]> list = Util.splitArray(byArray2, 100);
            this.sessionKeyData = D.A(list, cipher2);
            Signature signature = Signature.getInstance(SHA1_WITH_RSA);
            signature.initSign(privateKey);
            signature.update(byArray);
            this.signature = signature.sign();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new G("Problem while checking encryption challenge", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new G("Problem while checking encryption challenge", badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new G("Problem while checking encryption challenge", invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new G("Problem while checking encryption challenge", signatureException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new G("Problem while checking encryption challenge", noSuchAlgorithmException);
        }
    }

    public SecretKey decryptSessionKey(PrivateKey privateKey, PublicKey publicKey) throws G {
        try {
            Cipher cipher = D.C(privateKey);
            Cipher cipher2 = D.C(publicKey);
            List<byte[]> list = D.A(this.sessionKeyData, cipher);
            byte[] byArray = Util.mergeArrayList(list);
            byte[] byArray2 = cipher2.doFinal(byArray);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
            if (this.signature == null) {
                throw new G("Signature missing");
            }
            Signature signature = Signature.getInstance(SHA1_WITH_RSA);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(this.signature)) {
                throw new G("Unable to verify signature of session key");
            }
            return secretKeySpec;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new G("Problem while checking encryption challenge", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new G("Problem while checking encryption challenge", badPaddingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new G("Problem while checking encryption challenge", noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new G("Problem while checking encryption challenge", signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new G("Problem while checking encryption challenge", invalidKeyException);
        }
    }
}

