/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.NodeInfoProto;
import de.dal33t.powerfolder.util.ExternalizableUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.db.InetSocketAddressUserType;
import de.dal33t.powerfolder.util.intern.Internalizer;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

@TypeDef(name="socketAddressType", typeClass=InetSocketAddressUserType.class)
@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MemberInfo
implements Serializable,
D2DObject {
    private static final long serialVersionUID = 100L;
    public static Internalizer<MemberInfo> INTERNALIZER;
    public static final String NODEID_IOS_PREFIX = "iOS_";
    public static final String NODEID_HOST_APP_SUFFIX = "_HA";
    public static final String NODEID_SHELL_EXTENSIONS_SUFFIX = "_SE";
    public static final String NODEID_FILE_PROVIDER_SUFFIX = "_FP";
    public static final String PROPERTYNAME_NICK = "nick";
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_CONNECT_ADDRESS = "connectAddress";
    public String nick;
    @Id
    public String id;
    public String networkId;
    @Type(type="socketAddressType")
    private InetSocketAddress connectAddress;
    @Transient
    private int d2dPort;
    private Date lastConnectTime;
    public boolean isConnected;
    public boolean isSupernode;
    private transient Boolean hasNullIP;
    private transient int hash;
    private static final long extVersionUID = 100L;

    private MemberInfo() {
    }

    public MemberInfo(String string, String string2, String string3) {
        this.nick = string;
        this.id = string2;
        this.networkId = string3 != null ? string3 : ConfigurationEntry.NETWORK_ID.getDefaultValue();
    }

    public MemberInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public void setConnectAddress(InetSocketAddress inetSocketAddress) {
        if (Util.equals(this.connectAddress, inetSocketAddress)) {
            return;
        }
        this.connectAddress = inetSocketAddress;
        this.hasNullIP = null;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    public int getD2dPort() {
        return this.d2dPort;
    }

    public void setD2dPort(int n) {
        this.d2dPort = n;
    }

    public boolean isIOS() {
        return this.id.startsWith(NODEID_IOS_PREFIX);
    }

    public boolean isIOSHostApp() {
        return this.isIOS() && this.id.endsWith(NODEID_HOST_APP_SUFFIX);
    }

    public String getId() {
        return this.id;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getNick() {
        return this.nick;
    }

    public Date getLastConnectTime() {
        return this.lastConnectTime;
    }

    public void setLastConnectNow() {
        this.lastConnectTime = new Date();
    }

    public void setLastConnectTime(Date date) {
        this.lastConnectTime = date;
    }

    public boolean matches(Member member) {
        if (member == null) {
            return false;
        }
        return Util.equals(member.getId(), this.id);
    }

    public boolean matches(String string) {
        String string2;
        if (this.connectAddress != null && this.connectAddress.getAddress() != null && (string2 = this.connectAddress.getAddress().getHostAddress()) != null && string2.equals(string)) {
            return true;
        }
        return this.nick.toLowerCase().indexOf(string.toLowerCase()) >= 0;
    }

    public boolean isFriend(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        Member member = this.getNode(controller, false);
        return member != null && member.isFriend();
    }

    public boolean isOnSameNetwork(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        if (controller.getNodeManager().getNetworkId().equals("ANY")) {
            return true;
        }
        if (this.networkId.equals("ANY")) {
            return true;
        }
        return controller.getNodeManager().getNetworkId().equals(this.networkId);
    }

    public boolean isInvalid(Controller controller) {
        if (this.isFriend(controller)) {
            return false;
        }
        if (this.lastConnectTime == null) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastConnectTime.getTime() >= 5184000000L) {
            return true;
        }
        return this.lastConnectTime.getTime() > System.currentTimeMillis() + 86400000L;
    }

    public boolean hasNullIP() {
        if (this.hasNullIP == null) {
            this.hasNullIP = NetworkUtil.isNullIP(this.connectAddress.getAddress());
        }
        return this.hasNullIP;
    }

    public Member getNode(Controller controller, boolean bl) {
        Reject.ifNull(controller, "Controller is null");
        Member member = controller.getNodeManager().getNode(this);
        if (member == null && bl) {
            member = controller.getNodeManager().addNode(this);
        }
        return member;
    }

    public MemberInfo intern() {
        if (INTERNALIZER == null) {
            return this;
        }
        return INTERNALIZER.intern(this);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode0();
        }
        return this.hash;
    }

    public int hashCode0() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MemberInfo) {
            MemberInfo memberInfo = (MemberInfo)object;
            return Util.equals(this.id, memberInfo.id);
        }
        return false;
    }

    public String toString() {
        return "Member '" + this.nick + "'" + (String)(this.connectAddress != null ? " (" + this.connectAddress + ")" : "");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.networkId == null) {
            this.networkId = ConfigurationEntry.NETWORK_ID.getDefaultValue();
        }
    }

    public static MemberInfo readExt(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        MemberInfo memberInfo = new MemberInfo();
        memberInfo.readExternal(objectInput);
        return memberInfo;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", expected: 100");
        }
        this.id = objectInput.readUTF();
        this.nick = objectInput.readUTF();
        this.networkId = ExternalizableUtil.readString(objectInput);
        if (this.networkId == null) {
            this.networkId = ConfigurationEntry.NETWORK_ID.getDefaultValue();
        }
        this.connectAddress = ExternalizableUtil.readAddress(objectInput);
        this.lastConnectTime = ExternalizableUtil.readDate(objectInput);
        this.isConnected = objectInput.readBoolean();
        this.isSupernode = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(100L);
        objectOutput.writeUTF(this.id);
        objectOutput.writeUTF(this.nick);
        ExternalizableUtil.writeString(objectOutput, this.networkId);
        ExternalizableUtil.writeAddress(objectOutput, this.connectAddress);
        ExternalizableUtil.writeDate(objectOutput, this.lastConnectTime);
        objectOutput.writeBoolean(this.isConnected);
        objectOutput.writeBoolean(this.isSupernode);
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof NodeInfoProto.NodeInfo) {
            NodeInfoProto.NodeInfo nodeInfo = (NodeInfoProto.NodeInfo)abstractMessage;
            this.id = nodeInfo.getId();
            this.nick = nodeInfo.getNick();
            this.networkId = nodeInfo.getNetworkId();
            this.connectAddress = new InetSocketAddress(nodeInfo.getHost(), nodeInfo.getPort());
            this.d2dPort = nodeInfo.getPort();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        NodeInfoProto.NodeInfo.Builder builder = NodeInfoProto.NodeInfo.newBuilder();
        builder.setClazzName("NodeInfo");
        builder.setId(this.id);
        builder.setNick(this.nick);
        builder.setNetworkId(this.networkId);
        if (this.connectAddress != null) {
            builder.setHost(this.connectAddress.getHostName());
        }
        builder.setPort(this.d2dPort);
        return builder.build();
    }
}

