/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FolderStatisticInfo
extends Loggable
implements Serializable {
    private static final int MAX_FILE_SIZE = 512000;
    private static final long serialVersionUID = 1L;
    private FolderInfo folder;
    private volatile long totalSize;
    private volatile long archiveSize;
    private volatile long blocks;
    private volatile int totalFilesCount;
    private volatile transient Date estimatedSyncDate;
    private volatile int incomingFilesCount;
    private transient int analyzedFiles;
    private final Map<MemberInfo, Integer> filesCount = new HashMap<MemberInfo, Integer>();
    private final Map<MemberInfo, Integer> filesCountInSync = new HashMap<MemberInfo, Integer>();
    private final Map<MemberInfo, Long> sizes = new HashMap<MemberInfo, Long>();
    private final Map<MemberInfo, Long> sizesInSync = new HashMap<MemberInfo, Long>();
    private transient Map<MemberInfo, Map<FileInfo, Long>> partialSyncStatMap = Util.createConcurrentHashMap();

    public FolderStatisticInfo(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder");
        this.folder = folderInfo;
    }

    public FolderInfo getFolder() {
        return this.folder;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long l) {
        this.totalSize = l;
    }

    public int getTotalFilesCount() {
        return this.totalFilesCount;
    }

    public long getArchiveSize() {
        return this.archiveSize;
    }

    public void setArchiveSize(long l) {
        this.archiveSize = l;
    }

    public void setTotalFilesCount(int n) {
        this.totalFilesCount = n;
    }

    public Date getEstimatedSyncDate() {
        return this.estimatedSyncDate;
    }

    public void setEstimatedSyncDate(Date date) {
        this.estimatedSyncDate = date;
    }

    public int getIncomingFilesCount() {
        return this.incomingFilesCount;
    }

    public void setIncomingFilesCount(int n) {
        this.incomingFilesCount = n;
    }

    public int getAnalyzedFiles() {
        return this.analyzedFiles;
    }

    public void setAnalyzedFiles(int n) {
        this.analyzedFiles = n;
    }

    public Map<MemberInfo, Integer> getFilesCount() {
        return this.filesCount;
    }

    public Integer getFilesCount(MemberInfo memberInfo) {
        return this.filesCount.get(memberInfo);
    }

    public Map<MemberInfo, Integer> getFilesCountInSync() {
        return this.filesCountInSync;
    }

    public Map<MemberInfo, Long> getSizes() {
        return this.sizes;
    }

    public Long getSize(MemberInfo memberInfo) {
        return this.sizes.get(memberInfo);
    }

    public Map<MemberInfo, Long> getSizesInSync() {
        return this.sizesInSync;
    }

    public Map<MemberInfo, Map<FileInfo, Long>> getPartialSyncStatMap() {
        if (this.partialSyncStatMap == null) {
            this.partialSyncStatMap = Util.createConcurrentHashMap();
        }
        return this.partialSyncStatMap;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public void setBlocks(long l) {
        this.blocks = l;
    }

    public double getSyncPercentage(MemberInfo memberInfo) {
        Long l = this.sizesInSync.get(memberInfo);
        if (l == null) {
            l = 0L;
        }
        if (this.totalSize == 0L) {
            return 100.0;
        }
        if (l == 0L) {
            return 0.0;
        }
        Map<FileInfo, Long> map = this.getPartialSyncStatMap().get(memberInfo);
        long l2 = 0L;
        if (map != null) {
            for (FileInfo fileInfo : map.keySet()) {
                Long l3 = map.get(fileInfo);
                if (l3 == null) continue;
                l2 += l3.longValue();
            }
        }
        double d = 100.0 * (double)(l + l2) / (double)this.totalSize;
        if (this.isFiner()) {
            this.logFiner("Sync for member " + memberInfo.nick + ", " + l + " + " + l2 + " / " + this.totalSize + " = " + d + ". map: " + map);
        }
        if (Double.compare(d, 100.0) > 0) {
            this.logFiner("Sync percentage > 100% - folder=" + this.folder.getLocalizedName() + ", member=" + memberInfo.nick + ", sync=" + d);
            d = 100.0;
        }
        return d;
    }

    public double getAverageSyncPercentage() {
        if (this.sizesInSync.isEmpty()) {
            return 100.0;
        }
        double d = 0.0;
        for (MemberInfo memberInfo : this.sizesInSync.keySet()) {
            d += this.getSyncPercentage(memberInfo);
        }
        double d2 = d / (double)this.sizesInSync.size();
        if (Double.compare(d2, 100.0) > 0) {
            this.logWarning("Average sync percentage > 100% - folder=" + this.folder.getLocalizedName() + ", sync=" + d2);
            d2 = 100.0;
        }
        return d2;
    }

    public Member getServerNode(Controller controller) {
        for (MemberInfo memberInfo : this.filesCount.keySet()) {
            Member member = memberInfo.getNode(controller, false);
            if (member == null || !member.isServer()) continue;
            return member;
        }
        return null;
    }

    public boolean save(Path path) {
        if (this.isFiner()) {
            this.logFiner("Writing folder " + this.folder.getName() + " stats to " + path);
        }
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            return false;
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            objectOutputStream.writeObject(this);
        }
        catch (Exception exception) {
            this.logWarning("Unable to store stats for folder " + this.folder.getName() + " to " + path + ". " + exception);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FolderStatisticInfo load(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try {
            if (Files.size(path) > 512000L) {
                Logger.getLogger(FolderStatisticInfo.class.getName()).warning("Not reading folder stats from " + path + ". File is too big: " + Format.formatBytes(Files.size(path)));
                return null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(FolderStatisticInfo.class.getName()).fine("Unable to read folder stats size from " + path + ". " + iOException);
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
            FolderStatisticInfo folderStatisticInfo2 = (FolderStatisticInfo)objectInputStream.readObject();
            if (!folderStatisticInfo2.isValid()) return null;
            FolderStatisticInfo folderStatisticInfo = folderStatisticInfo2;
            return folderStatisticInfo;
        }
        catch (Exception exception) {
            Logger.getLogger(FolderStatisticInfo.class.getName()).fine("Unable to read folder stats from " + path + ". " + exception);
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logger.getLogger(FolderStatisticInfo.class.getName()).warning("Unable to read folder stats from " + path + ". " + outOfMemoryError);
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.partialSyncStatMap == null) {
            this.partialSyncStatMap = Util.createConcurrentHashMap();
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.archiveSize ^ this.archiveSize >>> 32);
        n = 31 * n + (this.filesCount == null ? 0 : this.filesCount.hashCode());
        n = 31 * n + (this.filesCountInSync == null ? 0 : this.filesCountInSync.hashCode());
        n = 31 * n + (this.folder == null ? 0 : this.folder.hashCode());
        n = 31 * n + this.incomingFilesCount;
        n = 31 * n + (this.sizes == null ? 0 : this.sizes.hashCode());
        n = 31 * n + (this.sizesInSync == null ? 0 : this.sizesInSync.hashCode());
        n = 31 * n + this.totalFilesCount;
        n = 31 * n + (int)(this.totalSize ^ this.totalSize >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FolderStatisticInfo)) {
            return false;
        }
        FolderStatisticInfo folderStatisticInfo = (FolderStatisticInfo)object;
        if (this.archiveSize != folderStatisticInfo.archiveSize) {
            return false;
        }
        if (!Util.equals(this.filesCount, folderStatisticInfo.filesCount)) {
            return false;
        }
        if (!Util.equals(this.filesCountInSync, folderStatisticInfo.filesCountInSync)) {
            return false;
        }
        if (!Util.equals(this.folder, folderStatisticInfo.folder)) {
            return false;
        }
        if (this.incomingFilesCount != folderStatisticInfo.incomingFilesCount) {
            return false;
        }
        if (!Util.equals(this.sizes, folderStatisticInfo.sizes)) {
            return false;
        }
        if (!Util.equals(this.sizesInSync, folderStatisticInfo.sizesInSync)) {
            return false;
        }
        if (this.totalFilesCount != folderStatisticInfo.totalFilesCount) {
            return false;
        }
        return this.totalSize == folderStatisticInfo.totalSize;
    }

    public boolean isValid() {
        return this.folder != null && this.filesCount != null && this.filesCountInSync != null && this.sizes != null && this.sizesInSync != null && this.partialSyncStatMap != null;
    }

    public String toString() {
        return "FolderStatisticInfo [folder=" + this.folder + ", totalSize=" + this.totalSize + ", archiveSize=" + this.archiveSize + ", totalFilesCount=" + this.totalFilesCount + ", estimatedSyncDate=" + this.estimatedSyncDate + ", incomingFilesCount=" + this.incomingFilesCount + ", analyzedFiles=" + this.analyzedFiles + ", filesCount=" + this.filesCount + ", filesCountInSync=" + this.filesCountInSync + ", sizes=" + this.sizes + ", sizesInSync=" + this.sizesInSync + ", partialSyncStatMap=" + this.partialSyncStatMap + "]";
    }

    public static void main(String ... stringArray) {
        FolderStatisticInfo folderStatisticInfo = FolderStatisticInfo.load(FileSystems.getDefault().getPath("FolderStatistic", new String[0]));
        System.out.println(folderStatisticInfo);
    }
}

