/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.RemoteCommandManager;
import de.dal33t.powerfolder.distribution.Standard;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class PowerFolderDrive
extends Standard {
    @Override
    public void init(Controller controller) {
        super.init(controller);
        RemoteCommandManager.sendCommand("QUIT");
        if (!OSUtil.isWindowsSystem()) {
            return;
        }
        try {
            Path path = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve("PowerFolder");
            Path path2 = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve("TERRA Drive");
            if (Files.exists(path2, new LinkOption[0]) && Files.notExists(path, new LinkOption[0])) {
                Files.move(path2, path, new CopyOption[0]);
                this.logInfo("Moved TERRA Drive config from " + path2 + " to " + path);
            } else {
                Properties properties = this.loadConfig("TERRA Drive");
                if (properties != null && !properties.isEmpty()) {
                    this.cleanupConfig(properties);
                    ConfigurationLoader.merge(properties, controller);
                    this.saveConfig(() -> this.deleteConfig("TERRA Drive"));
                    this.logInfo("Merged TERRA Drive config");
                }
            }
        }
        catch (Exception exception) {
            this.logWarning("Migration of config failed. " + exception, exception);
        }
        try {
            this.startUninstallation("C:\\Program Files\\TERRA Cloud GmbH\\TERRA_Drive\\uninstall.exe");
            this.startUninstallation("C:\\Program Files (x86)\\TERRA Cloud GmbH\\TERRA_Drive\\uninstall.exe");
        }
        catch (Exception exception) {
            this.logWarning("Uninstallation of TERRA Drive client failed. " + exception, exception);
        }
    }

    private void cleanupConfig(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            if (string.startsWith("config.")) {
                properties.remove(string);
            }
            if (string.startsWith("dist.")) {
                properties.remove(string);
            }
            if (string.startsWith("provider.")) {
                properties.remove(string);
            }
            if (string.startsWith("provider.")) {
                properties.remove(string);
            }
            if (string.startsWith("update.")) {
                properties.remove(string);
            }
            if (!string.startsWith("nodeid")) continue;
            properties.remove(string);
        }
    }

    private Properties loadConfig(String string) {
        Object object;
        Properties properties = new Properties();
        Path path = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder.config");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                object = Files.newInputStream(path, new OpenOption[0]);
                try {
                    properties.load((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                this.logWarning("Could not read " + path.toString() + ". " + iOException.getMessage());
            }
        }
        if (Files.exists((Path)(object = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder-Folder.config")), new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream((Path)object, new OpenOption[0]);){
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                this.logWarning("Could not read " + object.toString() + ". " + iOException.getMessage());
            }
        }
        return properties;
    }

    private void deleteConfig(String string) {
        Path path = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder-Folder.config");
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            this.logWarning("Could not delete " + path.toString() + ". " + iOException.getMessage());
        }
        Path path2 = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder.config");
        try {
            Files.deleteIfExists(path2);
        }
        catch (IOException iOException) {
            this.logWarning("Could not delete " + path2.toString() + ". " + iOException.getMessage());
        }
    }

    private void startUninstallation(String string) {
        boolean bl = Files.exists(Path.of(string, new String[0]), new LinkOption[0]);
        if (!bl) {
            return;
        }
        this.logInfo("Starting uninstallation: " + string);
        try {
            File file = File.createTempFile("Elevate", ".cmd");
            file.delete();
            Util.copyResourceTo("Elevate.cmd", null, file.toPath(), false, true);
            String[] stringArray = new String[]{file.getAbsolutePath(), string};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            this.logWarning("Exception while executing uninstallation: " + string + ". " + iOException, iOException);
        }
        bl = Files.exists(Path.of(string, new String[0]), new LinkOption[0]);
        if (!bl) {
            return;
        }
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            this.logWarning("Exception while executing uninstallation: " + string + ". " + iOException, iOException);
        }
    }

    private void saveConfig(Runnable runnable) {
        if (this.getController().isStarted()) {
            this.getController().saveConfig();
            runnable.run();
        } else {
            this.getController().schedule(() -> {
                Waiter waiter = new Waiter(60000L);
                while (!waiter.isTimeout()) {
                    if (this.getController().isStarted()) {
                        this.getController().saveConfig();
                        runnable.run();
                        break;
                    }
                    waiter.waitABit();
                }
            }, 5000L);
        }
    }
}

