/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.distribution.Distribution;
import de.dal33t.powerfolder.distribution.PowerFolderBasic;
import de.dal33t.powerfolder.distribution.PowerFolderPro;
import de.dal33t.powerfolder.net.RelayFinder;
import de.dal33t.powerfolder.net.RelayedConnectionManager;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public abstract class AbstractDistribution
extends Loggable
implements Distribution {
    private static final String[] POWERFOLDER_DISTRIBUTIONS = new String[]{PowerFolderPro.class.getName(), PowerFolderBasic.class.getName(), "de.dal33t.powerfolder.distribution.PowerFolderGeneric"};
    private static final String DEFAULT_CONFIG_FILENAME = "Default.config";
    private Controller controller;

    @Override
    public void init(Controller controller) {
        this.controller = controller;
    }

    @Override
    public RelayFinder createRelayFinder() {
        return new RelayedConnectionManager.ServerIsRelayFinder();
    }

    protected Controller getController() {
        return this.controller;
    }

    protected boolean addTranslation(String string) {
        String string2 = "Translation_" + string + ".properties";
        if (Thread.currentThread().getContextClassLoader().getResourceAsStream(string2) != null) {
            Locale locale = new Locale(string);
            Translation.addSupportedLocales(locale);
            Translation.resetResourceBundle();
            this.logInfo("Translation file loaded: " + string2);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBrandedClient() {
        for (String string : POWERFOLDER_DISTRIBUTIONS) {
            if (!string.equals(this.getClass().getName())) continue;
            return false;
        }
        return true;
    }

    protected boolean loadPreConfigFromClasspath(Controller controller, Boolean bl) {
        Reject.ifNull(controller, "Controller");
        try {
            Properties properties = ConfigurationLoader.loadPreConfigFromClasspath(DEFAULT_CONFIG_FILENAME);
            boolean bl2 = bl != null ? bl : ConfigurationLoader.overwriteConfigEntries(properties);
            int n = ConfigurationLoader.merge(properties, controller.getConfig(), controller.getPreferences(), bl2);
            this.logFine("Loaded " + n + " preconfiguration file Default.config from jar file");
            return true;
        }
        catch (IOException iOException) {
            this.logSevere("Error while loading Default.config from jar file", iOException);
            return false;
        }
    }

    protected boolean loadPreConfigFromClasspath(Controller controller) {
        return this.loadPreConfigFromClasspath(controller, true);
    }

    protected static final void removeValue(Controller controller, ConfigurationEntry configurationEntry) {
        configurationEntry.removeValue(controller);
    }

    protected static final void resetServer(Controller controller) {
        AbstractDistribution.removeValue(controller, ConfigurationEntry.SERVER_NAME);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.SERVER_WEB_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.SERVER_NODEID);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.SERVER_HOST);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL);
    }

    protected static final void resetNetworkID(Controller controller) {
        AbstractDistribution.removeValue(controller, ConfigurationEntry.NETWORK_ID);
    }

    protected static final void resetProviderURLs(Controller controller) {
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_ABOUT_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_QUICKSTART_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_SUPPORT_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_SUPPORT_FILE_TICKET_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_BUY_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_CONTACT_URL);
        AbstractDistribution.removeValue(controller, ConfigurationEntry.PROVIDER_WIKI_URL);
    }

    protected static final void setAppName(String string) {
        Translation.setPlaceHolder("APPNAME", string);
    }

    protected static final void setAppDescription(String string) {
        Translation.setPlaceHolder("APPDESCRIPTION", string);
    }

    protected static final void setFoldersBaseDirName(Controller controller, String string) {
        if (!ConfigurationEntry.FOLDER_BASEDIR.hasValue(controller)) {
            String string2 = ConfigurationEntry.FOLDER_BASEDIR.getDefaultValue().replace(Constants.FOLDERS_BASE_DIR_SUBDIR_NAME, string);
            ConfigurationEntry.FOLDER_BASEDIR.setValue(controller, string2);
        } else {
            Constants.FOLDERS_BASE_DIR_SUBDIR_NAME = string;
        }
    }
}

