/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FolderDBMaintCommando;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.util.Date;

public class FolderDatabaseProblem
extends ResolvableProblem {
    private FolderInfo folderInfo;

    public FolderDatabaseProblem(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "FolderInfo");
        this.folderInfo = folderInfo;
    }

    @Override
    public String getDescription() {
        return Translation.get("folder_problem.folderdb.description", this.folderInfo.getLocalizedName());
    }

    @Override
    public String getWikiLinkKey() {
        return "Folder-Database";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folderInfo.getFolder(controller);
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("folder_problem.folderdb.description");
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                final Folder folder = FolderDatabaseProblem.this.folderInfo.getFolder(controller);
                if (folder == null) {
                    return;
                }
                controller.getIOProvider().startIO(new Runnable(){

                    @Override
                    public void run() {
                        folder.removeProblem(FolderDatabaseProblem.this);
                        folder.broadcastMessages(new FolderDBMaintCommando(FolderDatabaseProblem.this.folderInfo, new Date()));
                        folder.maintainFolderDB(System.currentTimeMillis());
                    }
                });
            }
        };
    }

    public String toString() {
        return this.getDescription();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.folderInfo == null ? 0 : this.folderInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FolderDatabaseProblem folderDatabaseProblem = (FolderDatabaseProblem)object;
        return !(this.folderInfo == null ? folderDatabaseProblem.folderInfo != null : !this.folderInfo.equals(folderDatabaseProblem.folderInfo));
    }
}

