/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.util.Reject;
import java.io.Serializable;

public class SyncProfileConfiguration
implements Serializable {
    private static final long serialVersionUID = 100L;
    public static final int DAILY_HOUR_DEFAULT = 12;
    public static final int DAILY_DAY_EVERY_DAY = 0;
    public static final int DAILY_DAY_WEEKDAYS = 8;
    public static final int DAILY_DAY_WEEKENDS = 9;
    public static final String REGULAR_TIME_TYPE_HOURS = "h";
    public static final String REGULAR_TIME_TYPE_MINUTES = "m";
    public static final String REGULAR_TIME_TYPE_SECONDS = "s";
    private final boolean autoDownloadFromFriends;
    private final boolean autoDownloadFromOthers;
    private final boolean syncDeletionWithFriends;
    private final boolean syncDeletionWithOthers;
    private final int timeBetweenRegularScans;
    private final boolean dailySync;
    private final int dailyHour;
    private final int dailyDay;
    private final String regularTimeType;
    private final boolean instantSync;

    public SyncProfileConfiguration(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this(bl, bl2, bl3, bl4, n, false, 12, 0, REGULAR_TIME_TYPE_MINUTES, false);
    }

    public SyncProfileConfiguration(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, int n2, int n3, String string, boolean bl6) {
        Reject.ifBlank(string, "Missing regularTimeType");
        this.autoDownloadFromFriends = bl;
        this.autoDownloadFromOthers = bl2;
        this.syncDeletionWithFriends = bl3;
        this.syncDeletionWithOthers = bl4;
        this.timeBetweenRegularScans = n;
        this.dailySync = bl5;
        this.dailyHour = n2;
        this.dailyDay = n3;
        this.regularTimeType = string;
        this.instantSync = bl6;
    }

    public boolean isAutoDownload() {
        return this.autoDownloadFromFriends || this.autoDownloadFromOthers;
    }

    public boolean isSyncDeletion() {
        return this.syncDeletionWithFriends || this.syncDeletionWithOthers;
    }

    public int getTimeBetweenRegularScans() {
        return this.timeBetweenRegularScans;
    }

    public boolean isPeriodicSync() {
        return !this.instantSync && !this.dailySync;
    }

    public boolean isManualSync() {
        return this.isPeriodicSync() && this.timeBetweenRegularScans == 0;
    }

    public boolean isDailySync() {
        return !this.instantSync && this.dailySync;
    }

    public boolean isInstantSync() {
        return this.instantSync;
    }

    public int getDailyHour() {
        return this.dailyHour;
    }

    public int getDailyDay() {
        return this.dailyDay;
    }

    public String getRegularTimeType() {
        return this.regularTimeType;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.autoDownloadFromFriends ? 1231 : 1237);
        n = 31 * n + (this.autoDownloadFromOthers ? 1231 : 1237);
        n = 31 * n + this.dailyDay;
        n = 31 * n + this.dailyHour;
        n = 31 * n + (this.dailySync ? 1231 : 1237);
        n = 31 * n + (this.instantSync ? 1231 : 1237);
        n = 31 * n + (this.regularTimeType == null ? 0 : this.regularTimeType.hashCode());
        n = 31 * n + (this.syncDeletionWithFriends ? 1231 : 1237);
        n = 31 * n + (this.syncDeletionWithOthers ? 1231 : 1237);
        n = 31 * n + this.timeBetweenRegularScans;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SyncProfileConfiguration syncProfileConfiguration = (SyncProfileConfiguration)object;
        if (this.autoDownloadFromFriends != syncProfileConfiguration.autoDownloadFromFriends) {
            return false;
        }
        if (this.autoDownloadFromOthers != syncProfileConfiguration.autoDownloadFromOthers) {
            return false;
        }
        if (this.dailyDay != syncProfileConfiguration.dailyDay) {
            return false;
        }
        if (this.dailyHour != syncProfileConfiguration.dailyHour) {
            return false;
        }
        if (this.dailySync != syncProfileConfiguration.dailySync) {
            return false;
        }
        if (this.instantSync != syncProfileConfiguration.instantSync) {
            return false;
        }
        if (this.regularTimeType == null ? syncProfileConfiguration.regularTimeType != null : !this.regularTimeType.equals(syncProfileConfiguration.regularTimeType)) {
            return false;
        }
        if (this.syncDeletionWithFriends != syncProfileConfiguration.syncDeletionWithFriends) {
            return false;
        }
        if (this.syncDeletionWithOthers != syncProfileConfiguration.syncDeletionWithOthers) {
            return false;
        }
        return this.timeBetweenRegularScans == syncProfileConfiguration.timeBetweenRegularScans;
    }

    public String toString() {
        return "SyncProfileConfiguration{autoDownloadFromFriends=" + this.autoDownloadFromFriends + ", autoDownloadFromOthers=" + this.autoDownloadFromOthers + ", syncDeletionWithFriends=" + this.syncDeletionWithFriends + ", syncDeletionWithOthers=" + this.syncDeletionWithOthers + ", timeBetweenRegularScans=" + this.timeBetweenRegularScans + ", dailySync=" + this.dailySync + ", dailyHour=" + this.dailyHour + ", dailyDay=" + this.dailyDay + ", regularTimeType='" + this.regularTimeType + "', instantScan=" + this.instantSync + "}";
    }
}

