/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Reject;
import java.io.Serializable;
import java.util.Date;

public class Lock
implements Serializable {
    private static final long serialVersionUID = 100L;
    private Date created;
    private FileInfo fileInfo;
    private MemberInfo memberInfo;
    private AccountInfo accountInfo;

    public Lock(FileInfo fileInfo, MemberInfo memberInfo, AccountInfo accountInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        this.created = new Date();
        this.fileInfo = fileInfo;
        this.memberInfo = memberInfo;
        this.accountInfo = accountInfo;
    }

    public Date getCreated() {
        return this.created;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public MemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public String getAccountDisplayName() {
        return this.accountInfo != null ? this.accountInfo.getDisplayName() : "";
    }

    public String toString() {
        return "Lock [fileInfo=" + this.fileInfo.toDetailString() + ", created=" + this.created + ", accountInfo=" + this.accountInfo + ", memberInfo=" + this.memberInfo + "]";
    }
}

