/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.EncryptedFileSystemUtils;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;

public class FolderWatcher
extends PFComponent {
    private static Boolean LIB_LOADED;
    private Folder folder;
    private volatile int watchID = -1;
    private NotifyListener listener;
    private Map<String, FileInfo> dirtyFiles = Util.createConcurrentHashMap();
    private volatile boolean ignoreAll;
    private Map<FileInfo, FileInfo> ignoreFiles = Util.createConcurrentHashMap();
    private AtomicBoolean scheduled = new AtomicBoolean(false);
    private ReentrantLock scannerLock = new ReentrantLock();
    private long delay;

    FolderWatcher(Folder folder) {
        super(folder.getController());
        this.folder = folder;
        this.listener = new NotifyListener();
        this.reconfigure(folder.getSyncProfile());
    }

    public boolean isSupported() {
        return ConfigurationEntry.FOLDER_WATCHER_ENABLED.getValueBoolean(this.getController()) != false && FolderWatcher.isLibLoaded();
    }

    void addIgnoreFile(FileInfo fileInfo) {
        if (!this.isSupported()) {
            return;
        }
        Reject.ifNull(fileInfo, "FileInfo");
        this.ignoreFiles.put(fileInfo, fileInfo);
        if (this.isFiner()) {
            this.logFiner("Added to ignore: " + fileInfo.toDetailString());
        }
    }

    void removeIgnoreFile(final FileInfo fileInfo) {
        if (!this.isSupported()) {
            return;
        }
        Reject.ifNull(fileInfo, "FileInfo");
        this.getController().schedule(new TimerTask(){

            @Override
            public void run() {
                FolderWatcher.this.ignoreFiles.remove(fileInfo.getRelativeName());
                if (FolderWatcher.this.isFiner()) {
                    FolderWatcher.this.logFiner("Removed from ignore: " + fileInfo.toDetailString());
                }
            }
        }, 1000L);
    }

    public void setIngoreAll(boolean bl) {
        this.ignoreAll = bl;
    }

    public static synchronized boolean isLibLoaded() {
        if (LIB_LOADED == null) {
            try {
                System.setProperty("file.encoding", "UTF8");
                LIB_LOADED = OSUtil.loadLibrary(JNotify.class, "jnotify");
            }
            catch (Error error) {
                LIB_LOADED = false;
            }
        }
        return LIB_LOADED;
    }

    synchronized void remove() {
        if (!FolderWatcher.isLibLoaded()) {
            return;
        }
        if (this.watchID >= 0) {
            try {
                JNotify.removeWatch(this.watchID);
            }
            catch (JNotifyException jNotifyException) {
                if (this.isFine()) {
                    this.logFine("Failed to remove watch from folder " + this.folder.getName() + " at path " + this.folder.getLocalBase() + jNotifyException);
                }
            }
            finally {
                this.watchID = -1;
            }
        }
    }

    synchronized void reconfigure(SyncProfile syncProfile) {
        if (!this.isSupported()) {
            return;
        }
        if (EncryptedFileSystemUtils.isCryptoInstance(this.folder.getLocalBase())) {
            return;
        }
        if (!syncProfile.isInstantSync()) {
            this.remove();
            return;
        }
        if (this.folder.getInfo().isMetaFolder()) {
            this.remove();
            return;
        }
        if (this.folder.checkIfDeviceDisconnected()) {
            this.remove();
            return;
        }
        if (!this.folder.getLocalBase().getFileSystem().provider().getScheme().equals("file")) {
            this.remove();
            return;
        }
        String string = this.folder.getLocalBase().toAbsolutePath().toString();
        if (string.startsWith("\\")) {
            this.remove();
            return;
        }
        if (this.watchID >= 0) {
            return;
        }
        this.delay = 1000L * (long)ConfigurationEntry.FOLDER_WATCHER_DELAY.getValueInt(this.getController()).intValue();
        try {
            this.watchID = JNotify.addWatch(string, 15, true, this.listener);
            this.logFine("Initialized filesystem watch(" + this.watchID + ") on " + string + " / " + this.folder);
        }
        catch (JNotifyException jNotifyException) {
            this.logWarning("Unable to initialize filesystem watch for " + this.folder + ". " + jNotifyException);
            this.logFiner(jNotifyException);
            this.watchID = -1;
        }
    }

    static /* synthetic */ void access$900(FolderWatcher folderWatcher, String string) {
        folderWatcher.logFine(string);
    }

    static /* synthetic */ boolean access$1000(FolderWatcher folderWatcher) {
        return folderWatcher.isFine();
    }

    static /* synthetic */ void access$1100(FolderWatcher folderWatcher, String string) {
        folderWatcher.logFine(string);
    }

    static /* synthetic */ void access$1200(FolderWatcher folderWatcher, String string, Throwable throwable) {
        folderWatcher.logSevere(string, throwable);
    }

    private class NotifyListener
    implements JNotifyListener {
        private NotifyListener() {
        }

        @Override
        public void fileRenamed(int n, String string, String string2, String string3) {
            this.fileChanged(string, string2);
            this.fileChanged(string, string3);
        }

        @Override
        public void fileModified(int n, String string, String string2) {
            this.fileChanged(string, string2);
        }

        @Override
        public void fileDeleted(int n, String string, String string2) {
            this.fileChanged(string, string2);
        }

        @Override
        public void fileCreated(int n, String string, String string2) {
            this.fileChanged(string, string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fileChanged(String string, String string2) {
            if (FolderWatcher.this.watchID < 0) {
                return;
            }
            if (!FolderWatcher.this.isSupported()) {
                return;
            }
            if (!FolderWatcher.this.folder.isStarted()) {
                return;
            }
            if (!FolderWatcher.this.folder.scanAllowedNow()) {
                return;
            }
            if (!PathUtils.isScannable(string2, FolderWatcher.this.folder)) {
                return;
            }
            if (FileProblemHelper.is8dot3Notation(string2)) {
                return;
            }
            if (FolderWatcher.this.ignoreAll) {
                return;
            }
            if (OSUtil.isMacOS() && string2.contains("?")) {
                return;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                string2 = PathUtils.getDiskFileName(string, string2);
                string2 = FileInfoFactory.decodeIllegalChars(string2);
                if (FolderWatcher.this.dirtyFiles.containsKey(string2)) {
                    return;
                }
                FileInfo fileInfo = this.lookupInstance(string, string2);
                if (FolderWatcher.this.ignoreFiles.containsKey(fileInfo)) {
                    return;
                }
                Map map = FolderWatcher.this.dirtyFiles;
                synchronized (map) {
                    FolderWatcher.this.dirtyFiles.put(string2, fileInfo);
                }
                if (!FolderWatcher.this.scannerLock.isLocked() && FolderWatcher.this.scheduled.compareAndSet(false, true)) {
                    FolderWatcher.this.getController().schedule(new Runnable(){

                        @Override
                        public void run() {
                            FolderWatcher.this.scheduled.set(false);
                            new DirtyFilesScanner().run();
                        }
                    }, FolderWatcher.this.delay);
                }
            }
            catch (Exception exception) {
                FolderWatcher.this.logSevere("Unable to enqueue changed file for scan: " + string + ", " + string2 + ". " + exception, exception);
            }
        }

        private FileInfo lookupInstance(String string, String string2) {
            String string3 = string2;
            if (string3.contains("\\")) {
                string3 = string3.replace('\\', '/');
            }
            if (string3.contains("//")) {
                string3 = string3.replace("//", "/");
            }
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            return FileInfoFactory.lookupInstance(FolderWatcher.this.folder.getInfo(), string3);
        }
    }

    private class DirtyFilesScanner
    implements Runnable {
        private DirtyFilesScanner() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

