/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Translation;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgreeToSListener
extends PFComponent
implements ServerClientListener {
    private boolean wasPaused = false;
    private boolean changedPause = false;
    private boolean agreedOnToS = true;
    private boolean autoOpenBrowser = true;
    private ToSNotice tosn = new ToSNotice(Translation.get("dialog.tos.title"), Translation.get("dialog.tos.summary"), Translation.get("dialog.tos.text"));

    public AgreeToSListener(Controller controller) {
        super(controller);
    }

    @Override
    public boolean fireInEventDispatchThread() {
        return false;
    }

    public void setAutoOpenBrowser(boolean bl) {
        this.autoOpenBrowser = bl;
    }

    @Override
    public void login(ServerClientEvent serverClientEvent) {
        Account account = serverClientEvent.getAccountDetails().getAccount();
        if (!serverClientEvent.isLoginSuccess() || !account.isValid()) {
            return;
        }
        try {
            ServerClient serverClient = serverClientEvent.getClient();
            if (serverClientEvent.getAccountDetails().needsToAgreeToS()) {
                this.wasPaused = this.getController().isPaused();
                this.agreedOnToS = false;
                this.changedPause = true;
                this.getController().setPaused(true);
                this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(this.tosn);
                if (this.autoOpenBrowser) {
                    DialogFactory.genericDialog(this.getController(), Translation.get("dialog.tos.title"), Translation.get("dialog.tos.text"), new String[]{"OK"}, 0, GenericDialogType.INFO);
                    this.getController().getIOProvider().startIO(() -> {
                        try {
                            BrowserLauncher.openURL(serverClient.getLoginURLWithCredentials());
                        }
                        catch (IOException iOException) {
                            this.logWarning("Could not open browser to view ToS. " + iOException);
                        }
                    });
                }
            } else {
                this.agreedOnToS = true;
                this.getController().getUIController().getApplicationModel().getNoticesModel().clearNotice(this.tosn);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Error during check if terms of service apply. " + runtimeException);
        }
    }

    @Override
    public void accountUpdated(ServerClientEvent serverClientEvent) {
        if (!serverClientEvent.getAccountDetails().needsToAgreeToS()) {
            if (this.changedPause) {
                this.getController().setPaused(this.wasPaused);
            }
            this.getController().getUIController().getApplicationModel().getNoticesModel().clearNotice(this.tosn);
            this.agreedOnToS = true;
        }
    }

    public boolean hasAgreedOnToS() {
        return this.agreedOnToS;
    }

    @Override
    public void serverConnected(ServerClientEvent serverClientEvent) {
    }

    @Override
    public void serverDisconnected(ServerClientEvent serverClientEvent) {
    }

    @Override
    public void childClientSpawned(ServerClientEvent serverClientEvent) {
    }

    @Override
    public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        this.getController().getIOProvider().startIO(() -> {
            if (!serverClientEvent.getClient().isLoggedIn()) {
                return;
            }
            AccountDetails accountDetails = serverClientEvent.getClient().refreshAccountDetails();
            if (accountDetails.needsToAgreeToS()) {
                this.wasPaused = this.getController().isPaused();
                this.agreedOnToS = false;
                this.getController().setPaused(true);
                this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(this.tosn);
            }
        });
    }

    private static class ToSNotice
    extends WarningNotice {
        private static final long serialVersionUID = 100L;

        ToSNotice(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        public Runnable getPayload(Controller controller) {
            return () -> {
                DialogFactory.genericDialog(controller, this.getTitle(), this.getMessage(), new String[]{"OK"}, 0, GenericDialogType.INFO);
                controller.getIOProvider().startIO(() -> {
                    try {
                        String string = controller.getOSClient().getLoginURLWithCredentials();
                        BrowserLauncher.openURL(string);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ToSNotice.class.getName()).log(Level.WARNING, "Could not open browser to view ToS. " + iOException);
                    }
                });
            };
        }
    }
}

