/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.activity.domain;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import de.dal33t.powerfolder.activity.domain.ActivityType;
import de.dal33t.powerfolder.activity.domain.FileActivity;
import de.dal33t.powerfolder.activity.domain.InvitationActivity;
import de.dal33t.powerfolder.activity.domain.PermissionActivity;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.ActivityItemProto;
import de.dal33t.powerfolder.security.Account;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
public class ActivityItem
implements D2DObject {
    public static final String PROPERTY_CREATION_DATE = "creationDate";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_INITIATOR = "initiator";
    @Id
    @Column(length=32)
    private final String id;
    @Column(nullable=false)
    private final Date creationDate;
    @Enumerated(value=EnumType.STRING)
    @Index(name="IDX_ACTIVITY_TYPE")
    private final ActivityType type;
    @ManyToOne
    @JoinColumn(name="initiator_account_id")
    private final Account initiator;
    @ManyToOne
    @JoinColumn(name="file_activity_id")
    private final FileActivity fileActivity;
    @ManyToOne
    @JoinColumn(name="permission_activity_id")
    private final PermissionActivity permissionActivity;
    @ManyToOne
    @JoinColumn(name="invitation_activity_id")
    private final InvitationActivity invitationActivity;

    private ActivityItem() {
        this.id = null;
        this.creationDate = null;
        this.type = null;
        this.initiator = null;
        this.fileActivity = null;
        this.permissionActivity = null;
        this.invitationActivity = null;
    }

    ActivityItem(@NotNull Date date, @NotNull ActivityType activityType, @NotNull Account account, @Nullable FileActivity fileActivity, @Nullable PermissionActivity permissionActivity, @Nullable InvitationActivity invitationActivity) {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.creationDate = date;
        this.type = activityType;
        this.initiator = account;
        this.fileActivity = fileActivity;
        this.permissionActivity = permissionActivity;
        this.invitationActivity = invitationActivity;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    @NotNull
    public ActivityType getType() {
        return this.type;
    }

    @Nullable
    public Account getInitiator() {
        return this.initiator;
    }

    @Nullable
    public FileActivity getFileActivity() {
        return this.fileActivity;
    }

    @Nullable
    public PermissionActivity getPermissionActivity() {
        return this.permissionActivity;
    }

    @Nullable
    public InvitationActivity getInvitationActivity() {
        return this.invitationActivity;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ActivityItem activityItem = (ActivityItem)object;
        return Objects.equals(this.id, activityItem.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        ActivityItemProto.ActivityItem.Builder builder = ActivityItemProto.ActivityItem.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setId(this.getId());
        if (this.getFileActivity() != null) {
            builder.setActivity(Any.pack(this.getFileActivity().toD2D()));
        } else if (this.getPermissionActivity() != null) {
            builder.setActivity(Any.pack(this.getPermissionActivity().toD2D()));
        } else if (this.getInvitationActivity() != null) {
            builder.setActivity(Any.pack(this.getInvitationActivity().toD2D()));
        }
        builder.setCreationDate(this.getCreationDate().getTime());
        builder.setActivityType(this.getType().toD2D());
        return builder.build();
    }
}

