/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public enum DocumentType {
    DOCUMENT("doc", "docx", "odt", "epub", "xps", "rtf"),
    SPREADSHEET("xls", "xlsx", "ods", "csv"),
    PRESENTATION("ppt", "pptx", "odp"),
    IMAGE("png", "jpg", "jpeg", "gif", "bmp", "tif", "tiff"),
    AUDIO("wav", "mp3", "ogg", "oga", "webma", "fla", "flac", "m3u8a", "rtmpa", "djvu"),
    VIDEO("mp4", "flv", "rtmp", "rtmpv", "m4v", "ogv", "webmv", "m3uv", "m3u8v", "mov", "webm"),
    PDF("pdf"),
    TEXT("txt");

    private Collection<String> extensions;

    private DocumentType(String ... stringArray) {
        this.extensions = Collections.unmodifiableCollection(Arrays.asList(stringArray));
    }

    public Collection<String> getExtensions() {
        return this.extensions;
    }

    public String toRegExp() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.extensions) {
            stringBuilder.append(string);
            stringBuilder.append("|");
        }
        Object object = stringBuilder.toString();
        if (((String)object).length() > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }
}

